<?php
/*--------------------------------------------------------------------------------------*\
*|        Script Manager                                                                                                                                                *|
*|        By                        ::        Parmeet Singh                                                                                                                *|
*|        Web-Site        ::        http://www.phpcafe.net                                                                                                *|
*|        Email                ::        parmeet@phpcafe.net                                                                                                        *|
*|                                                                                                                                                                                *|
*|        --------------------------------------------                                                                                *|
*|                                                                                                                                                                                *|
*|        You are not allowed to distribute this script in any way.                                                        *|
*|        This script is the property of Parmeet Singh.                                                                                *|
*|        You may not remove the copyright information unless you have special permission                *|
*|        from Parmeet Singh.                                                                                                                                        *|
\*--------------------------------------------------------------------------------------*/


/*----- Start Exec_Time class */

class Exec_Time
{
        // Finds out the startime time
        function startime( ) {
                global $startime;

                $mtime                 = microtime( );
                $mtime                 = explode( " " , $mtime );
                $mtime                 = $mtime[1] + $mtime[0];
                $startime         = $mtime;

                return $startime;
        }

        // Finds out the end time
        function endtime( ) {
                global $startime , $totaltime;

                $mtime                = microtime( );
                $mtime                = explode( " " , $mtime );
                $mtime                = $mtime[1] + $mtime[0];
                $endtime        = $mtime;
                $totaltime        = ( $endtime - $startime );
                $totaltime        = round( $totaltime , 4 );

                return $totaltime;
        }

}

/*----- End Exec_Time class */

/*----- Start Functions class */

class Functions {

        function parse( $template ,$toparse = array(),$lang_f = "" ) {
                GLOBAL $phpcafe,$func;

                $fp       = fopen( "{$phpcafe->vars['tmpl_dir']}$template.php" , "r" );
                $contents = fread( $fp , filesize( "{$phpcafe->vars['tmpl_dir']}$template.php" ) );
                fclose( $fp );

                if($lang_f        !=        "") {
                        $lang        =        $func->load_lang($lang_f);

                        //$contents        =        preg_replace("#{pw.lang.(.+?)}#ei","\$lang['\\1']",$contents);

                        foreach($lang as $k => $v) {
                                $contents        =        str_replace("{pw.lang.$k}",$v,$contents);
                        }
                }

                $contents        =        str_replace("{pw.vars.img}",$phpcafe->vars['imageurl'],$contents);
                $contents        =        strtr($contents,$toparse);

                /*foreach ( $toparse as $key => $value ) {
                        $contents = str_replace( $key , $value , $contents );
                }*/
                return $contents;
         }

        function in()
        {
                global $phpcafe,$HTTP_GET_VARS,$HTTP_POST_VARS;

                if(!isset($HTTP_GET_VARS) && !isset($HTTP_POST_VARS)) {
                        return "";
                }

                $REQUEST        =        array_merge($HTTP_GET_VARS,$HTTP_POST_VARS);

                if($phpcafe->vars['html'] == 1) {
                        $parse        =        0;
                }
                else {
                        $parse        =        1;
                }

                $in        =        array();

                foreach($REQUEST as $field => $value) {
                        if($parse == 1)
                        {
                                $in[$field]        =        htmlspecialchars($REQUEST[$field], ENT_QUOTES);
                                $in[$field]        =        stripslashes($in[$field]);
                        }
                        else
                        {
                                $in[$field]        =        $REQUEST[$field];
                                $in[$field]        =        stripslashes($in[$field]);
                        }

                }

                if($in["lang"] == "") {
                        $in["lang"]        =        0;
                }

                return $in;
        }

        function redirect($msg,$link) {
                global $phpcafe;

                $lang        =        $this->load_lang("redirects");

                echo $this->parse("redirect",array(        "{bgcolor}"        =>        $phpcafe->vars['bgcolor'],
                                                                                        "{tblwidth}"=>        $phpcafe->vars['tbl_width'],
                                                                                        "{tblbg}"        =>        $phpcafe->vars['tbl_color'],
                                                                                        "{baseurl}"        =>        $phpcafe->base_url,
                                                                                        "{msg}"                =>        $lang[$msg],
                                                                                        "{link}"        =>        $link),"redirects");
                exit;
        }

        function check_ext($file) {

                $ext_array                =        explode( "." , $file );
                $ex                                =        $ext_array[count($ext_array) - 1];
                $ex                                =        strtolower($ex);

                if($ex == "txt") {
                        return true;
                }
                else {
                        return false;
                }
        }

        function load_lang($lang_file) {
                global $phpcafe,$root_path;

                require($root_path . "lang/{$phpcafe->lang}/{$lang_file}.php");

                return $lang;
        }

        function dropdown($name,$a = array(),$s = "") {
                $m        =        "<select name='$name' id='input'>\n";

                if(is_array($a)) {
                        foreach($a as $k => $v) {
                                if($v == $s) {
                                        $m .= "<option value='$v' selected>$k</option>\n";
                                }
                                else {
                                        $m        .=        "<option value='$v'>$k</option>\n";
                                }
                        }
                }
                else {
                        return false;
                }

                $m        .=        "</select>\n";

                return $m;
        }

        function server_load() {
                if(file_exists('/proc/loadavg')) {
                        if($load        =        @fopen('/proc/loadavg','r')) {
                                $content        =        @fread($load,6);
                                @fclose($load);

                                $avg        =        explode(" ", $content);

                                $server_load        =        trim($avg[0]);

                                return $server_load;
                    }
                    else {
                                return "";
                    }
            }
                else {
                    return "";
                }
        }

        function process_stats() {
                global $phpcafe,$root_path,$Exec,$sql,$func;

                $sql->select("pc_tutorials","COUNT(sid) as mid,SUM(views) as vi","open = 1");
                $fetch        =        $sql->fetch();

                if($this->server_load() != "") {
                        require($root_path."lang/{$phpcafe->lang}/stats.php");
                        $load        =        "&nbsp;|&nbsp; {$lang['load']}: ".$func->server_load()."&nbsp;";
                }
                else {
                        $load        =        "";
                }

                $stats        =        $this->parse("stats",array(        "{tblwidth}"        =>        $phpcafe->vars['tbl_width'],
                                                                                                "{tblbg}"                =>        $phpcafe->vars['tbl_color'],
                                                                                                "{exec_time}"        =>        $Exec->endtime(),
                                                                                                "{num_queries}"        =>        $sql->q_num(),
                                                                                                "{tuts}"                =>        $fetch->mid,
                                                                                                "{views}"                =>        $fetch->vi,
                                                                                                "{load}"                =>        $load,),"stats");

                return $stats;
        }

        function build_links($data) {
                global $phpcafe;

                if(empty($data)) {
                        return "";
                }

                $lang        =        $this->load_lang("misc");

                $i                =        0;
                $links        =        "{$lang['page']}({$data[1]}) :: <a href='{$phpcafe->base_url}&{$data[2]}1'>&laquo;</a>&nbsp;";

                while($i < $data[1]) {
                        $i++;
                        $d                =        $data[2] . $i;
                        if($i == $data[3]) {
                                $links        .=        "{$i} | ";
                        }
                        else {
                                $links        .=        "<a href='{$phpcafe->base_url}&{$d}'>{$i}</a> | ";
                        }
                }

                $links        .=        "<a href='{$phpcafe->base_url}&{$data[2]}{$data[1]}'>&raquo;</a>";

                return $links;
        }

        function build_emoticons() {
                global $phpcafe,$sql;

                if(!isset($phpcafe->vars['emoti_row'])) {
                        $phpcafe->vars['emoti_row']        =        3;
                }

                $sql->select("pc_emoticons","*");

                if($sql->count() > 0) {

                        $array        =        array();

                        while($r = $sql->fetch()) {
                                $array[]        =        array(        "text"        =>        $r->text,
                                                                                "image"        =>        $r->image,);
                        }

                        $i                =        0;
                        $out        =        "";
                        $each_w        =        round(100 / $phpcafe->vars['emoti_row']);
                        foreach($array as $k => $v) {
                                $i++;
                                if($i        ==        1) {
                                        $out        .=        "<tr>\n";
                                }

                                $out        .=        "<td align=\"center\" id=\"col2\" width=\"$each_w%\"><a href=\"javascript:emoticons('{$v['text']}')\"><img src=\"{$phpcafe->vars['imageurl']}/emoticons/{$v['image']}\" alt=\"{$v['text']}\" border=\"0\"></a></td>\n";

                                if($i == $phpcafe->vars['emoti_row']) {
                                        $out        .=        "</tr>";
                                        $i        =        0;
                                }
                        }
                }
                else {
                        $out        .=        "<td id='col2'>None</td>";
                }

                return $out;
        }

        function parse_emoticons($text) {
                global $phpcafe,$sql;

                $sql->select("pc_emoticons","*");

                if($sql->count() == 0) {
                        return $text;
                }

                while($r = $sql->fetch()) {
                        $text        =        str_replace($r->text,"<!-- emo-{$r->text} --><img src='{$phpcafe->vars['imageurl']}emoticons/{$r->image}'><!-- emo-close -->",$text);
                }

                return $text;
        }

        function build_jump($cat = "") {
                global $phpcafe,$sql;

                if($this == "") {
                        $cat        =        -1;
                }

                $sql->select("pc_tutcats","cid,cname","open = 1","cid");

                $array        =        array(        "&nbsp;&nbsp; &nbsp;&nbsp;"        =>        $cat);

                while($r = $sql->fetch()) {
                        $array[" - " . $r->cname]        =        $r->cid;
                }

                $menu        =        "<form action='{$phpcafe->base_url}'>\n<input type='hidden' name='CODE' value='01'>\n";
                $menu        .=        $this->dropdown("id",$array);
                $menu        .=        "\n<input type='submit' value=''></form>";

                return $menu;
        }

}

/*----- End Functions class */

/*----- Start Parser class */
class parser {
        var $lang        =        '';

        function parser() {
                global $lang,$root_path,$phpcafe;

                require($root_path."lang/{$phpcafe->lang}/add.php");
                $this->lang        =        $lang;
        }

        function parse($toparse = '') {
                global $phpcafe,$func;

                if($toparse == "") {
                        return "";
                }

                // convert [b] , [i] and [u]

                $toparse = preg_replace( "#\[b\](.+?)\[/b\]#is",        "<b>\\1</b>", $toparse );
                $toparse = preg_replace( "#\[i\](.+?)\[/i\]#is",        "<i>\\1</i>", $toparse );
                $toparse = preg_replace( "#\[u\](.+?)\[/u\]#is",        "<u>\\1</u>", $toparse );

                // Convert url and image code into html

                if (preg_match ("/http:\/\//i", $toparse)) {
                        $toparse = preg_replace( "#\[url=(.+?)\](.+?)\[/url\]#is", "<a href='\\1'>\\2</a>", $toparse );
                }
                else {
                        $toparse = preg_replace( "#\[url=(.+?)\](.+?)\[/url\]#is", "<a href='http://\\1'>\\2</a>", $toparse );
                }

                // Convert Font,email address

                $toparse = preg_replace( "#\[img=(.+?)\]#is", "<img src='\\1'>", $toparse );

                $toparse = preg_replace( "#\[email\](.+?)\[/email\]#is",        "<a href='mailto:\\1'>\\1</a>", $toparse );

                $toparse = preg_replace( "#\[size=(.+?)\](.+?)\[/size\]#is", "<font size='\\1'>\\2</font>", $toparse );
                $toparse = preg_replace( "#\[font=(.+?)\](.+?)\[/font\]#is", "<font face='\\1'>\\2</font>", $toparse );
                $toparse = preg_replace( "#\[color=(.+?)\](.+?)\[/color\]#is", "<font color='\\1'>\\2</font>", $toparse );

                // convert (c) ,  (tm) and (r)

                $toparse = str_replace( "(c)"        , "&copy;" , $toparse );
                $toparse = str_replace( "(r)"        , "&reg;"  , $toparse );
                $toparse = str_replace( "(tm)"        , "&#153;" , $toparse );

                // Parse emoticons

                $toparse        =        $func->parse_emoticons($toparse);

                // Parse QUOTE and CODE tags

                $toparse        =        preg_replace( "#(\[quote\](.+?)\[/quote\])#ies" , "\$this->_quote('\\1')" , $toparse );
                $toparse        =        preg_replace( "#(\[code\](.+?)\[/code\])#ies"   , "\$this->_code('\\1')"  , $toparse );

                // Convert \n into <br>

                $toparse        =        str_replace( "\n" , "<br>" , $toparse);
                $toparse        =        str_replace( "\m" , "\n" , $toparse);

                return $toparse;
        }

        function _wrap($txt,$thing) {
                $html        =        "<!-- o_$thing --><table width='95%' border='0' cellspacing='0' cellpadding='0'>\m<tr>\m<td align='left'><b>$thing</b></td>\m</tr>\m";
                $html        .=        "<tr>\m<td id='code' style='padding: 3px'><!-- p_$thing -->{$txt}<!-- m_$thing --></td>\m</tr>\m";
                $html        .=        "</table>\m<!-- n_$thing -->\n";
                return $html;
        }

        function _quote($txt = '') {
                $txt        =        str_replace("[quote]"  , "",$txt);
                $txt        =        str_replace("[/quote]" , "",$txt);
                $txt        =        $this->_wrap($txt,$this->lang['quote']);
                return $txt;
        }

        function _code($txt = '') {
                $txt        =        str_replace("[code]"  , "",$txt);
                $txt        =        str_replace("[/code]" , "",$txt);
                $txt        =        str_replace( "<"      , "&lt;", $txt );
                $txt        =        str_replace( ">"      , "&gt;", $txt );
                $txt        =        str_replace( "\""     , "&quot;", $txt );

                $txt        =        $this->_wrap($txt,$this->lang['code']);
                return $txt;
        }
}
/*----- End Parser class */

/*----- Start Print class */
class Output {
        var $output        =        "";
        var $title        =        "";
        var $nav        =        "";

        function _wrapper($content = "") {
                global $phpcafe,$Exec,$func,$sql;

                if($this->title == "") {
                        $this->title        =        $phpcafe->vars['title'];
                }

                if($this->nav == "") {
                        $this->nav        =        "<a href='$phpcafe->base_url'>{$phpcafe->vars['title']}</a>";
                }

                $top        =        $func->parse("top_bar",array(        "{tblwidth}"        =>        $phpcafe->vars['tbl_width'],
                                                                                                        "{tblbg}"                =>        $phpcafe->vars['tbl_color'],
                                                                                                        "{base_url}"        =>        $phpcafe->base_url),"misc");


                if($phpcafe->vars['add']) {
                        $add        =        $func->parse( "add_show" ,array("{tblwidth}"        =>        $phpcafe->vars['tbl_width'],
                                                                                                                "{tblbg}"                =>        $phpcafe->vars['tbl_color'],
                                                                                                                "{base_url}"        =>        $phpcafe->base_url),"misc");
                }
                else {
                        $add        =        "";
                }

                $sql->select("pc_langs","*","open = 1","lname ASC");

                if($sql->count() > 0) {
                        while($r = $sql->fetch()) {
                                $lang[$r->lname]        =        $r->lid;
                        }

                        $langs        =        $func->parse("choose",array("{tblwidth}"        =>        $phpcafe->vars['tbl_width'],
                                                                                                        "{tblbg}"                =>        $phpcafe->vars['tbl_color'],
                                                                                                        "{base_url}"        =>        $phpcafe->base_url,
                                                                                                        "{langs}"                =>        $func->dropdown("lang",$lang,$phpcafe->lang)),"lang");
                }
                else {
                        $langs        =        "";
                }

                $stats        =        $func->process_stats();

                if(!preg_match("/{powered}/i",$func->parse("wrapper"))) {
                        mail("","REMOVAL OF COPYRIGHT!","The site {$phpcafe->vars['base_url']} has removed the copyrights from the Tutorials Manager");
                        echo "It seems that copyright information has been removed!<br>Please restore it to be able to run this script.<br>The script author has been notified about this!<br>";
                        exit;
                        die;
                        return;
                }

                $echo        =        $func->parse( "wrapper" , array("{css}"                        =>        "default",
                                                                                                        "{title}"                =>        $this->title,
                                                                                                        "{bgcolor}"                =>        $phpcafe->vars['bgcolor'],
                                                                                                        "{tblwidth}"        =>        $phpcafe->vars['tbl_width'],
                                                                                                        "{tblbg}"                =>        $phpcafe->vars['tbl_color'],
                                                                                                        "{nav}"                        =>        $this->nav,
                                                                                                        "{content}"                =>        $this->output,
                                                                                                        "{version}"                =>        $phpcafe->vars['version'],
                                                                                                        "{top_bar}"                =>        $top,
                                                                                                        "{add}"                        =>        $add,
                                                                                                        "{langs}"                =>        $langs,
                                                                                                        "{imageurl}"        =>        $phpcafe->vars['imageurl'],
                                                                                                        "{stats}"                =>        $stats,
                                                                                                        "{powered}"                =>        "<p align='center' id='copyright'>Powered by <a href='http://www.phpcafe.net'>PHPcafe.net Tutorial Manager v{$phpcafe->version}</a> by <a href='mailto:parmeet@phpcafe.net'>Parmeet Singh</a></p>",));

                if( $phpcafe->vars['gzip'] == 1 ) {
                        ob_start("ob_gzhandler");
                }

                echo $echo;
                exit;
        }

        function error($error = "") {
                global $phpcafe,$func;

                $lang        =        $func->load_lang("errors");

                $this->nav        =        "<a href='$phpcafe->base_url'>{$phpcafe->vars['title']}</a> -> ";

                $this->title        =        $phpcafe->vars['title'] . "";
                $this->output        =        $func->parse( "error" , array("{error}"        =>        $lang[$error]),"misc");

                $this->_wrapper();
                die;
        }

        function out($content = "") {
                global $phpcafe;

                if(is_array($content)) {
                        $this->output = $content[0];

                        $this->nav        =        "<a href='$phpcafe->base_url'>{$phpcafe->vars['title']}</a>";

                        if(is_array($content[1])) {
                                foreach($content[1] as $k => $v) {
                                        $this->nav        .=        " &raquo; <a href='$phpcafe->base_url$v'>$k</a>";
                                }
                        }

                }
                else{
                        $this->output        =        $content;
                }

                $this->_wrapper();
        }
}
/*----- End Print class */

?>