<?php

/***********************************************\
| VB MYSQL BACKUP                         v 1.9 |
| Dusty Burns aka TrigunFlame                        |
|                                                |
| Fully Automated Database Backup For Vbulletin,|
| utilizing the built-in Vbulletin Cron System.        |
| Also doubles as manual dump system from within|
| Vbulletin Admin Control Panel System          |
\***********************************************/



/*-----------------------------------------------------------
  MySQL Information
  -----------------------------------------------------------
  Here you will be able to modify your primary Database
  connection information such as the hostname, username,
  password and database that you would like to utilize during
  the backup procedure. This stuff MUST be changed.
  -----------------------------------------------------------
  examples;
  HOST = 'localhost' (default)
  USER = 'root'      (default)
  PASS = ' '         (default)
  DB   = 'forums'    (default)
  -----------------------------------------------------------
*/

  $backup['HOST']               = 'localhost';
  $backup['USER']               = 'root';
  $backup['PASS']               = '';
  $backup['DB']                 = 'forum';



/*-----------------------------------------------------------
  Forum Shutdown System
  -----------------------------------------------------------
  Here you can toggle if your forum will TEMPORARILY be
  switched to off, while the backup is in progress. I highly
  recommend that you do this for error-prevention reasons.
  Although this script has precautions in place to prevent
  data corruption (with Table Level Locking), your members
  will not be able to WRITE to the database while you are
  dumping, and may even get freezing page loads. Thus to
  better handle the situation, and prevent confusion; use
  this, and modify the message you want shown.
  -----------------------------------------------------------
  0 = Do NOT Shutdown Temporarily (NOT RECOMMENDED)
  1 = Shutdown Forum while dump is in progress. (RECOMMENDED)
  -----------------------------------------------------------
*/

  $backup['SHUTDOWN']                 = 1;
  $backup['MESSAGE'] = "<p>         </p>
                        <p>    .</p>";



/*-----------------------------------------------------------
  Backup Pruning
  -----------------------------------------------------------
  Select whether or not you would like to keep a Selected
  amount of backups at one time. This is to prevent you from
  using a lot of space, by keeping the amount of backups to
  a specified amount.
  -----------------------------------------------------------
  0 = No
  1 = Yes (default)
  -----------------------------------------------------------
  Backups To Keep
  -----------------------------------------------------------
  Specify here the actual amount of backups that you would
  like to keep at any one time, the recommended amount is 5.
  You may however specify as many as you please.
  -----------------------------------------------------------
  examples;
  DUMPS = 5 (default)
  -----------------------------------------------------------
*/

  $backup['PRUNE']                 = 1;
  $backup['DUMPS']                 = 5;



/*-----------------------------------------------------------
  File Saving Information
  -----------------------------------------------------------
  Filename Date Format
  -----------------------------------------------------------
  This configures the way the filenames should look. You can
  modify this by how the timestamps, are output.

  Note: Do not modify this heavily, these need to be Unique
  only to the day/month/year, no more specific.
  -----------------------------------------------------------
  examples;
  DATE = 'm_d_y' (default)
  DATE = 'mdy'

  USE 1 OF THESE 2. NOTHING ELSE.
  -----------------------------------------------------------
  Dump Path
  -----------------------------------------------------------
  Specify the path to the directory where you will be saving
  your Database Dumps.

  By default, I have it listed as your Document Root, so if
  you know you're going to be storing the file in the folder
  backups, you would just have it like the example below.

  If you would rather have the path specified manually, you
  may do that also.

  Note: You May also use relative paths, just like simple:
  DUMP_PATH = 'backups' which would store the backup in a
  folder in the same directory as the script. It is still
  recommended to use a full path though, to be fully safe
  with some functions that deal with windows file operations.
  -----------------------------------------------------------
  examples;
  DUMP_PATH = backups (default)
  ^= Would store the file in the folder backups relative to
  the root of your forum directory.

  DUMP_PATH = $_SERVER['DOCUMENT_ROOT'].'/backups';
  ^= Would store the file in the folder "backups" inside your
  web root.
  -----------------------------------------------------------
*/

  $backup['DATE']                 = 'm_d_y';
  $backup['DUMP_PATH']            = 'backups';



/*-----------------------------------------------------------
  Remote FTP Transfer
  -----------------------------------------------------------
  Here you can configure if you want to transfer a new backup
  to a remote FTP server for storage. This will take some
  time to handle, but may be worth it depending on how much
  you like to have backup redundancy.

  To use FTP, you must use my included ftp.lib.php class that
  houses 2 FTP client libraries, 1 being a FTP Module Wrapper
  and the other being a fsockopen() based Raw FTP Client. You
  must have this file present in your 'includes/' directory
  for the FTP functionality.

  NOTE: Currently only single file uploads are coded into the
  client libraries. In other words, you will get an error if
  you are using the backup type 0 and the combine = 0. These
  libraries will only upload 1 file at a time, support for
  uploading/deleting directories & multiple files have not
  yet been coded into the script.
  -----------------------------------------------------------
  FTP = 0 Do Not Remotely Transfer the Backup (default)
  FTP = 1 Transfer the Backup to a Remote FTP Server
  -----------------------------------------------------------
  Connection Settings
  -----------------------------------------------------------
  If you have selected the Option above to 1, to transfer;
  then these settings will decide the information regarding
  the transfer. These things be host, port, user, pass, and
  the remote directory. These need to be filled out for the
  transfer to be sucessfull.
  -----------------------------------------------------------
  Delete Local Backup
  -----------------------------------------------------------
  Here decides whether or not you would like to delete the
  local version of the backup after you have transfered it.
  By default this will be 0, but if you still want to do it,
  just select 1 and it will leave your local backup in place.
  -----------------------------------------------------------
  FTP Directory
  -----------------------------------------------------------
  Select a Directory you would like all dump files to go to.
  This directory must be already created, and possibly even
  CHMODDED 0777 like the backup directory.
  -----------------------------------------------------------
  Remote Backup Pruning
  -----------------------------------------------------------
  Just like the options up above, you can remotely keep the
  uploaded backups pruned and rotated, to keep from filling
  up the remote directory with lots of backups. By default
  this is yes, with a value of 5 like up above; change it
  as you see fit.
  -----------------------------------------------------------
  examples;
  FTP       = 0 (off by default)
  FTPHOST   = '127.0.0.1'
  FTPPORT   = 21;
  FTPUSER   = 'root'
  FTPPASS   = 'none'
  FTPDIR    = '' (Initial directory, when logged in).
  FTPDELLOC = 0
  FTPPRUNE  = 1
  FTPDUMPS  = 5
  -----------------------------------------------------------
*/

  $backup['FTP']         = 0;
  $backup['FTPHOST']        = '127.0.0.1';
  $backup['FTPPORT']         = 21;
  $backup['FTPUSER']        = 'anonymous';
  $backup['FTPPASS']        = 'email@notset.com';
  $backup['FTPDIR']        = 'backups';
  $backup['FTPDELLOC']         = 0;
  $backup['FTPPRUNE']         = 1;
  $backup['FTPDUMPS']         = 5;



/*-----------------------------------------------------------
  Log Raw MySQL Errors
  -----------------------------------------------------------
  0 = No
  1 = Yes (default)
  -----------------------------------------------------------
  Path To Log
  -----------------------------------------------------------
  Place here the path to the directory where you will be
  saving any of the error logs that come to happen for
  whatever reason.

  By Default they are to be placed in the same directory as
  this script, if you want, you may create a directory just
  for the logs, or even set the log path to the same as the
  dump path.

  Note: You May also use relative paths, just like simple:
  LOG_PATH = 'logs' which would store the logs in a
  folder in the same directory as the script. It is still
  recommended to use a full path though, to be fully
  with some functions that deal with windows file operations.
  -----------------------------------------------------------
  examples;
  LOG_PATH = $_SERVER['DOCUMENT_ROOT'] (default)
  ^= Would store the file in the primary directory of your
  web root.

  LOG_PATH = $_SERVER['DOCUMENT_ROOT'].'/logs';
  ^= Would store the file in the folder "logs" inside your
  web root.
  -----------------------------------------------------------
  Log FileName
  -----------------------------------------------------------
  examples;
  LOG_FILENAME = 'mysqlerror.txt' (default)
  -----------------------------------------------------------
*/

  $backup['LOG_ERRORS']         = 1;
  $backup['LOG_PATH']           = 'backups';
  $backup['LOG_FILENAME']       = 'error.txt';



/*-----------------------------------------------------------
  Backup Method to Use
  -----------------------------------------------------------
  Specify the methods you would like to use in  backing up
  your MySQL Database. To be more specific, whether or not
  you want to use MySQLs (mysqldump) utility, which will have
  to be executed via a system() call.

  On some systems this utility either does not exist, or has
  been disabled from use; in that case, you would need to
  selection the second option, which will perform a PHP
  backup of the database.
  -----------------------------------------------------------
  0 = Dump Using This Scripts PHP Dump Functions
  1 = Dump Using MySQLDump (Recommended)
  -----------------------------------------------------------
  Lock Tables With PHPDump
  -----------------------------------------------------------
  If you selected option 0 above, this option is necessary
  for you. I strongly suggest you leave LOCK = 1, as it will
  prevent writing of data as you backup, which *Could* cause
  data corruption during the backup process.

  Unless you get some sort of weird errors, leave this alone.
  Also, make sure you have it set in the configuration up
  above, that the forum will SHUTDOWN during the backup,
  that will help even further in preventing corruption.
  -----------------------------------------------------------
  Repair And Optimize
  -----------------------------------------------------------
  Select if you want to repair and optimize your MySQL Tables
  prior to the actual backup of the tables.

  By default I have left it off due to the fact, on large
  MySQL Databases; this option can take quite some time.
  If you want to run it, that is up to you.
  -----------------------------------------------------------
  0 = Don't Repair & Optimize Before Backup (default)
  1 = Repair & Optimize
  -----------------------------------------------------------
*/

  $backup['METHOD']         = 1;
  $backup['LOCK']         = 1;
  $backup['REPAIR']         = 0;



/*-----------------------------------------------------------
  Backup Type To Use / Selective Dump
  -----------------------------------------------------------
  Specify whether you would like to do a full database backup
  , or specific tables in your database such as users post.
  This really comes down to personal choice.

  Some of the larger forums may like to keep backups of just
  the necessary data to increase backup speed as well as disk
  space. It's really up to the indivdual.
  -----------------------------------------------------------
  0 = Selectively Dump Specified Tables
  1 = Dump All Tables (Recommended)
  -----------------------------------------------------------
  Tables to Dump
  -----------------------------------------------------------
  If you selected option 0, to selectively dump. Please fill
  the TABLES array with the selected tables, as I have done
  it already for example.

  Note: If your using option 1 to dump all tables it will
  ignore the TABLES array anyway.

  NOte: If you are using prefixes, you must specify them
  yourself in the tables array ie. forum_post, forum_user.
  -----------------------------------------------------------
  Combine Tables For Selective Dump
  -----------------------------------------------------------
  If you have selected option 0 to dump specific tables. This
  option determines whether or not the dumps are Re-Combined
  into 1 File for the purpose of keeping a cleaner dump
  folder and ease of use, without having to re-import
  multiple files again.

  NOTE:
  If you set COMBINE to 0 you MUST use the compression
  handler (tar, tgz, tbz, zip) INSTEAD of (gz, bz2) as
  they alone do not support multiple files in 1 compressed
  archive.

  For that reason, if you are not going to use the combine
  option, use one of the tar variations or zip.
  -----------------------------------------------------------
  0 = Individual Tables SQL files are archived together.
  1 = All Tables are re-joined back into 1 SQL File.
  -----------------------------------------------------------
*/

  $backup['TYPE']         = 1;
  $backup['TABLES']         = array('post','user');
  $backup['COMBINE']         = 1;



/*-----------------------------------------------------------
  Backup Optimizations
  -----------------------------------------------------------
  These two optizations allow you to tweak the dumping of
  your database backups. Enabling MySQL4 optimization is
  recommened IF you are using MySQL 4 or Greater.

  Also, if you are using INNODB, enable this option to enable
  specific flag operations that will improve its restore
  speed when recovering your database.

  By default; both of these options are 0 for maximum
  compatability, if you are using MySQL4 or Innodb PLEASE
  change these for the sake of improving your MySQL Restore.
  -----------------------------------------------------------
  0 = Off (default)
  1 = On
  -----------------------------------------------------------
  Lock Tables in Dump
  -----------------------------------------------------------
  This is to set whether or not you want the tables locked
  in the dump file. This will vastly improve the speed at
  which your dumps are restored back into the DB, some people
  do not have LOCK permissions, if so disable this, but by
  default it will be left on.
  -----------------------------------------------------------
  0 = Off
  1 = On  (default)
  -----------------------------------------------------------
*/

  $backup['MYSQL4']         = 0;
  $backup['INNODB']         = 0;
  $backup['LOCKTABLES'] = 1;



/*-----------------------------------------------------------
  Execution Function
  -----------------------------------------------------------
  If using MySQLDump OR using a Compresser which you can
  configure below. Select which PHP function you would like
  to use to execute MySQLDump OR A compressor.

  By default it is left as exec but depending on what
  functions may or may not be enabled, you may have to change
  them to suit your personalized needs.
  -----------------------------------------------------------
  Different Commands You Wish to Use
  -----------------------------------------------------------
  exec()       = exec
  system()     = system
  passthru()   = passthru
  -----------------------------------------------------------
*/

  $backup['COMMAND']        = 'exec';



/*-----------------------------------------------------------
  MySQLDUMP Path
  -----------------------------------------------------------
  If using MySQLDump, whats the path to it? Usually this can
  be left alone. Although sometimes you may need to specify
  a direct path to the binary if it is not registered in the
  usual paths of shell.
  -----------------------------------------------------------
  examples;
  MYSQLDUMP = mysqldump (default)
  MYSQLDUMP = /usr/bin/mysqldump
  MYSQLDUMP = /usr/local/bin/mysqldump
  MYSQLDUMP = /path/to/custom/dir/mysqldump
  -----------------------------------------------------------
*/

  $backup['MYSQLDUMP']        = 'mysqldump';



/*-----------------------------------------------------------
  MySQL Dump Switches
  -----------------------------------------------------------
  If using METHOD 1, these switches will be used when
  creating the backup, go to:

  dev.mysql.com/doc/mysql/en/mysqldump.html

  For a complete list of the switches, and what actions they
  account for.

  By Default I will use the -opt switch as it gives us the
  best switches all together for a faster dump/reload as well
  as data integrity during the dump.

  Unless you REALLY need something else. LEAVE THIS ALONE.

  Note: --opt Adds Table Locking to your dump, if you Can Not
  use Locks, you need to use other dump switches, as shown
  in the below demonstration.
  -----------------------------------------------------------
  SWITCHES = '--opt' (default) (Best Performance)
  SWITCHES = '--add-drop-table --extended-insert --quick' (Most Compatible)
  -----------------------------------------------------------
*/

  $backup['SWITCHES']         = '--opt';



/*-----------------------------------------------------------
  Compression Options
  -----------------------------------------------------------
  If you are going to you Compression as Defined above you
  should set here the type of compression that you would like
  performed on the dump file. By Default this script supports
  6 variations of formats.

  The script is coded so that it will first try to use built
  in PHP Functions to handle the compression such as
  gzencode/bzcompress if not, it will try and handle that work
  over to the command line for processing.

  Another Note about the ZIP Archive, alot of *NIX system
  don't support it, so if you want to use it, I suggest you
  download the PCLZIP Library From:

  http://www.phpconcept.net/pclzip/index.en.php

  Then place it in the includes directory. The script will
  automatically try to include the file and use it to
  compress your backup file into zip format.
  -----------------------------------------------------------
  Use Compression
  -----------------------------------------------------------
  0 = No
  1 = Yes
  -----------------------------------------------------------
  Buffer Block Size
  -----------------------------------------------------------
  This is the buffer size that is used, IF compressing occurs
  with the built in PHP modules ZLIB/BZIP2. This will control
  how many bytes of data are read at one time and then wrote
  back to the filesystem in compressed output. Generally,
  increasing this will somewhat increase the speed in output
  but probably not by a lot. Be sure to check what your
  local memory limit value is in phpinfo() before raising
  this setting. The default value is (1048576) 1MB.
  -----------------------------------------------------------
  Compression Types
  -----------------------------------------------------------
  Gzip Archive  = gz  (PHP Module or GZip Binary)
  BZIP2 Archive = bz2 (PHP Module or BZIP2 Binary)
  Tar Archive   = tar (Tar Binary)
  Tar with Gzip = tgz (Tar Binary & GZip Filter)
  Tar with Bzip = tbz (Tar Binary & BZip2 Filter)
  Zip Archive   = zip (PCLZIP Library or ZIP Binary)

  Note: I strongly suggest to NOT USE THE BZIP2 LIBRARY.
  It is painfully slow, and CPU Intensive at that. Use GZip,
  ZIP, or a TAR/TAR with Gzip. Only use BZIP if you want the
  best compression while sacrificing the time it takes to
  compress the contents of the backup file.
  -----------------------------------------------------------
  Location to Compressors
  -----------------------------------------------------------
  If PHP Cannot find a PHP Module Function that will
  facilitate its need to compress or in ZIP case the "PCLZip
  Library which needs the PHP Zlib Module". It will instead
  try to compress the file using an executable binary to
  handle the compression.

  I have default paths listed below, but as such as with the
  mysqldump binary, you may need to change the full path to
  the compressor as it differs from system to system,
  although default usually will work on most setups.
  -----------------------------------------------------------
  examples;
  gzip = gzip (default)
  gzip = /path/to/gzip
  bzip2= /usr/local/bin/bzip2
  tar  = /location/to/tar
  -----------------------------------------------------------
*/

  $backup['COMPRESS']         = 1;
  $backup['BUFFER']         = 1048576;
  $backup['COMPRESSION']= 'gz';
  $backup['COMPRESSORS']= array(
        'gzip'         => 'gzip',
        'bzip2'        => 'bzip2',
        'tar'         => 'tar',
        'zip'         => 'zip'
  );

?>