<?php

/***********************************************\
| VB MYSQL BACKUP                         v 1.9 |
| Dusty Burns aka TrigunFlame	                |
|						|
| Fully Automated Database Backup For Vbulletin,|
| utilizing the built-in Vbulletin Cron System.	|
| Also doubles as manual dump system from within|
| Vbulletin Admin Control Panel System          |
\***********************************************/



// ----- Standard Success
define ('NO_ERRORS', 1);

// ----- Database Option Errors
define ('DB_OPTIONS',             10000);

// ----- MySQL Dumping Errors
define ('DUMP_ERROR',             20000);

// ----- Dump Combining Errors
define ('COMBINE_INPUT_ERROR',    30000);
define ('COMBINE_OUTPUT_ERROR',   30001);

// ----- Compression Errors
define ('COMPRESS_INPUT_ERROR',   40000);
define ('GZIP_NOT_ARCHIVE',       40001);
define ('GZIP_ZLIB_OUTPUT_ERROR', 40002);
define ('GZIP_SHELL_OUTPUT_ERROR',40003);
define ('BZ2_NOT_ARCHIVE',        40004);
define ('BZ2_LIB_OUTPUT_ERROR',   40005);
define ('BZ2_SHELL_OUTPUT_ERROR', 40006);
define ('TAR_OUTPUT_ERROR',       40007);
define ('TAR_GZIP_OUTPUT_ERROR',  40008);
define ('TAR_BZIP2_OUTPUT_ERROR', 40009);
define ('ZIP_PCL_OUTPUT_ERROR',   40010);
define ('ZIP_SHELL_OUTPUT_ERROR', 40011);

// ----- FTP Transfer Errors
define ('FTP_COULD_NOT_CONNECT',  50000);
define ('FTP_COULD_NOT_LOGIN',    50001);
define ('FTP_COULD_NOT_CHDIR', 	  50002);
define ('FTP_COULD_NOT_UPLOAD',   50003);
define ('FTP_LIBRARY_NOT_FOUND',  50004);
define ('FTP_NOT_HANDLE_DIR',     50005);



/*
  Define Our "PHP4" Version of
  an interface class. This will
  handle the evaluation of our
  defined error codes. PHP5
  offers Class Constants, but 
  we want to keep compatability.
*/

Class errorHandler
{
	/* --------- Set Message/Error Variables -------- */

	var $STATUS;
	var $MESSAGES;
	var $FAILOVER;


	
	/* -------- Fill Message/Error Variables -------- */

	// Load Codes
	function loadCodes()
	{
		$this->MESSAGES = array(
			/* No Errors Have Been Encountered */
			NO_ERRORS 		=> 'MySQL Backup was completed successfully with no errors.',

			/* Options Regarding the Database Options */
			DB_OPTIONS 		=> 'Could not fetch database options. Shutting backup down.',

			/* Errors Relating To MYSQL Dumping Errors */
			DUMP_ERROR 		=> 'An error occured during the MySQL backup. Details ($details)',

			/* Standard Compression Input Error */
			COMPRESS_INPUT_ERROR	=> 'An error occured during input of the source file for Compression.', 

			/* SQL Dump Combining Errors */
			COMBINE_INPUT_ERROR 	=> 'An error occured during input of a table source file for combining.', 
			COMBINE_OUTPUT_ERROR 	=> 'An error occured while outputing a New combined SQL file.',

			/* GZIP Compresssion Errors */
			GZIP_NOT_ARCHIVE 	=> 'An error occured with configuration. (GZ) alone is not compatible for compressing multiple files into 1 archive. Read Config.',
			GZIP_ZLIB_OUTPUT_ERROR  => 'An error occured while outputing a New GZ file with the PHP GZ ZLIB Module.',
			GZIP_SHELL_OUTPUT_ERROR => 'An error occured while outputing a New GZ file with the shell GZIP Binary ($details).',

			/* BZIP2 Compression Errors */
			BZ2_NOT_ARCHIVE 	=> 'An error occured with configuration. (BZ2) alone is not compatible for compressing multiple files into 1 archive. Read Config.',
			BZ2_ZLIB_OUTPUT_ERROR	=> 'An error occured outputing a New BZ2 file with the PHP BZ2 BZIP2 Module.',
			BZ2_SHELL_OUTPUT_ERROR  => 'An error occured outputing a new BZ2 file with the shell BZIP2 Binary ($details).',

			/* TAR Compression Errors */
			TAR_OUTPUT_ERROR	=> 'An error occured outputing a New Tar Archive with the shell Tar Binary ($details).',
			TAR_GZIP_OUTPUT_ERROR	=> 'An error occured outputing a New Tar Gzip Archive with the shell Tar Binary ($details).',
			TAR_BZIP2_OUTPUT_ERROR 	=> 'An error occured outputing a New Tar Bzip2 Archive with the shell Tar Binary ($details).',

			/* ZIP Compression Errors */
			ZIP_PCL_OUTPUT_ERROR 	=> 'An error occured outputing a New Zip file with the PCLZIP Library.',
			ZIP_SHELL_OUTPUT_ERROR  => 'An error occured outputing a New Zip file with the shell Zip Binary ($details).',

			/* FTP Transfer Errors */
			FTP_COULD_NOT_CONNECT 	=> 'Could not connect to remote FTP Server',
			FTP_COULD_NOT_LOGIN 	=> 'Could not login to remote FTP Server.',
			FTP_COULD_NOT_CHDIR 	=> 'Could not change to remote working directory.',
			FTP_COULD_NOT_UPLOAD 	=> 'Could not upload backup to remote FTP Server.',
			FTP_LIBRARY_NOT_FOUND 	=> 'Could not find the FTP Library File.',
			FTP_NOT_HANDLE_DIR 	=> 'At this time, there is Directory support for FTP.'
		);
	}


	
	/* ----------- Custom Error Handler ------------ */

	// Error Handler
	function throwError($name,$details=false)
	{
		// Globalize
		global $nextitem;

		// Set Status
		eval("\$this->STATUS = \"".$this->MESSAGES[$name]."\";");

		// Check FailOver
		if ($this->FAILOVER)
		{
			$this->STATUS = "Failover was initiated for MySQLDump Binary & ".$this->STATUS;
		}

		// Console Output
		echo $this->STATUS;

		// Return to Log
		log_cron_action($this->STATUS, $nextitem);

		// Exit
		exit;
	}
}



/*
  Define Our MySQLBackup Class.
  This class handles All of our
  needed operations for backup.
*/

Class mysqlBackup Extends errorHandler
{
	/* ------------ DB Object References ------------ */

	// MySQL Database Object
	var $MYSQL;

	// FTP Interface Object
	var $FTPLIB;



	/* ----------- Static Class Variables ----------- */

	/* MySQL Configuration */
	var $HOST;
	var $USER;
	var $PASS;
	var $DB;

	/* Forum Shutdown Configuration */
	var $SHUTDOWN = 1;
	var $PREVIOUS;
	var $MESSAGE;

	/* Prune Backups */
	var $PRUNE = 1;
	var $DUMPS = 5;

	/* Backup Dump Info */
	var $DATE;
	var $DUMP_PATH;

	/* Remote FTP */
	var $FTP = 0;
	var $FTPHOST;
	var $FTPPORT;
	var $FTPUSER;
	var $FTPPASS;
	var $FTPDIR;
	var $FTPDELLOC = 0;
	var $FTPPRUNE = 1;
	var $FTPDUMPS = 5;

	/* Error Log Config*/
	var $LOG_ERRORS = 1;
	var $LOG_PATH;
	var $LOG_FILENAME;

	/* Backup Method */
	var $METHOD = 1;
	var $LOCK = 1;

	/* Repair Tables */
	var $REPAIR = 0;
	
	/* Backup Type */
	var $TYPE = 1;
	var $TABLES;
	var $COMBINE = 1;

	/* Backup Optimizations */
	var $MYSQL4 = 0;
	var $INNODB = 0;
	var $LOCKTABLES = 1;

	/* Command */
	var $COMMAND;

	/* MySQLDump Binary */
	var $MYSQLDUMP;

	/* MySQLDump Switches */
	var $SWITCHES;

	/* Compression Config */
	var $BUFFER = 1048576;
	var $COMPRESS = 1;
	var $COMPRESSION;
	var $COMPRESSORS;



	/* ----------- Dynamic Class Variables ----------- */

	/* Time Information */
	var $TIME;

	/* Server Information */
	var $OS = 0;
	var $SAFEMODE = 0;
	var $OPTIONS;

	/* Prune Last Date */
	var $LAST;
	var $FTP_LAST;

	/* Dump Full Path */
	var $FULL_PATH;

	/* Dump Short Path */
	var $SHORT_PATH;

	/* Error Out String */
	var $ERROR_OUT;

	/* FTP Full Path */
	var $FTP_FULL_PATH;



	/* ----------- Error Function Overload ---------- */ 

	// Error Handler
	function throwError($name,$details=false)
	{
		if ($this->SHUTDOWN) { $this->forumStatus(1); }
		parent::throwError($name,($details ? $details : 0));
	}



	/* -------------- Set Forum Status ------------- */ 

	// Change Forum Status
	function forumStatus($status=1)
	{
		// Status
		if (!$status)
		{
			// Set Previous Message
			$this->PREVIOUS = $this->OPTIONS['bbclosedreason'];

			// Set Closed
			$this->OPTIONS['bbactive'] = '0';
			$this->OPTIONS['bbclosedreason'] = $this->MESSAGE;
		}
		else
		{
			// Set Closed
			$this->OPTIONS['bbactive'] = '1';
			$this->OPTIONS['bbclosedreason'] = ($this->PREVIOUS ? $this->PREVIOUS : '');
		}

		// Update DataStore
		build_datastore('options', serialize($this->OPTIONS));
	}



	/* ------------- FTP Library Handler ------------ */ 

	// Handle FTP
	function ftpLibrary()
	{
		// Look for Library
		if (file_exists('./includes/ftp.lib.php'))
		{
			// Include Class File
			require_once('./includes/ftp.lib.php');

			// Choose Library Type
			if (function_exists('ftp_connect'))
			{
				$ftp = &new FTP_WRAPPER_LIB($this->FTPHOST,$this->FTPPORT);
			}
			else
			{
				$ftp = &new FTP_SOCK_LIB($this->FTPHOST,$this->FTPPORT);
			}

			// Connect
			if (!$ftp->ftpConnect())
			{
				$this->throwError(FTP_COULD_NOT_CONNECT);
			}

			// Login
			if (!$ftp->ftpLogin($this->FTPUSER,$this->FTPPASS))
			{
				$this->throwError(FTP_COULD_NOT_LOGIN);
			}

			// Prune
			if ($this->PRUNE)
			{
				// Set Last
				$this->FTP_LAST = date('m_d_y',mktime(0,0,0,date('m'),date('d')-intval($this->DUMPS),date('Y')));

				// Remove SQL File
				$ftp->ftpDelete($this->FTP_FULL_PATH.$this->FTP_LAST.'.sql');
			}

			// Remove SQL File
			$ftp->ftpDelete($this->FTP_FULL_PATH.$this->DATE.'.sql');

			// Compression File Remove
			if ($this->COMPRESS)
			{
				// Prune File
				if ($this->PRUNE)
				{
					switch ($this->COMPRESSION)
					{
						case 'gz' : $ftp->ftpDelete($this->FTP_FULL_PATH.$this->FTP_LAST.'.sql.gz'); break;
						case 'bz2': $ftp->ftpDelete($this->FTP_FULL_PATH.$this->FTP_LAST.'.sql.bz2'); break;
						case 'tar': $ftp->ftpDelete($this->FTP_FULL_PATH.$this->FTP_LAST.'.tar'); break;
						case 'tgz': $ftp->ftpDelete($this->FTP_FULL_PATH.$this->FTP_LAST.'.tar.gz'); break;
						case 'tbz': $ftp->ftpDelete($this->FTP_FULL_PATH.$this->FTP_LAST.'.tar.bz2'); break;
						case 'zip': $ftp->ftpDelete($this->FTP_FULL_PATH.$this->FTP_LAST.'.zip'); break;
					}
				}

				// Check Compression & Send
				switch ($this->COMPRESSION)
				{
					case 'gz' : 
						$ftp->ftpDelete($this->FTP_FULL_PATH.$this->DATE.'.sql.gz');
						if (!$ftp->ftpSendFile($this->FULL_PATH.'.sql.gz',$this->FTP_FULL_PATH.$this->DATE.'.sql.gz'))
						{
							$this->throwError(FTP_COULD_NOT_UPLOAD);
						}
					break;

					case 'bz2': 
						$ftp->ftpDelete($this->FTP_FULL_PATH.$this->DATE.'.sql.bz2'); 
						if (!$ftp->ftpSendFile($this->FULL_PATH.'.sql.bz2',$this->FTP_FULL_PATH.$this->DATE.'.sql.bz2'))
						{
							$this->throwError(FTP_COULD_NOT_UPLOAD);
						}
					break;

					case 'tar': 
						$ftp->ftpDelete($this->FTP_FULL_PATH.$this->DATE.'.tar'); 
						if (!$ftp->ftpSendFile($this->FULL_PATH.'.tar',$this->FTP_FULL_PATH.$this->DATE.'.tar'))
						{
							$this->throwError(FTP_COULD_NOT_UPLOAD);
						}
					break;

					case 'tgz': 
						$ftp->ftpDelete($this->FTP_FULL_PATH.$this->DATE.'.tar.gz'); 
						if (!$ftp->ftpSendFile($this->FULL_PATH.'.tar.gz',$this->FTP_FULL_PATH.$this->DATE.'.tar.gz'))
						{
							$this->throwError(FTP_COULD_NOT_UPLOAD);
						}
					break;

					case 'tbz': 
						$ftp->ftpDelete($this->FTP_FULL_PATH.$this->DATE.'.tar.bz2'); 
						if (!$ftp->ftpSendFile($this->FULL_PATH.'.tar.bz2',$this->FTP_FULL_PATH.$this->DATE.'.tar.bz2'))
						{
							$this->throwError(FTP_COULD_NOT_UPLOAD);
						}
					break;

					case 'zip': 
						$ftp->ftpDelete($this->FTP_FULL_PATH.$this->DATE.'.zip'); 
						if (!$ftp->ftpSendFile($this->FULL_PATH.'.zip',$this->FTP_FULL_PATH.$this->DATE.'.zip'))
						{
							$this->throwError(FTP_COULD_NOT_UPLOAD);
						}
					break;
				}
			}
			else
			{
				// Send File
				if (!$ftp->ftpSendFile($this->FULL_PATH.'.sql',$this->FTP_FULL_PATH.$this->DATE.'.zip'))
				{
					$this->throwError(FTP_COULD_NOT_UPLOAD);
				}
			}

			// Logout
			$ftp->ftpDisconnect();

			// Delete Local
			if ($this->FTPDELLOC)
			{
				if ($this->COMPRESS)
				{
					// Compression Check
					switch ($this->COMPRESSION)
					{
						case 'gz' : $this->removeFile($this->FULL_PATH.'.sql.gz'); break;
						case 'bz2': $this->removeFile($this->FULL_PATH.'.sql.bz2'); break;
						case 'tar': $this->removeFile($this->FULL_PATH.'.tar'); break;
						case 'tgz': $this->removeFile($this->FULL_PATH.'.tar.gz'); break;
						case 'tbz': $this->removeFile($this->FULL_PATH.'.tar.bz2'); break;
						case 'zip': $this->removeFile($this->FULL_PATH.'.zip'); break;
					}
				}
				else
				{
					$this->removeFile($this->FULL_PATH.'.sql');
				}
			}
		}
		// No Library
		else
		{
			$this->throwError('FTP_LIBRARY_NOT_FOUND');
		}
	}




	/* ------------- Misc Class Methods ------------- */ 

	// Create Selected File
	function createFile($file)
	{
		// Check Existance
		if (file_exists($file)) { return; }

		// Try Creation
		@fclose(@fopen($file,'w+'));
		@chmod($file, 0666);

		// Clear Cache
		clearstatcache();

		// Check Again
		if (file_exists($file)) { return; }

		// Windows
		if ($this->OS)
		{
			/* These Need to Be worked on */
			// @exec("del /f /q ".$file);
		}
		// *Nix
		else
		{
			// Command Usage
			switch ($this->COMMAND)
			{
				case 'exec': 
					@exec("echo > ".$file,$o,$e);
					@exec("chmod 0666 ".$file,$o,$e);
				break;

				case 'system': 
					@system("echo > ".$file,$e);
					@system("chmod 0666 ".$file,$e);
				break;

				case 'passthru': 
					@passthru("echo > ".$file,$e);
					@passthru("chmod 0666 ".$file,$e);
				break;
			}
		}
	}

	// Remove Selected File
	function removeFile($file)
	{
		// Check Existance
		if (!file_exists($file)) { return; }

		// Try Removing
		@unlink($file);

		// Clear Cache
		clearstatcache();

		// Check Again
		if (!file_exists($file)) { return; }

		// Windows
		if ($this->OS)
		{
			/* These Need to Be worked on */
			// @exec("del /f /q ".$file);
		}
		// *Nix
		else
		{
			// Command Usage
			switch ($this->COMMAND)
			{
				case 'exec': @exec("rm -f ".$file,$o,$e); break;
				case 'system': @system("rm -f ".$file,$e); break;
				case 'passthru': @passthru("rm -f ".$file,$e); break;
			}
		}
	}

	// Recursively Remove Directory
	function removeDir($directory)
	{
		// Delete File
		if (is_file($directory)) { $this->removeFile($directory); }
 
		// Open Directory?
		if (!$dir = @dir($directory)) { return; }

		// Loop
		while (false !== $file = $dir->read())
		{
			if ($file == '.' || $file == '..') { continue; }
			$this->removeDir("$directory/$file");
		}
 
		// Finish
		$dir->close();
		@rmdir($directory);

		// Clear Cache
		clearstatcache();

		// Check Again
		if (!is_dir($directory)) { return; }

		// Windows
		if ($this->OS)
		{
			/* These Need to Be worked on */
			// @exec("del /f /q ".$directory.'/*.*');
			// @exec("del /f /q ".$directory);
		}
		// *Nix
		else 
		{
			// Command Usage
			switch ($this->COMMAND)
			{
				case 'exec': @exec("rm -rf ".$directory,$o,$e); break;
				case 'system': @system("rm -rf ".$directory,$e); break;
				case 'passthru': @passthru("rm -rf ".$directory,$e); break;
			}
		}
	}

	// Create Directory
	function createDir($directory)
	{
		// Check Existance
		if (is_dir($directory)) { return; }

		// Make Directory
		$mask = umask(0); 
		@mkdir($directory, 0777);
		umask($mask);

		// Clear Cache
		clearstatcache();

		// Check Again
		if (is_dir($directory)) { return; }

		// Windows
		if ($this->OS)
		{
			/* These Need to Be worked on */
			// Nothing Yet
		}
		// *Nix
		else
		{
			// Command Usage
			switch ($this->COMMAND)
			{
				case 'exec': @exec("mkdir -m 0777 ".$directory,$o,$e); break;
				case 'system': @system("mkdir -m 0777 ".$directory,$e); break;
				case 'passthru': @passthru("mkdir -m 0777 ".$directory,$e); break;
			}
		}
	}

	// Combine Dump Files
	function combineDump()
	{
		// Create a New File
		$this->createFile($this->FULL_PATH.'.sql');

		// Open Output
		if (!$output = @fopen($this->FULL_PATH.'.sql','w+'))
		{
			$this->throwError(COMBINE_OUTPUT_ERROR);
		}

		// Set Write Buffer
		@stream_set_write_buffer($output, 0);

		// Loop Tables
		foreach ($this->TABLES AS $table)
		{
			// Open Source File
			if (!$input = @fopen($this->FULL_PATH.'_'.$table.'.sql','rb'))
			{
				$this->throwError(COMBINE_INPUT_ERROR);
			}

			// Read Into Parent File
			while (!feof($input))
			{
				fwrite($output,fread($input,$this->BUFFER));
			}

			// Close Source
			@fclose($input);

			// Remove Source
			$this->removeFile($this->FULL_PATH.'_'.$table.'.sql');
		}

		// Close Output
		@fclose($output);
	}

	// Repair & Optimize Tables
	function repairTables()
	{
		// Predefined Variables
		$tables  = array();
		$lock    = 'LOCK TABLES';
		$unlock  = 'UNLOCK TABLES;';

		// Get Table List
		$result = $this->MYSQL->query('SHOW tables');

		// Store Table List
		while ($table = $this->MYSQL->fetch_array($result,DBARRAY_NUM))
		{
			$tables[] = $table[0];
			$lock .= ' `'.$table[0].'` WRITE,';
		}

		// Remove Ending of LockList
		$lock = rtrim($lock,",").';';

		// Lock Tables
		if ($this->LOCK)
		{
			$this->MYSQL->query($lock);
		}

		// Loop Tables
		foreach ($tables AS $table)
		{
			$error = 0;
			$optimize = 1;

			// Check Table
			$check = $this->MYSQL->query("CHECK TABLE `$table`");
			while ($status = $this->MYSQL->fetch_array($check,DBARRAY_NUM))
			{
				// Status
				if ($status[2] == 'error')
				{
					if ($status[3] == 'The handler for the table doesn\'t support check/repair')
					{
						$optimize = 0;
					}
					else
					{
						$error = 1;
					}
				}
			}

			// Check Table Error
			if ($error)
			{
				// Repair Table
				$repair = $this->MYSQL->query_first("REPAIR TABLE `$table`");

				// Status
				if ($repair[3] != 'OK')
				{
					$error2 = 1;
				}
				else
				{
					$error2 = 0;
					$error = 0;
				}
			}

			// Check Optimize
			if (!$error && !$error2 && $optimize)
			{
				// Optimize Table
				$optimize = $this->MYSQL->query("OPTIMIZE TABLE `$table`");
				while ($status = $this->MYSQL->fetch_array($optimize,DBARRAY_NUM))
				{
					// Status
					if ($status[2] == 'error')
					{
						$error = 1;
					}
				}
			}
		}

		// Unlock Tables
		if ($this->LOCK)
		{
			$this->MYSQL->query($unlock);
		}
	}



	/* ---------- Core Compressions Methods --------- */

	// PHP Module/Library Compression
	function phpCompress($level=1)
	{
		// Compression Type
		switch ($this->COMPRESSION)
		{
			// GZ Compression
			case 'gz':
				// Open Source File
				if (!$input = @fopen($this->FULL_PATH.'.sql','rb'))
				{
					$this->throwError(COMPRESS_INPUT_ERROR);
				}

				// Open Output
				if ($output = @gzopen($this->FULL_PATH.'.sql.gz',"wb".$level))
				{
					// Set Write Buffer
					@stream_set_write_buffer($output, 0);

					// Loop & ReWrite in GZ Compression
					while (!feof($input))
					{
						gzwrite($output,fread($input,$this->BUFFER));
					}

					// Close Source
					@fclose($input);
				}
				// Throw Error
				else
				{
					$this->throwError(GZIP_ZLIB_OUTPUT_ERROR);
				}

				// Close Output
				@gzclose($output);
			break;

			// BZIP2 Compression
			case 'bz2':
				// Open Source File
				if (!$input = @fopen($this->FULL_PATH.'.sql','rb'))
				{
					$this->throwError(COMPRESS_INPUT_ERROR);
				}

				// Open Output
				if ($output = @bzopen($this->FULL_PATH.'.sql.bz2',"wb"))
				{
					// Set Write Buffer
					@stream_set_write_buffer($output, 0);

					// Loop & ReWrite in BZ Compression
					while (!feof($input))
					{
						bzwrite($output,fread($input,$this->BUFFER));
					}

					// Close Source
					@fclose($input);
				}
				else
				{
					$this->throwError(BZ2_ZLIB_OUTPUT_ERROR);
				}

				// Close Output
				@bzclose($output);
			break;

			// ZIP Compression
			case 'zip':
				// Include Class File
				require_once('./includes/pclzip.lib.php');

				/* Multiple File Archive */
				if (!$this->TYPE && !$this->COMBINE)
				{
					// Create Object
					$zip = &new PclZip($this->SHORT_PATH.$this->DATE.'.zip');

					// Create ZIP File
					if (!$zip->create($this->SHORT_PATH.$this->DATE))
					{
						// Remove Empty Zip File
						$this->removeDir($this->SHORT_PATH.$this->DATE);
						$this->throwError(ZIP_PCL_OUTPUT_ERROR);
					}
				}
				/* Single File Archive */
				else
				{
					// Create Object
					$zip = &new PclZip($this->FULL_PATH.'.sql.zip');

					// Create ZIP File
					if (!$zip->create($this->FULL_PATH.'.sql'))
					{
						// Remove Empty Zip File
						$this->removeFile($this->FULL_PATH.'.sql.zip');
						$this->throwError(ZIP_PCL_OUTPUT_ERROR);
					}
				}

				// Object Cleanup
				unset($zip);
			break;
		}
	}

	// Compress Backup
	function compressDump()
	{
		// Compression Type
		switch ($this->COMPRESSION)
		{
			// GZ Compression
			case 'gz':
				/* Check Dump Type */
				if (!$this->TYPE && !$this->COMBINE)
				{
					$this->throwError(GZIP_NOT_ARCHIVE);
				}

				/* Check Existance of ZLIB Library */
				if (function_exists('gzencode'))
				{
					$this->phpCompress();
				}
				/* Use Command Line Instead */
				else
				{
					// Formatted String
					$compress = sprintf(
						"%s -1 -f %s",
						$this->COMPRESSORS['gzip'],
						$this->FULL_PATH.'.sql'
					);

					// Command Usage
					switch ($this->COMMAND)
					{
						case 'exec': @exec($compress,$o,$e); break;
						case 'system': @system($compress,$e); break;
						case 'passthru': @passthru($compress,$e); break;
					}

					// Look For Errors
					if (intval($e) != 0)
					{
						$this->throwError(GZIP_SHELL_OUTPUT_ERROR,$compress);
					}
				}
			break;

			// BZIP2 Compression
			case 'bz2':
				/* Check Dump Type */
				if (!$this->TYPE && !$this->COMBINE)
				{
					$this->throwError(BZ2_NOT_ARCHIVE);
				}

				/* Check Existance of BZ2 Library */
				if (function_exists('gzencode'))
				{
					$this->phpCompress();
				}
				/* Use Command Line Instead */
				else
				{
					// Formatted String
					$compress = sprintf(
						"%s -1 -f %s",
						$this->COMPRESSORS['bzip2'],
						$this->FULL_PATH.'.sql'
					);

					// Command Usage
					switch ($this->COMMAND)
					{
						case 'exec': @exec($compress,$o,$e); break;
						case 'system': @system($compress,$e); break;
						case 'passthru': @passthru($compress,$e); break;
					}

					// Look For Errors
					if (intval($e) != 0)
					{
						$this->throwError(BZ2_SHELL_OUTPUT_ERROR,$compress);
					}
				}
			break;

			// TAR Archive
			case 'tar':
				/* Multiple File Archive */
				if (!$this->TYPE && !$this->COMBINE)
				{
					// Formatted String
					$compress = sprintf(
						"%s -cS --remove-files -f %s %s",
						$this->COMPRESSORS['tar'],
						$this->SHORT_PATH.$this->DATE.'.tar',
						$this->SHORT_PATH.$this->DATE
					);
				}
				/* Single File Archive */
				else
				{
					// Formatted String
					$compress = sprintf(
						"%s -cS --remove-files -f %s %s",
						$this->COMPRESSORS['tar'],
						$this->FULL_PATH.'.tar',
						$this->FULL_PATH.'.sql'
					);
				}

				// Command Usage
				switch ($this->COMMAND)
				{
					case 'exec': @exec($compress,$o,$e); break;
					case 'system': @system($compress,$e); break;
					case 'passthru': @passthru($compress,$e); break;
				}

				// Look For Errors
				if (intval($e) != 0)
				{
					$this->throwError(TAR_OUTPUT_ERROR,$compress);
				}
			break;

			// TAR Archive | GZ Compression
			case 'tgz':
				/* Multiple File Archive */
				if (!$this->TYPE && !$this->COMBINE)
				{
					// Formatted String
					$compress = sprintf(
						"%s -cSz --remove-files -f %s %s",
						$this->COMPRESSORS['tar'],
						$this->SHORT_PATH.$this->DATE.'.tar.gz',
						$this->SHORT_PATH.$this->DATE
					);
				}
				/* Single File Archive */
				else
				{
					// Formatted String
					$compress = sprintf(
						"%s -cSz --remove-files -f %s %s",
						$this->COMPRESSORS['tar'],
						$this->FULL_PATH.'.tar.gz',
						$this->FULL_PATH.'.sql'
					);
				}

				// Command Usage
				switch ($this->COMMAND)
				{
					case 'exec': @exec($compress,$o,$e); break;
					case 'system': @system($compress,$e); break;
					case 'passthru': @passthru($compress,$e); break;
				}

				// Look For Errors
				if (intval($e) != 0)
				{
					$this->throwError(TAR_GZIP_OUTPUT_ERROR,$compress);
				}
			break;

			// TAR Archive | BZIP2 Compression
			case 'tbz':
				/* Multiple File Archive */
				if (!$this->TYPE && !$this->COMBINE)
				{
					// Formatted String
					$compress = sprintf(
						"%s -cSj --remove-files -f %s %s",
						$this->COMPRESSORS['tar'],
						$this->SHORT_PATH.$this->DATE.'.tar.bz2',
						$this->SHORT_PATH.$this->DATE
					);
				}
				/* Single File Archive */
				else
				{
					// Formatted String
					$compress = sprintf(
						"%s -cSj --remove-files -f %s %s",
						$this->COMPRESSORS['tar'],
						$this->FULL_PATH.'.tar.bz2',
						$this->FULL_PATH.'.sql'
					);
				}

				// Command Usage
				switch ($this->COMMAND)
				{
					case 'exec': @exec($compress,$o,$e); break;
					case 'system': @system($compress,$e); break;
					case 'passthru': @passthru($compress,$e); break;
				}

				// Look For Errors
				if (intval($e) != 0)
				{
					$this->throwError(TAR_BZIP2_OUTPUT_ERROR,$compress);
				}
			break;

			// Zip Archive | Zip Compression
			case 'zip':
				/* 
				  Check Existance of PCLZIP Library From: 
				  http://www.phpconcept.net/pclzip/index.en.php

				  You must ALSO Have the ZLIB Library installed
				  as a PHP Module for this Library to Work.
				*/ 
				if (file_exists('./includes/pclzip.lib.php') && function_exists('gzencode'))
				{
					$this->phpCompress();
				}
				/* Use Command Line Instead */
				else
				{
					/* Multiple File Archive */
					if (!$this->TYPE && !$this->COMBINE)
					{
						// Formatted String
						$compress = sprintf(
							"%s -r1 %s %s",
							$this->COMPRESSORS['zip'],
							$this->SHORT_PATH.$this->DATE.'.zip',
							$this->SHORT_PATH.$this->DATE
						);
					}
					/* Single File Archive */
					else
					{
						// Formatted String
						$compress = sprintf(
							"%s -1 %s %s",
							$this->COMPRESSORS['zip'],
							$this->FULL_PATH.'.zip',
							$this->FULL_PATH.'.sql'
						);
					}

					// Command Usage
					switch ($this->COMMAND)
					{
						case 'exec': @exec($compress,$o,$e); break; 
						case 'system': @system($compress,$e); break;
						case 'passthru': @passthru($compress,$e); break;
					}

					// Look For Errors
					if (intval($e) != 0)
					{
						$this->throwError(ZIP_SHELL_OUTPUT_ERROR,$compress);
					}
				}
			break;
		}
	}



	/* ------------- Core Backup Methods ------------ */

	// MySQL Based Dump
	function mysqlDump()
	{
		/* Entire Table Dump */
		if ($this->TYPE)
		{
			// Formatted String
			$mysqldump = sprintf(
				"%s %s -h %s -u %s -p%s %s %s> %s",
				$this->MYSQLDUMP,
				$this->SWITCHES,
				$this->HOST,
				$this->USER,
				$this->PASS,
				$this->DB,
				$this->ERROR_OUT,
				$this->FULL_PATH.'.sql'
			);

			// Command Usage
			switch ($this->COMMAND)
			{
				case 'exec': @exec($mysqldump,$o,$e); break;
				case 'system': @system($mysqldump,$e); break;
				case 'passthru': @passthru($mysqldump,$e); break;
			}

			// Look For Errors
			if (intval($e) != 0)
			{
				$this->FAILOVER = 1;
				$this->phpDump();
			}
		}
		/* Selective Table Dump */
		else
		{
			// Loop Tables
			foreach ($this->TABLES AS $table)
			{
				// Formatted String
				$mysqldump = sprintf(
					"%s %s -h %s -u %s -p%s %s %s %s> %s",
					$this->MYSQLDUMP,
					$this->SWITCHES,
					$this->HOST,
					$this->USER,
					$this->PASS,
					$this->DB,
					$table,
					$this->ERROR_OUT,
					$this->FULL_PATH.'_'.$table.'.sql'
				);
	
				// Command Usage
				switch ($this->COMMAND)
				{
					case 'exec': @exec($mysqldump,$o,$e); break;
					case 'system': @system($mysqldump,$e); break;
					case 'passthru': @passthru($mysqldump,$e); break;
				}

				// Look For Errors
				if (intval($e) != 0)
				{
					$this->FAILOVER = 1;
					$this->phpDump();
				}
			}
		}
	}

	// PHP Based Dump
	function phpDump()
	{
		/* Entire Table Dump */
		if ($this->TYPE)
		{
			// Create a New File
			$this->createFile($this->FULL_PATH.'.sql');

			// Open Output
			if (!$output = @fopen($this->FULL_PATH.'.sql','w+'))
			{
				$this->throwError(DUMP_ERROR,"Could not open Destination SQL file for writing. (".$this->FULL_PATH.".sql)");
			}

			// Set Write Buffer
			@stream_set_write_buffer($output, 0);

			// Predefined Variables
			$tables  = array();
			$lock    = 'LOCK TABLES';
			$unlock  = 'UNLOCK TABLES;';

			// Get Table List
			$result = $this->MYSQL->query('SHOW tables');

			// Store Table List
			while ($table = $this->MYSQL->fetch_array($result,DBARRAY_NUM))
			{
				$tables[] = $table[0];
				$lock .= ' `'.$table[0].'` READ,';
			}

			// Remove Ending of LockList
			$lock = rtrim($lock,",").';';

			// Lock Tables
			if ($this->LOCK)
			{
				$this->MYSQL->query($lock);
			}

			// InnoDb Optimization
			if ($this->INNODB)
			{
				// Construct AutoCommit Off
				fwrite($output,"SET AUTOCOMMIT = 0;\n");

				// Construct Foreign Key Checks Off
				fwrite($output,"SET FOREIGN_KEY_CHECKS = 0;\n\n\n");
			}

			// Start Parsing Rows
			foreach ($tables AS $table)
			{
				// Create Header
				$tableheader = $this->MYSQL->query_first("SHOW CREATE TABLE `$table`");
				$tableheader = "DROP TABLE IF EXISTS `$table`;\n".$tableheader['Create Table'].";\n\n";

				// Write Header
				fwrite($output,$tableheader);

				// Get Total Rows
				$total = $this->MYSQL->query_first("SELECT COUNT(*) AS count FROM `$table`");

				// Check Total & Skip
				if (intval($total) == 0) { continue; }

				// Get Row (Unbuffered)
				$rows = $this->MYSQL->query_unbuffered("SELECT * FROM `$table`");

				// Fields
				$fields = $this->MYSQL->num_fields($rows);

				// MySQL4 Optimizations
				if ($this->MYSQL4)
				{
					// Construct Disable Keys
					fwrite($output,"/*!40000 ALTER TABLE `$table` DISABLE KEYS */;\n");
				}

				// Lock Tables
				if ($this->LOCKTABLES)
				{
					// Construct Lock
					fwrite($output,"LOCK TABLES `$table` WRITE;\n");
				}

				// Get Data
				$r = 0;
				while ($row = $this->MYSQL->fetch_array($rows,DBARRAY_NUM))
				{
					$values = array();
					for ($i=0;$i<$fields;$i++)
					{
						// Check Data
						if (!isset($row[$i]) || is_null($row[$i]))
						{
                    					$values[] = 'NULL';
						}
						else
						{
							$values[] = "'".$this->MYSQL->escape_string($row[$i])."'";
						}
					}
					$r++;

					// Construct Insert
					fwrite($output,"INSERT INTO `$table` VALUES (".implode(',',$values).");\n");
				}

				// Lock Tables
				if ($this->LOCKTABLES)
				{
					// Construct Unlock
					fwrite($output,"UNLOCK TABLES;\n");
				}

				// MySQL4 Optimizations
				if ($this->MYSQL4)
				{
					// Construct Enable Keys
					fwrite($output,"/*!40000 ALTER TABLE `$table` ENABLE KEYS */;\n\n");
				}

				// Free Memory
				$this->MYSQL->free_result($rows);
			}

			// InnoDb Optimization
			if ($this->INNODB)
			{
				// Construct AutoCommit On
				fwrite($output,"\n"."SET AUTOCOMMIT = 1;\n");

				// Construct Commit
				fwrite($output,"COMMIT;\n");

				// Construct Foreign Key Checks On
				fwrite($output,"SET FOREIGN_KEY_CHECKS = 1;\n\n\n");
			}

			// Unlock Tables
			if ($this->LOCK)
			{
				$this->MYSQL->query($unlock);
			}

			// Close Output
			@fclose($output);
		}
		/* Selective Table Dump */
		else
		{
			// Predefined Variables
			$tables  = array();
			$lock    = 'LOCK TABLES';
			$unlock  = 'UNLOCK TABLES;';

			// Store Table List
			foreach ($this->TABLES AS $table)
			{
				$tables[] = $table;
				$lock .= ' `'.$table.'` READ,';
			}

			// Remove Ending of LockList
			$lock = rtrim($lock,",").';';

			// Lock Tables
			if ($this->LOCK)
			{
				$this->MYSQL->query($lock);
			}

			// Start Parsing Rows
			foreach ($tables AS $table)
			{
				// Create a New File
				$this->createFile($this->FULL_PATH.'_'.$table.'.sql');

				// Open Output
				if (!$output = @fopen($this->FULL_PATH.'_'.$table.'.sql','w+'))
				{
					$this->throwError(DUMP_ERROR,"Could not open Destination SQL file for writing.");
				}

				// Set Write Buffer
				@stream_set_write_buffer($output, 0);

				// InnoDb Optimization
				if ($this->INNODB)
				{
					// Construct AutoCommit Off
					fwrite($output,"SET AUTOCOMMIT = 0;\n");

					// Construct Foreign Key Checks Off
					fwrite($output,"SET FOREIGN_KEY_CHECKS = 0;\n\n\n");
				}

				// Create Header
				$tableheader = $this->MYSQL->query_first("SHOW CREATE TABLE `$table`");
				$tableheader = "DROP TABLE IF EXISTS `$table`;\n".$tableheader['Create Table'].";\n\n";

				// Write Header
				fwrite($output,$tableheader);

				// Get Total Rows
				$total = $this->MYSQL->query_first("SELECT COUNT(*) AS count FROM `$table`");

				// Check Total & Skip
				if (intval($total) == 0) { continue; }

				// Get Row (Unbuffered)
				$rows = $this->MYSQL->query_unbuffered("SELECT * FROM `$table`");

				// Fields
				$fields = $this->MYSQL->num_fields($rows);

				// MySQL4 Optimizations
				if ($this->MYSQL4)
				{
					// Construct Disable Keys
					fwrite($output,"/*!40000 ALTER TABLE `$table` DISABLE KEYS */;\n");
				}

				// Lock Tables
				if ($this->LOCKTABLES)
				{
					// Construct Lock
					fwrite($output,"LOCK TABLES `$table` WRITE;\n");
				}

				// Get Data
				$r = 0;
				while ($row = $this->MYSQL->fetch_array($rows,DBARRAY_NUM))
				{
					$values = array();
					for ($i=0;$i<$fields;$i++)
					{
						// Check Data
						if (!isset($row[$i]) || is_null($row[$i]))
						{
                    					$values[] = 'NULL';
						}
						else
						{
							$values[] = "'".$this->MYSQL->escape_string($row[$i])."'";
						}
					}
					$r++;
	
					// Construct Insert
					fwrite($output,"INSERT INTO `$table` VALUES (".implode(',',$values).");\n");
				}

				// Lock Tables
				if ($this->LOCKTABLES)
				{
					// Construct Unlock
					fwrite($output,"UNLOCK TABLES;\n");
				}

				// MySQL4 Optimizations
				if ($this->MYSQL4)
				{
					// Construct Enable Keys
					fwrite($output,"/*!40000 ALTER TABLE `$table` ENABLE KEYS */;\n\n");
				}

				// InnoDb Optimization
				if ($this->INNODB)
				{
					// Construct AutoCommit On
					fwrite($output,"\n"."SET AUTOCOMMIT = 1;\n");

					// Construct Commit
					fwrite($output,"COMMIT;\n");

					// Construct Foreign Key Checks On
					fwrite($output,"SET FOREIGN_KEY_CHECKS = 1;\n\n\n");
				}

				// Close Output
				@fclose($output);

				// Free Memory
				$this->MYSQL->free_result($rows);
			}

			// Unlock Tables
			if ($this->LOCK)
			{
				$this->MYSQL->query($unlock);
			}
		}
	}
	


	/* ------------- Primary Initiation Methods ------------- */

	// Cron Based Automated Backup
	function cronBackup()
	{
		/*
		  Set Full Dump Path.
		  This will depend which type 
		  of dump we have selected in
		  our current configuration.
		*/
		if (!$this->TYPE && !$this->COMBINE)
		{
			$this->FULL_PATH  = ($this->DUMP_PATH ? $this->DUMP_PATH.'/'.$this->DATE.'/'.$this->DATE : $this->DATE.'/'.$this->DATE);
		}
		else
		{
			$this->FULL_PATH = ($this->DUMP_PATH ? $this->DUMP_PATH.'/'.$this->DATE : $this->DATE);
		}

		/* Short Path */
		$this->SHORT_PATH = ($this->DUMP_PATH ? $this->DUMP_PATH.'/' : '');

		/*
		  Set Error Log Path.
		  This will also depend on whether
		  or not we have the log enabled
		  in the current configuration.
		*/
		$this->ERROR_OUT = ($backup['LOG_ERRORS'] ? '2>'.$backup['DATE'].'_'.$backup['LOG_FILENAME'].' ' : '');

		/*
		  Close Forum Temporarily.
		  If it has been set in the 
		  configuration, the script
		  will automatically shutdown
		  your forum while the dump is
		  in progress, and then re-open
		  it when it finishes, or an
		  error occurs.
		*/

		if ($this->SHUTDOWN) { $this->forumStatus(0); }

		/*
		  Prune Directory/File.
		  If selected to prune in
		  the configuration, this
		  will create a timestamp
		  to identify a file to
		  prune.
		*/
		if ($this->PRUNE)
		{
			$this->LAST = date('m_d_y',mktime(0,0,0,date('m'),date('d')-intval($this->DUMPS),date('Y')));
		}
		
		/*
		  Remove previous SQL File.
		  If it is named the same as
		  the target date as the 
		  forthcoming database backup.
		*/
		if (!$this->TYPE && !$this->COMBINE)
		{
			/* Prune if Needed
			if ($this->PRUNE)
			{
				removeDir($this->SHORT_PATH.$this->LAST);
			}

			/* Remove Directory & Create Directory */
			$this->removeDir($this->SHORT_PATH.$this->DATE);
			$this->createDir($this->SHORT_PATH.$this->DATE);
		}
		else
		{
			/* Prune if Needed */
			if ($this->PRUNE)
			{
				/* Remove SQL File */
				$this->removeFile($this->SHORT_PATH.$this->LAST.'.sql');
			}

			/* Remove SQL File */
			$this->removeFile($this->FULL_PATH.'.sql');

			/* Compression File Remove */
			if ($this->COMPRESS)
			{
				/* Prune if Needed */
				if ($this->PRUNE)
				{
					switch ($this->COMPRESSION)
					{
						case 'gz' : $this->removeFile($this->SHORT_PATH.$this->LAST.'.sql.gz'); break;
						case 'bz2': $this->removeFile($this->SHORT_PATH.$this->LAST.'.sql.bz2'); break;
						case 'tar': $this->removeFile($this->SHORT_PATH.$this->LAST.'.tar'); break;
						case 'tgz': $this->removeFile($this->SHORT_PATH.$this->LAST.'.tar.gz'); break;
						case 'tbz': $this->removeFile($this->SHORT_PATH.$this->LAST.'.tar.bz2'); break;
						case 'zip': $this->removeFile($this->SHORT_PATH.$this->LAST.'.zip'); break;
					}
				}

				/* Check Compression */
				switch ($this->COMPRESSION)
				{
					case 'gz' : $this->removeFile($this->FULL_PATH.'.sql.gz'); break;
					case 'bz2': $this->removeFile($this->FULL_PATH.'.sql.bz2'); break;
					case 'tar': $this->removeFile($this->FULL_PATH.'.tar'); break;
					case 'tgz': $this->removeFile($this->FULL_PATH.'.tar.gz'); break;
					case 'tbz': $this->removeFile($this->FULL_PATH.'.tar.bz2'); break;
					case 'zip': $this->removeFile($this->FULL_PATH.'.zip'); break;
				}
			}
		}

		/* Clear Cache */
		clearstatcache();

		/*
		  Repair & Optimize.
		  If selected in the configuration
		  this will repair & optimize your
		  tables before they are dumped
		  and compressed.
		*/
		if ($this->REPAIR)
		{
			$this->repairTables();
		}

		/*
		  Start Initial Dump.
		  Depending on whether or 
		  not we want to do a PHP 
		  manual dump, or a binary 
		  based mysqldump() from shell.
		  MySQL Shell Dump
		*/
		if ($this->METHOD)
		{
			$this->mysqlDump();
		}
		/* PHP Based Dump */
		else 
		{
			$this->phpDump();
		}

		/* 
		  Combine Files.
		  If you chose to do a selective
		  dump, AND also chose to combine
		  the files into 1 SQL File; this
		  will do that for you.
		*/
		if (!$this->TYPE && $this->COMBINE)
		{
			$this->combineDump();
		}

		/*
		  Reopen Forum.
		  If the forum was configured
		  to auto close while backing up
		  the database, this will restore
		  the forum to running status.
		*/
		if ($this->SHUTDOWN) { $this->forumStatus(1); }

		/*
		  Compress & Archive.
		  If compression was selected
		  we will attempt to compress
		  and archive the file and then
		  cleanup anything leftover.
		*/
		if ($this->COMPRESS)
		{
			/* Compress File */
			$this->compressDump();

			/* Check Combining */
			if (!$this->TYPE && !$this->COMBINE)
			{
				/* Remove Directory */
				$this->removeDir($this->SHORT_PATH.$this->DATE);
			}
			else
			{
				/* Remove SQL File */
				$this->removeFile($this->FULL_PATH.'.sql');
			}
		}

		/*
		  Transfer FTP.
		  If selected, this option
		  will transfer the newest 
		  backup directly to the 
		  remote server, as well as 
		  keep the backups synced
		  with the local files.
		*/
		if ($this->FTP)
		{
			if (!$this->TYPE && !$this->COMBINE)
			{
				$this->throwError(FTP_NOT_HANDLE_DIR);
			}
			else
			{
				/* FTP Path */
				$this->FTP_FULL_PATH = ($this->FTPDIR ? $this->FTPDIR.'/' : '');

				/* Initiate FTP Handler */
				$this->ftpLibrary();
			}
		}

		/* 
		  Check Failover.
		  If Failover was initiated
		  without any other errors, we
		  are still going to set that in
		  the status.
		*/

		if ($this->FAILOVER)
		{
			$this->STATUS = "Failover was initiated for MySQLDump Binary, but dump completed successfully.";
		}
	}

	// HTML Based Manual Backup
	function htmlBackup()
	{
		/*
		  The reason for the creation of this function is so that we
		  can provide a web-based area to override configuration 
		  options as well as test out certain functions used in the backup
		  process without doing a full backup of the target database.
		*/
	}



	/* -------------- Named Constructor ------------- */

	// Initiate Constructor
	function mysqlBackup(&$config,&$DB_site)
	{
		/* Set Time & Date */
		$this->TIME = time();

		/* Load Error Codes */
		parent::loadCodes();

		/* Set Default Status */
		$this->STATUS = $this->MESSAGES[NO_ERRORS];

		/* Reference Database Object */
		$this->MYSQL = &$DB_site;

		/* Get OS Type */
		if (strtoupper(substr(PHP_OS,0,3) == 'WIN'))
		{
			$this->OS = 1;
		}
		else
		{
			$this->OS = 0;
		}

		/* Get Local Config Options */
		$ini = ini_get_all();

		/* Fetch Local SafeMode Value */
		if (intval($ini['safe_mode']['local_value']) == 1)
		{
			$this->SAFEMODE = 1;
		}
		else
		{
			$this->SAFEMODE = 0;
		}

		/* MySQL Information */
		$this->HOST = &$config['HOST'];
		$this->USER = &$config['USER'];
		$this->PASS = &$config['PASS'];
		$this->DB   = &$config['DB'];

		/* Forum Shutdown System */
		$this->SHUTDOWN = &$config['SHUTDOWN'];
		$this->MESSAGE  = &$config['MESSAGE'];

		/* Backup Pruning */
		$this->PRUNE = &$config['PRUNE'];
		$this->DUMPS = &$config['DUMPS'];

		/* File Saving Information */
		$this->DATE      = date($config['DATE']);
		$this->DUMP_PATH = &$config['DUMP_PATH'];

		/* Remote FTP */
		$this->FTP       = &$config['FTP'];
		$this->FTPHOST   = &$config['FTPHOST'];
		$this->FTPPORT   = &$config['FTPPORT'];
		$this->FTPUSER   = &$config['FTPUSER'];
		$this->FTPPASS   = &$config['FTPPASS'];
		$this->FTPDIR    = &$config['FTPDIR'];
		$this->FTPDELLOC = &$config['FTPDELLOC'];
		$this->FTPPRUNE  = &$config['FTPPRUNE'];
		$this->FTPDUMPS  = &$config['FTPDUMPS'];

		/* Log Raw MySQL Errors */
		$this->LOG_ERRORS   = &$config['LOG_ERRORS'];
		$this->LOG_PATH     = &$config['LOG_PATH'];
		$this->LOG_FILENAME = &$config['LOG_FILENAME'];

		/* Backup Method & Lock & Repair*/
		$this->METHOD = &$config['METHOD'];
		$this->LOCK   = &$config['LOCK'];
		$this->REPAIR = &$config['REPAIR'];

		/* Backup Type & Tables & Combine */
		$this->TYPE    = &$config['TYPE'];
		$this->TABLES  = &$config['TABLES'];
		$this->COMBINE = &$config['COMBINE'];

		/* Backup Optimizations */
		$this->MYSQL4 	  = &$config['MYSQL4'];
		$this->INNODB 	  = &$config['INNODB'];
		$this->LOCKTABLES = &$config['LOCKTABLES'];

		/* PHP Execution Function */
		$this->COMMAND = &$config['COMMAND'];

		/* MySQLDump Binary Path */
		$this->MYSQLDUMP = &$config['MYSQLDUMP'];

		/* MySQLDump Operator Switches */
		$this->SWITCHES = &$config['SWITCHES'];

		/* Compression Options */
		$this->COMPRESS    = &$config['COMPRESS'];
		$this->BUFFER      = &$config['BUFFER'];
		$this->COMPRESSION = &$config['COMPRESSION'];
		$this->COMPRESSORS = &$config['COMPRESSORS'];

		/* Get Database Options */
		if ($this->SHUTDOWN)
		{
			/* Get Options */
			$this->OPTIONS = $this->MYSQL->query_first("SELECT `data` FROM `".TABLE_PREFIX."datastore` WHERE `title` = 'options';");

			/* Unserialize */
			$this->OPTIONS = unserialize(stripslashes($this->OPTIONS['data']));

			/* Check For Corruption */
			if (!is_array($this->OPTIONS) || empty($this->OPTIONS))
			{
				$this->throwError(DB_OPTIONS);
			}
		}

		/* Pre Execution Cleanup */
		unset($ini);
	}
}

?>