<?php

/***********************************************************
*   PHP FTP Socket Client Library
*   By: Dusty Burns aka Trigunflame
*
*   Protocol Standards From: 
*   GPL FTP Client Class By: TOMO
*   
*   - Version 0.1 (03/23/2005)
************************************************************/

// ----- Transfer Modes
define ('FTP_ASCII',  0);
define ('FTP_BINARY', 1);

// ----- Command Line Return
define ('CLRF',  "\r\n");

// FTP Socket Library
Class FTP_SOCK_LIB
{
	/* -------------- Class Variables ---------------- */
	
	// Debug Output
	var $_debug;

	// Connection
	var $_host;
	var $_port;
	var $_user;
	var $_pass;

	// Socket
	var $_sock;
	var $_dsock;
	var $_errno;
	var $_errstr;

	// Various
	var $_umask;
	var $_timeout;

	// Response
	var $_response;

	/* ------------- Misc Class Methods ------------- */ 

	// Debug Output
	function _log($msg)
	{
		if ($this->_debug) { echo $msg."\n"; }
	}

	/* ---------- Secondary Class Methods ----------- */ 

	// Delete File
	function ftpDelete($file)
	{
		// Send Raw Delete
		$this->sendRaw("DELE ".$file);

		// Check Status
		if ($this->ftpStatus())
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// FTP Type
	function ftpType($mode=1)
	{
		// Set Type
		$type = ($mode ? 'I' : 'A');

		// Set Raw Type
		$this->sendRaw("TYPE ".$type);

		// Get Response
		if ($this->ftpStatus())
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// FTP Port
	function ftpPort($port)
	{
		// Set Raw Port
		$this->sendRaw("PORT ".$port);

		// Get Response
		if ($this->ftpStatus())
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// FTP Pasv
	function ftpPasv()
	{
		// Set Raw Passive
		$this->sendRaw("PASV");

		// Get Response
		if (!$this->ftpStatus())
		{
			return 0;
		}

		// Get Port Range
		$ports = ereg_replace(
			"^.+ \\(?([0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]+,[0-9]+)\\)?.*\r\n$", 
			"\\1", 
			$this->_response
		);

		// Return Ports
		return $ports;
	}

	// Data Connection
	function ftpDataConnect($ports)
	{
		// Check Format
		if (!ereg("[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]+,[0-9]+", $ports))
		{
			return 0;
		}

		// Raw Data
		$raw = explode(',',$ports);

		// IP & Ports
		$ip   = $raw[0].'.'.$raw[1].'.'.$raw[2].'.'.$raw[3];
		$port = ($raw[4]*256) + $raw[5];

		// Establish Data Connection
		$this->_dsock = @fsockopen($ip,$port,$errno,$errstr,$this->_timeout);

		// Check Status
		if ($this->_dsock)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// Data Disconnect
	function ftpDataDisconnect()
	{
		if (@fclose($this->_dsock))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// Send File
	function ftpSendFile($local,$remote)
	{
		// File Exist
		if (!@file_exists($local))
		{
			return 0;
		}

		// Open File
		if (!$file = @fopen($local, 'rb'))
		{
			return 0;
		}

		// Set Type
		if (!$this->ftpType(1))
		{
			return 0;
		}

		// Set Passive
		if (!($ports = $this->ftpPasv()))
		{
			return 0;
		}

		// Store Command
		$this->sendRaw("STOR ".$remote);

		// Open Data Connection
		if (!$this->ftpDataConnect($ports) || !$this->ftpStatus())
		{
			return 0;
		}

		// Store File
		while (!feof($file))
		{
			@fputs($this->_dsock, @fread($file,4096));
		}

		// Close File
		@fclose($file);
		
		// Close Connection
		$this->ftpDataDisconnect();

		// Check Status
		if (!$this->ftpStatus())
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}

	/* ------------- Core Class Methods ------------- */ 

	// Send Raw Command
	function sendRaw($cmd)
	{
		// Log
		$this->_log(">>> ".$cmd);

		// Send
		@fputs($this->_sock,$cmd.CLRF);
	}

	// FTP Status
	function ftpStatus()
	{
		// Null Response
		$this->_response = '';

		// Get Data
		do
		{
			$data = @fgets($this->_sock, 512);
			$this->_response .= $data;
		}
		while (substr($data,3,1) != " ");

		// Log
		$this->_log("<<< ".$this->_response);

		// Response Code
		if (!ereg("^[123]",$this->_response))
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}

	// Login
	function ftpLogin($user='anonymous',$pass='email@notset.com')
	{
		// Set User & Pass
		$this->_user = $user;
		$this->_pass = $pass;

		// Send User
		$this->sendRaw("USER ".$user);

		// Get Response
		if (!$this->ftpStatus())
		{
			return 0;
		}

		// Send Pass
		$this->sendRaw("PASS ".$pass);

		// Get Response
		if ($this->ftpStatus())
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// Disconnect
	function ftpDisconnect()
	{
		// Send Quit
		$this->sendRaw("QUIT");

		// Check Status
		if (!$this->ftpStatus() || !@fclose($this->_sock))
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}

	// Connect
	function ftpConnect()
	{
		// Establish Connection
		$this->_sock = @fsockopen(
			$this->_host,
			$this->_port,
			$this->_errno,
			$this->_errstr,
			$this->_timeout
		);

		// Check Status
		if ($this->_sock && $this->ftpStatus())
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	/* -------------- Class Constructor -------------- */

	// Constructor
	function FTP_SOCK_LIB($host,$port=21,$debug=0)
	{
		// Set Mask & TimeOut
		$this->_umask = 0022;
		$this->_timeout = 15;

		// Set Host & Port
		$this->_host = $host;
		$this->_port = $port;
		
		// Set Debug Value
		$this->_debug = $debug;
	}
}



/***********************************************************
*   PHP FTP Client Wrapper Library
*   By: Dusty Burns aka Trigunflame
*   
*   - Version 0.1 (03/23/2005)
************************************************************/

// PHP FTP Wrapper Library
Class FTP_WRAPPER_LIB
{
	/* -------------- Class Variables ---------------- */
	
	// Connection
	var $_host;
	var $_port;
	var $_user;
	var $_pass;

	// Stream
	var $_ftp;

	// Various
	var $_timeout;

	/* ---------- Secondary Class Methods ----------- */ 

	// Delete File
	function ftpDelete($file)
	{
		// Send Delete
		if (@ftp_delete($this->_ftp, $file))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// FTP Pasv
	function ftpPasv()
	{
		// Set Passive
		if (@ftp_pasv($this->_ftp,true))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// Send File
	function ftpSendFile($local,$remote)
	{
		// Set PASV Mode
		$this->ftpPasv();

		// Send File
		if (@ftp_put($this->_ftp,$remote,$local,FTP_BINARY))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	/* ------------- Core Class Methods ------------- */ 

	// Login
	function ftpLogin($user='anonymous',$pass='email@notset.com')
	{
		// Set User & Pass
		$this->_user = $user;
		$this->_pass = $pass;

		// Send Login
		if (@ftp_login($this->_ftp,$user,$pass))
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	// Disconnect
	function ftpDisconnect()
	{
		// Close Connection
		if (!@ftp_close($this->_ftp))
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}

	// Connect
	function ftpConnect()
	{
		// Establish Connection
		$this->_ftp = @ftp_connect(
			$this->_host,
			$this->_port,
			$this->_timeout
		);

		// Check Status
		if ($this->_ftp)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}

	/* -------------- Class Constructor -------------- */

	// Constructor
	function FTP_WRAPPER_LIB($host,$port=21)
	{
		// Set TimeOut
		$this->_timeout = 15;

		// Set Host & Port
		$this->_host = $host;
		$this->_port = $port;
	}
}

?>