/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class AudioPlayer
implements Runnable {
    private hijri controller;
    private String mediaType;
    private Player player;
    private long progressStep;
    private String url;
    private VolumeControl volumeControl;

    public AudioPlayer(hijri controller) {
        this.controller = controller;
    }

    public void close() {
        this.player.close();
        this.controller = null;
        this.url = null;
    }

    public long getTimeProgress() {
        long currnetMediaTime = 0L;
        try {
            currnetMediaTime = this.player.getMediaTime();
        }
        catch (IllegalStateException ise) {
            this.controller.showAlert("MediaException thrown", ise.getMessage());
        }
        return currnetMediaTime / this.progressStep;
    }

    public void initializeAudio(String url, String type) {
        this.url = url;
        this.mediaType = type;
        Thread initializer = new Thread(this);
        initializer.start();
    }

    public void replay() {
        try {
            this.player.start();
        }
        catch (MediaException me) {
            this.controller.showAlert("MediaException thrown", me.getMessage());
        }
    }

    public void resume() {
        try {
            this.player.stop();
            this.player.setMediaTime(10000L);
            this.player.start();
        }
        catch (MediaException me) {
            this.controller.showAlert("MediaException thrown", me.getMessage());
        }
    }

    public void run() {
        try {
            InputStream is = this.getClass().getResourceAsStream(this.url);
            this.player = Manager.createPlayer((InputStream)is, (String)this.mediaType);
            this.player.addPlayerListener((PlayerListener)this.controller);
            this.player.realize();
            this.player.prefetch();
            this.volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
            this.volumeControl.setLevel(this.controller.Curr_vol);
            this.player.setMediaTime(0L);
            this.player.start();
        }
        catch (IOException ioe) {
            this.controller.showAlert("Unable to connect to resource", ioe.getMessage());
        }
        catch (MediaException me) {
            this.controller.showAlert("Unable to create player", me.getMessage());
        }
    }

    public void setTimeProgress(int level) {
        try {
            this.player.stop();
            this.player.setMediaTime(this.player.getMediaTime() + 2000L);
            this.player.start();
        }
        catch (MediaException me) {
            this.controller.showAlert("MediaException thrown", me.getMessage());
        }
    }

    public void setVolume(int level) {
        this.volumeControl.setLevel(level);
    }
}

