<?php
error_reporting(E_ALL & ~E_NOTICE);

require_once('./global.php');

print_cp_header('Deleted Post Management');

include('./includes/functions_bbcodeparse.php');

echo "<center>";

$sep = '|';

if ($showthreads == 'no' OR $showposts == 'no')
{
	echo "<a href=\"deleted.php\">Show Posts &amp; Threads</a> | ";
	$sep = '';
}

if ($showthreads != 'no')
{
	echo "<a href=\"deleted.php?showthreads=no\">Show Posts Only</a> $sep";
}
if ($showposts != 'no')
{
	echo "<a href=\"deleted.php?showposts=no\">Show Threads Only</a>"; 
}

if ($showthreads != 'no')
{
	print_form_header('', '');
	print_table_header('Deleted Threads');

	$getthreads = $DB_site->query("SELECT deletionlog.*, post.*, post.dateline AS pdate, thread.*, thread.postusername AS tuser 
			FROM " . TABLE_PREFIX ."deletionlog AS deletionlog
			LEFT JOIN " . TABLE_PREFIX ."thread AS thread ON (deletionlog.primaryid = thread.threadid)
			LEFT JOIN " . TABLE_PREFIX ."post AS post ON (post.postid = thread.firstpostid)
			WHERE type = 'thread' ORDER BY post.dateline");
	while ($posts = $DB_site->fetch_array($getthreads))
	{
		print_form_header('', '');
		
		$title = '<a href="' . $vboptions['bburl'] .'/showthread.php?' . $session['sessionhash'] . 't=' . $posts['threadid'] . '" target="_blank">' . $posts['title'] . '</a>';
	 	print_table_header($title);
	
		$username = unhtmlspecialchars(stripslashes($posts['tuser']));
		$dateline = vbdate("$vboptions[timeformat] $vboptions[dateformat]", $posts['pdate']);
		print_cells_row(array("Posted by $username on $dateline"));
	
		if ($posts['reason'])
		{
			print_cells_row(array("<b>Reason:</b> $posts[reason]"));
		}
	
		print_cells_row(array(parse_bbcode($posts['pagetext'])));
		print_table_footer();
	}
	
	print_table_footer();
	
	echo "<br /><br /><br />";
}

if ($showposts != 'no')
{
	print_form_header('', '');
	print_table_header('Deleted Posts');
	
	$getposts = $DB_site->query("SELECT deletionlog.*, post.*, post.dateline AS pdate, thread.* 
			FROM " . TABLE_PREFIX ."deletionlog AS deletionlog
			LEFT JOIN " . TABLE_PREFIX ."post AS post ON (deletionlog.primaryid = post.postid)
			LEFT JOIN " . TABLE_PREFIX ."thread AS thread ON (post.threadid = thread.threadid)
			WHERE type = 'post'");
	while ($posts = $DB_site->fetch_array($getposts))
	{
		print_form_header('', '');
		
		$title = '<a href="' . $vboptions['bburl'] .'/showthread.php?' . $session['sessionhash'] . 't=' . $posts['threadid'] . '" target="_blank">' . $posts['title'] . '</a>';
	 	print_table_header($title);
	
		$username = unhtmlspecialchars(stripslashes($posts['username']));
		$dateline = vbdate("$vboptions[timeformat] $vboptions[dateformat]", $posts['pdate']);
		print_cells_row(array("Posted by $username on $dateline"));
	
		if ($posts['reason'])
		{
			print_cells_row(array("<b>Reason:</b> $posts[reason]"));
		}
	
		print_cells_row(array(parse_bbcode($posts['pagetext'])));
		print_table_footer();
	}
	print_table_footer();
}

print_cp_footer();
?>