/*
 * Decompiled with CFR 0.152.
 */
package com.soccer;

import com.soccer.Ball;
import com.soccer.GameScreen;
import com.soccer.MenuScreen;
import javax.microedition.lcdui.Graphics;

public abstract class Sprite {
    public int x;
    public int y;
    public int direction;
    public int frame;
    public int targetDirection;
    public int targetX;
    public int targetY;
    public int type;
    public int speed;
    public int sW;
    public int sH;
    public boolean hasBall;
    public boolean targetReached;
    public boolean active;

    public void draw(Graphics graphics) {
        graphics.setClip(-GameScreen.fieldX + this.x + 1, -GameScreen.fieldY + GameScreen.infoHeight + this.y + 3 * this.sH / 4 - 4, GameScreen.shadow.getWidth(), GameScreen.shadow.getHeight());
        graphics.drawImage(GameScreen.shadow, -GameScreen.fieldX + this.x + 1, -GameScreen.fieldY + GameScreen.infoHeight + this.y + 3 * this.sH / 4 - 4, 0);
        graphics.setClip(-GameScreen.fieldX + this.x, -GameScreen.fieldY + GameScreen.infoHeight + this.y, GameScreen.playerWidth, GameScreen.playerHeight);
        graphics.drawImage(GameScreen.players, -GameScreen.fieldX + this.x - GameScreen.playerWidth * (this.direction % 4), -GameScreen.fieldY + GameScreen.infoHeight + this.y - GameScreen.playerHeight * this.frame - 3 * GameScreen.playerHeight * (this.type == 0 ? GameScreen.userCommandColor : GameScreen.compCommandColor), 0);
        graphics.setClip(0, 0, GameScreen.gWidth, GameScreen.gHeight);
        graphics.setColor(0x80FF80);
        if (this.active) {
            graphics.drawArc(-GameScreen.fieldX + this.x - 3, -GameScreen.fieldY + GameScreen.infoHeight + this.y - 3, this.sW + 6, this.sH + 6, 0, 360);
        }
    }

    public int distance(Sprite sprite) {
        return (this.x + this.sW / 2 - (sprite.x + sprite.sW / 2)) * (this.x + this.sW / 2 - (sprite.x + sprite.sW / 2)) + (this.y + this.sH / 2 - (sprite.y + sprite.sH / 2)) * (this.y + this.sH / 2 - (sprite.y + sprite.sH / 2));
    }

    public int distance(int n, int n2) {
        return (this.x + this.sW / 2 - n) * (this.x + this.sW / 2 - n) + (this.y + this.sH / 2 - n2) * (this.y + this.sH / 2 - n2);
    }

    public void setPos(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.setSpeed();
    }

    public void setSpeed() {
        if (this.type == 0) {
            this.speed = 4;
        } else {
            switch (MenuScreen.difficulty) {
                case 0: {
                    this.speed = 2;
                    break;
                }
                case 1: {
                    this.speed = 3;
                    break;
                }
                case 2: {
                    this.speed = 4;
                }
            }
        }
    }

    public int move(int n, int n2) {
        int n3 = 0;
        if (this.type == 2) {
            if (this.x + n < 10) {
                if (this.y + n2 <= 30) {
                    this.x = 10;
                    this.y = 30;
                    GameScreen.nearestPlayerDirection = 3;
                    return 1;
                }
                if (this.y + n2 >= 520) {
                    this.x = 10;
                    this.y = 520;
                    GameScreen.nearestPlayerDirection = 1;
                    return 1;
                }
                this.y += n2 * (this.x - 10) / -n;
                this.x = 10;
                GameScreen.nearestPlayerDirection = 2;
                return 1;
            }
            if (this.x + n > 340) {
                if (this.y + n2 <= 30) {
                    this.x = 340;
                    this.y = 30;
                    GameScreen.nearestPlayerDirection = 5;
                    return 1;
                }
                if (this.y + n2 >= 520) {
                    this.x = 340;
                    this.y = 520;
                    GameScreen.nearestPlayerDirection = 7;
                    return 1;
                }
                this.y += n2 * (340 - this.x) / n;
                this.x = 340;
                GameScreen.nearestPlayerDirection = 6;
                return 1;
            }
            if (this.y + n2 < 30) {
                this.x += n * (this.y - 30) / -n2;
                this.y = 30;
                GameScreen.nearestPlayerDirection = 4;
                return 1;
            }
            if (this.y + n2 > 520) {
                this.x += n * (520 - this.y) / n2;
                this.y = 520;
                GameScreen.nearestPlayerDirection = 0;
                return 1;
            }
            if (this.x + n > 10 && this.x + n < 340) {
                this.x += n;
            }
            if (this.y + n2 > 30 && this.y + n2 < 520) {
                this.y += n2;
            }
            this.frame = (this.frame + 1) % 2;
        } else {
            if (GameScreen.mode != 4 && this.x + n * this.speed + this.sW >= 140 && this.x + n * this.speed <= 210 && (this.y + n2 * this.speed >= 0 && this.y + n2 * this.speed <= 40 || this.y + n2 * this.speed >= 510 && this.y + n2 * this.speed <= 550)) {
                return -1;
            }
            if (this.x + n * this.speed + this.sW / 2 > 7 && this.x + n * this.speed + this.sW / 2 < 343) {
                this.x += n * this.speed;
            }
            if (this.y + n2 * this.speed + this.sH / 2 > 27 && this.y + n2 * this.speed + this.sH / 2 < 523) {
                this.y += n2 * this.speed;
            }
            this.frame = (this.frame + 1) % 3;
        }
        this.correctBallPosition();
        return n3;
    }

    public void setTarget(int n, int n2, int n3) {
        this.targetReached = false;
        this.targetX = n;
        this.targetY = n2;
        this.targetDirection = n3;
        this.setSpeed();
    }

    public boolean goToTarget() {
        if (this.targetReached) {
            return true;
        }
        if (this.distanceAfterMove(this.targetX, this.targetY, this.targetX, this.targetY) < this.distance(this.targetX, this.targetY)) {
            this.moveTo(this.targetX, this.targetY, false);
        } else {
            this.targetReached = true;
            this.direction = this.targetDirection;
            this.setSpeed();
        }
        return this.targetReached;
    }

    public void moveTo(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        if (this.x < n) {
            n3 = 1;
        } else if (this.x > n) {
            n3 = -1;
        }
        if (Math.abs(this.x - n) < this.speed) {
            n3 = 0;
        }
        if (this.y < n2) {
            n4 = 1;
        } else if (this.y > n2) {
            n4 = -1;
        }
        if (Math.abs(this.y - n2) < this.speed) {
            n4 = 0;
        }
        this.direction = this.detectDirection(n3, n4);
        if (this.move(n3, n4) != -1 || this.move(n3, 0) != -1 || this.move(0, n4) == -1) {
            // empty if block
        }
    }

    public int distanceAfterMove(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (this.x < n) {
            n5 = 1;
        } else if (this.x > n) {
            n5 = -1;
        }
        if (Math.abs(this.x - n) < this.speed) {
            n5 = 0;
        }
        if (this.y < n2) {
            n6 = 1;
        } else if (this.y > n2) {
            n6 = -1;
        }
        if (Math.abs(this.y - n2) < this.speed) {
            n6 = 0;
        }
        if (GameScreen.mode != 4 && this.x + n5 * this.speed + this.sW >= 140 && this.x + n5 * this.speed <= 210 && (this.y + n6 * this.speed >= 0 && this.y + n6 * this.speed <= 40 || this.y + n6 * this.speed >= 510 && this.y + n6 * this.speed <= 550)) {
            n6 = 0;
            n5 = 0;
        }
        n = this.x + n5 * this.speed + this.sW / 2 > 7 && this.x + n5 * this.speed + this.sW / 2 < 343 ? this.x + this.sW / 2 + n5 * this.speed : this.x + this.sW / 2;
        n2 = this.y + n6 * this.speed + this.sH / 2 > 27 && this.y + n6 * this.speed + this.sH / 2 < 523 ? this.y + this.sH / 2 + n6 * this.speed : this.y + this.sH / 2;
        return (n - n3) * (n - n3) + (n2 - n4) * (n2 - n4);
    }

    public int detectDirection(int n, int n2) {
        if (n2 == -1) {
            if (n == -1) {
                return 7;
            }
            if (n == 1) {
                return 1;
            }
            return 0;
        }
        if (n2 == 1) {
            if (n == -1) {
                return 5;
            }
            if (n == 1) {
                return 3;
            }
            return 4;
        }
        if (n == -1) {
            return 6;
        }
        if (n == 1) {
            return 2;
        }
        return -1;
    }

    public void setBallOwn() {
        this.hasBall = true;
        GameScreen.ball.ballSpeed = Ball.speeds.length;
        GameScreen.ball.lastBallOwner = this.type;
        GameScreen.stepsDone = 0;
        this.correctBallPosition();
    }

    public void correctBallPosition() {
        if (this.hasBall) {
            switch (this.direction) {
                case 0: {
                    GameScreen.ball.setPos(this.x + (this.sW - GameScreen.ball.sW) / 2, this.y - GameScreen.ball.sH / 2);
                    break;
                }
                case 1: {
                    GameScreen.ball.setPos(this.x + this.sW * 3 / 4, this.y);
                    break;
                }
                case 2: {
                    GameScreen.ball.setPos(this.x + this.sW - GameScreen.ball.sW / 2, this.y + (this.sH - GameScreen.ball.sH) / 2);
                    break;
                }
                case 3: {
                    GameScreen.ball.setPos(this.x + this.sW * 3 / 4, this.y + this.sH / 2);
                    break;
                }
                case 4: {
                    GameScreen.ball.setPos(this.x + (this.sW - GameScreen.ball.sW) / 2, this.y + this.sH - GameScreen.ball.sH / 2);
                    break;
                }
                case 5: {
                    GameScreen.ball.setPos(this.x, this.y + this.sH / 2);
                    break;
                }
                case 6: {
                    GameScreen.ball.setPos(this.x - GameScreen.ball.sW / 2, this.y + (this.sH - GameScreen.ball.sH) / 2);
                    break;
                }
                case 7: {
                    GameScreen.ball.setPos(this.x, this.y);
                }
            }
        }
    }

    public int steps(int n, int n2, int n3, int n4) {
        if (Math.abs(n - n3) > Math.abs(n2 - n4)) {
            return Math.abs(n - n3) / this.speed;
        }
        return Math.abs(n2 - n4) / this.speed;
    }
}

