/*
 * Decompiled with CFR 0.152.
 */
package com.soccer;

import com.nokia.mid.ui.FullCanvas;
import com.soccer.Ball;
import com.soccer.GameMidlet;
import com.soccer.MenuScreen;
import com.soccer.SPlayer;
import com.soccer.UserPlayer;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScreen
extends FullCanvas
implements Runnable {
    int extraTime = 0;
    public static Image herb;
    public static Image top;
    public static Image bottom;
    public static Image confirm;
    public static Image mground;
    public static Image gate1;
    public static Image gate2;
    public static Image ballImage;
    private Image b;
    private Graphics bg;
    protected static Image players;
    protected static Image shadow;
    private final int nMessages;
    private String[] messages;
    public static final int nPlayers = 7;
    public static final int[][] nearBallPositions;
    private static final int messageDuration = 3000;
    public int[][][] startPositions;
    public static final int fieldWidth = 350;
    public static final int fieldHeight = 550;
    public static final int LEFT_LINE = 10;
    public static final int RIGHT_LINE = 340;
    public static final int LEFT_GOAL_LINE = 140;
    public static final int RIGHT_GOAL_LINE = 210;
    public static final int UP_LINE = 30;
    public static final int DOWN_LINE = 520;
    public static final int GKAREA_LEFT = 74;
    public static final int GKAREA_RIGHT = 276;
    public static final int GKAREA_UP = 90;
    public static final int GKAREA_DOWN = 460;
    protected static final int KICK_DIST = 75;
    protected static final int MODE_NONE = 0;
    protected static final int MODE_GAME = 1;
    protected static final int MODE_PAUSE = 2;
    protected static final int MODE_STARTWAIT = 3;
    protected static final int MODE_MOVEWAIT = 4;
    protected static final int MODE_GOAL = 5;
    protected static final int MODE_TIME_FINISHED = 6;
    protected static final int MODE_CONFIRM_EXIT = 7;
    protected static final int MODE_BALLOUTSIDE = 8;
    protected static final int MODE_KICKAWAITING = 9;
    protected static final int MODE_VS = 10;
    protected static final int MODE_GOALLINE = 11;
    protected static final int MODE_GOALLINEKICKAWAITING = 12;
    protected static final int MODE_HALFTIME = 13;
    protected static final int MODE_FAULT = 14;
    protected static final int MODE_PENALTYKICK = 15;
    protected static final int MODE_FREEKICK = 16;
    protected static int compCommand;
    protected static int userCommand;
    protected static int compCommandColor;
    protected static int userCommandColor;
    public static int fieldX;
    public static int fieldY;
    public static int playerWidth;
    public static int playerHeight;
    public static int gWidth;
    public static int gHeight;
    protected static int infoHeight;
    public static int screenWidth;
    public static int screenHeight;
    public static int herbsW;
    public static int herbsH;
    public static int direction;
    public static int lastReleased;
    public static int lastDirection;
    public static int stepsDone;
    public UserPlayer[] users;
    public UserPlayer[] comps;
    public UserPlayer[] all;
    private UserPlayer[] goalKeepers;
    public static Ball ball;
    private boolean keyUp = false;
    private boolean keyDown = false;
    private boolean keyLeft = false;
    private boolean keyRight = false;
    private boolean keyKick = false;
    private boolean additionTime = false;
    private boolean firstTime = false;
    private boolean[] commands;
    private int compSide = 0;
    private int gameType = 0;
    private int round = 0;
    private int messageTime = 0;
    private int messageType = 0;
    private int nextMessageType = -1;
    private int kickOffTeam = 0;
    private int startKickOffTeam = 0;
    private int destXCurrent;
    private int scoreComp = 0;
    private int scoreUser = 0;
    private int goalTime = 0;
    private int goalKeeperTime = 0;
    private int goalKeeper = 0;
    private int timeToEnd = 0;
    private int roundTime = 5;
    private int nearestPlayer = -1;
    private int goalLineKickWait = 0;
    private int faultTeam = 0;
    private int faultKicker = 0;
    private int faultKickWait = 0;
    public static int nearestPlayerDirection;
    protected static int mode;
    protected static int previousMode;
    private Font f = Font.getFont((int)0, (int)0, (int)8);
    private Font fbold = Font.getFont((int)0, (int)1, (int)0);
    private Random r = new Random();
    private Thread t;

    public GameScreen() {
        this.nMessages = 19;
        this.roundTime = GameMidlet.roundTime;
        gWidth = this.getWidth();
        gHeight = this.getHeight();
        this.b = Image.createImage((int)gWidth, (int)gHeight);
        this.bg = this.b.getGraphics();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/infostr.txt");
            this.messages = new String[19];
            int n = 0;
            while (n < 19) {
                int n2;
                this.messages[n] = "";
                while ((n2 = inputStream.read()) != 10) {
                    if (n2 != 13 && n2 != -1) {
                        int n3 = n;
                        this.messages[n3] = this.messages[n3] + (char)n2;
                    }
                    if (n2 == -1) break;
                }
                ++n;
            }
            ballImage = Image.createImage((String)"/ball.png");
            herb = Image.createImage((String)"/herb.png");
            gate1 = Image.createImage((String)"/gate1.png");
            gate2 = Image.createImage((String)"/gate2.png");
            players = Image.createImage((String)"/players.png");
            top = Image.createImage((String)"/top.png");
            bottom = Image.createImage((String)"/bottom.png");
            shadow = Image.createImage((String)"/shadow.png");
            confirm = Image.createImage((String)"/confirm.png");
            mground = Image.createImage((String)"/mground.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.commands = new boolean[MenuScreen.commands.length];
        playerWidth = players.getWidth() / 4;
        playerHeight = players.getHeight() / 48;
        infoHeight = top.getHeight();
        screenWidth = gWidth;
        screenHeight = gHeight - infoHeight - bottom.getHeight();
        herbsW = screenWidth / herb.getWidth() + 2;
        herbsH = screenHeight / herb.getHeight() + 2;
        this.startPositions = new int[2][4][3];
        this.startPositions[0][0][0] = 159;
        this.startPositions[0][0][1] = 0;
        this.startPositions[0][0][2] = 2;
        this.startPositions[0][1][0] = 190;
        this.startPositions[0][1][1] = 0;
        this.startPositions[0][1][2] = 6;
        this.startPositions[0][2][0] = 127;
        this.startPositions[0][2][1] = 34;
        this.startPositions[0][2][2] = 4;
        this.startPositions[0][3][0] = 222;
        this.startPositions[0][3][1] = 34;
        this.startPositions[0][3][2] = 0;
        this.startPositions[1][0][0] = 222;
        this.startPositions[1][0][1] = -34;
        this.startPositions[1][0][2] = 4;
        this.startPositions[1][1][0] = 127;
        this.startPositions[1][1][1] = -34;
        this.startPositions[1][1][2] = 0;
        this.startPositions[1][2][0] = 95;
        this.startPositions[1][2][1] = -10;
        this.startPositions[1][2][2] = 2;
        this.startPositions[1][3][0] = 254;
        this.startPositions[1][3][1] = -10;
        this.startPositions[1][3][2] = 6;
        this.all = new UserPlayer[16];
        this.users = new UserPlayer[7];
        this.comps = new UserPlayer[7];
        int n = 0;
        while (n < 7) {
            this.users[n] = new UserPlayer();
            this.comps[n] = new UserPlayer();
            this.comps[n].type = 1;
            this.all[n] = this.users[n];
            this.all[7 + n] = this.comps[n];
            ++n;
        }
        this.goalKeepers = new UserPlayer[2];
        this.goalKeepers[0] = new UserPlayer();
        this.goalKeepers[1] = new UserPlayer();
        this.goalKeepers[1].type = 1;
        this.all[14] = this.goalKeepers[0];
        this.all[15] = this.goalKeepers[1];
        ball = new Ball();
        GameScreen.ball.sW = ballImage.getWidth();
        GameScreen.ball.sH = ballImage.getHeight() / 2;
        this.timeToEnd = this.roundTime * 10;
        this.t = new Thread(this);
        this.t.start();
    }

    public int rnd(int n) {
        return Math.abs(this.r.nextInt()) % n;
    }

    public void randomizePlayers() {
        int n = 0;
        while (n < 7) {
            this.users[n].setPos(10 + this.rnd(330), this.compSide == 0 ? 275 + this.rnd(215) : 60 + this.rnd(215));
            this.comps[n].setPos(10 + this.rnd(330), this.compSide == 1 ? 275 + this.rnd(215) : 60 + this.rnd(215));
            this.comps[n].type = 1;
            ++n;
        }
    }

    public void selectCompCommand() {
        compCommand = this.gameType == 0 ? MenuScreen.compCommand : userCommand;
        while (this.commands[compCommand]) {
            compCommand = this.rnd(this.commands.length);
        }
        this.commands[GameScreen.compCommand] = true;
        compCommandColor = this.gameType == 0 ? MenuScreen.compCommand : compCommand;
    }

    public void startGame(int n) {
        this.gameType = n;
        this.round = 0;
        mode = 0;
        this.randomizePlayers();
        this.scoreComp = 0;
        this.scoreUser = 0;
        int n2 = 0;
        while (n2 < this.commands.length) {
            this.commands[n2] = false;
            ++n2;
        }
        userCommand = MenuScreen.command;
        userCommandColor = MenuScreen.commandColor;
        this.commands[GameScreen.userCommand] = true;
        this.selectCompCommand();
        this.timeToEnd = this.roundTime * 10;
        this.additionTime = false;
        this.startKickOffTeam = this.kickOffTeam = this.rnd(2);
        this.firstTime = true;
        this.startRound(0);
        if (n == 1) {
            this.messageTime = 3000;
            this.messageType = this.round;
        }
    }

    public void startRound(int n) {
        this.compSide = n;
        this.keyKick = false;
        this.keyRight = false;
        this.keyLeft = false;
        this.keyDown = false;
        this.keyUp = false;
        this.destXCurrent = 175;
        int n2 = 0;
        while (n2 < 7) {
            if (n2 < 4) {
                this.users[n2].setPos(this.startPositions[this.kickOffTeam][n2][0], 275 + (this.kickOffTeam == n ? this.startPositions[this.kickOffTeam][n2][1] : -this.startPositions[this.kickOffTeam][n2][1]));
                this.users[n2].direction = this.startPositions[this.kickOffTeam][n2][2];
                this.users[n2].active = false;
                this.comps[n2].setPos(this.startPositions[1 - this.kickOffTeam][n2][0], 275 + (this.kickOffTeam == n ? this.startPositions[1 - this.kickOffTeam][n2][1] : -this.startPositions[1 - this.kickOffTeam][n2][1]));
                this.comps[n2].direction = this.startPositions[1 - this.kickOffTeam][n2][2];
            } else {
                this.users[n2].setPos(10 + this.rnd(330), n == 0 ? 275 + this.rnd(235) : 40 + this.rnd(235));
                this.users[n2].direction = this.rnd(8);
                this.users[n2].active = false;
                this.comps[n2].setPos(10 + this.rnd(330), n == 1 ? 275 + this.rnd(235) : 40 + this.rnd(235));
                this.comps[n2].direction = this.rnd(8);
            }
            this.users[n2].hasBall = false;
            this.comps[n2].hasBall = false;
            ++n2;
        }
        ball.setPos(175, 275);
        GameScreen.ball.ballSpeed = Ball.speeds.length;
        this.goalKeepers[n].setPos(175, 523 - playerHeight);
        this.goalKeepers[n].speed = 2;
        this.goalKeepers[1 - n].setPos(175, 27);
        this.goalKeepers[1 - n].speed = 2;
        this.goalKeepers[n].direction = 0;
        this.goalKeepers[1 - n].direction = 4;
        if (this.kickOffTeam == 0) {
            this.nextMessageType = 15;
        }
        mode = 3;
    }

    public void drawMessage(Graphics graphics, int n) {
        graphics.drawImage(mground, (this.getWidth() - mground.getWidth()) / 2, (this.getHeight() - mground.getHeight()) / 2, 0);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.fbold);
        graphics.drawString(this.messages[n], (gWidth - this.fbold.stringWidth(this.messages[n])) / 2, (gHeight - this.fbold.getHeight()) / 2, 16);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void drawField(Graphics graphics) {
        int n = -(fieldX % herb.getWidth());
        int n2 = -(fieldY % herb.getHeight());
        int n3 = 0;
        while (n3 < herbsH) {
            int n4 = 0;
            while (n4 < herbsW) {
                graphics.drawImage(herb, n + n4 * herb.getWidth(), n2 + n3 * herb.getHeight() + infoHeight, 0);
                ++n4;
            }
            ++n3;
        }
        graphics.setColor(7073651);
        graphics.drawLine(-fieldX + 10, -fieldY + infoHeight + 30, -fieldX + 10, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 10 - 1, -fieldY + infoHeight + 30, -fieldX + 10 - 1, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 340, -fieldY + infoHeight + 30, -fieldX + 340, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 340 + 1, -fieldY + infoHeight + 30, -fieldX + 340 + 1, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 10, -fieldY + infoHeight + 30, -fieldX + 340, -fieldY + infoHeight + 30);
        graphics.drawLine(-fieldX + 10, -fieldY + infoHeight + 30 - 1, -fieldX + 340, -fieldY + infoHeight + 30 - 1);
        graphics.drawLine(-fieldX + 10, -fieldY + infoHeight + 520, -fieldX + 340, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 10, -fieldY + infoHeight + 520 + 1, -fieldX + 340, -fieldY + infoHeight + 520 + 1);
        graphics.drawArc(-fieldX + 125, -fieldY + infoHeight + 225, 100, 100, 0, 360);
        graphics.drawArc(-fieldX + 126, -fieldY + infoHeight + 226, 98, 98, 0, 360);
        graphics.drawLine(-fieldX + 10, -fieldY + infoHeight + 275, -fieldX + 340, -fieldY + infoHeight + 275);
        graphics.drawLine(-fieldX + 10, -fieldY + infoHeight + 276, -fieldX + 340, -fieldY + infoHeight + 276);
        graphics.drawLine(-fieldX + 74, -fieldY + infoHeight + 90 - 1, -fieldX + 276, -fieldY + infoHeight + 90 - 1);
        graphics.drawLine(-fieldX + 74, -fieldY + infoHeight + 90, -fieldX + 276, -fieldY + infoHeight + 90);
        graphics.drawLine(-fieldX + 74, -fieldY + infoHeight + 30, -fieldX + 74, -fieldY + infoHeight + 90);
        graphics.drawLine(-fieldX + 74 + 1, -fieldY + infoHeight + 30, -fieldX + 74 + 1, -fieldY + infoHeight + 90);
        graphics.drawLine(-fieldX + 276 - 1, -fieldY + infoHeight + 30, -fieldX + 276 - 1, -fieldY + infoHeight + 90);
        graphics.drawLine(-fieldX + 276, -fieldY + infoHeight + 30, -fieldX + 276, -fieldY + infoHeight + 90);
        graphics.drawLine(-fieldX + 74, -fieldY + infoHeight + 460, -fieldX + 276, -fieldY + infoHeight + 460);
        graphics.drawLine(-fieldX + 74, -fieldY + infoHeight + 460 - 1, -fieldX + 276, -fieldY + infoHeight + 460 - 1);
        graphics.drawLine(-fieldX + 74, -fieldY + infoHeight + 460, -fieldX + 74, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 74 + 1, -fieldY + infoHeight + 460, -fieldX + 74 + 1, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 276 - 1, -fieldY + infoHeight + 460, -fieldX + 276 - 1, -fieldY + infoHeight + 520);
        graphics.drawLine(-fieldX + 276, -fieldY + infoHeight + 460, -fieldX + 276, -fieldY + infoHeight + 520);
        graphics.drawArc(-fieldX + 175 - 101, -fieldY + infoHeight + 125 - 202, 202, 202, 220, 100);
        graphics.drawArc(-fieldX + 175 - 100, -fieldY + infoHeight + 125 - 201, 200, 200, 220, 100);
        graphics.drawArc(-fieldX + 175 - 101, -fieldY + infoHeight + 550 - 125, 202, 202, 40, 100);
        graphics.drawArc(-fieldX + 175 - 100, -fieldY + infoHeight + 550 - 124, 200, 200, 40, 100);
        if (fieldY <= gate1.getHeight()) {
            graphics.drawImage(gate1, -fieldX + (350 - gate1.getWidth()) / 2, -fieldY + infoHeight + 0, 0);
        }
        if (fieldY >= 550 - screenHeight - gate2.getHeight()) {
            graphics.drawImage(gate2, -fieldX + (350 - gate2.getWidth()) / 2, -fieldY + infoHeight + 550 - gate2.getHeight(), 0);
        }
    }

    public void paint(Graphics graphics) {
        if (mode != 0) {
            this.drawField(this.bg);
            int n = 0;
            while (n < 7) {
                this.users[n].draw(this.bg);
                this.comps[n].draw(this.bg);
                ++n;
            }
            this.goalKeepers[0].draw(this.bg);
            this.goalKeepers[1].draw(this.bg);
            ball.draw(this.bg);
            this.bg.drawImage(top, 0, 0, 0);
            this.bg.clipRect(40, 5, MenuScreen.formWidth, MenuScreen.form.getHeight());
            this.bg.drawImage(MenuScreen.form, 40 - MenuScreen.formWidth * userCommand, 5, 0);
            this.bg.setClip(0, 0, this.getWidth(), this.getHeight());
            this.bg.clipRect(110, 5, MenuScreen.formWidth, MenuScreen.form.getHeight());
            this.bg.drawImage(MenuScreen.form, 110 - MenuScreen.formWidth * compCommandColor, 5, 0);
            this.bg.setClip(0, 0, this.getWidth(), this.getHeight());
            this.drawScore(this.bg);
            this.bg.drawImage(bottom, 0, gHeight - bottom.getHeight(), 0);
            if (mode == 5) {
                this.drawMessage(this.bg, 9);
            }
            if (this.messageTime > 0) {
                this.drawMessage(this.bg, this.messageType);
            }
            if (mode == 2) {
                this.drawMessage(this.bg, 10);
            } else if (mode == 7) {
                this.bg.drawImage(confirm, 0, gHeight - confirm.getHeight(), 0);
            }
            graphics.drawImage(this.b, 0, 0, 0);
        }
    }

    public void drawScore(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.fbold);
        graphics.drawString(Integer.toString(this.scoreUser), 73, 8, 16);
        graphics.drawString(Integer.toString(this.scoreComp), 95, 8, 16);
        int n = this.timeToEnd / 600;
        int n2 = this.timeToEnd / 10 % 60;
        String string = Integer.toString(n) + ":" + (n2 < 10 ? "0" : "") + Integer.toString(n2);
        graphics.drawString(string, gWidth - this.fbold.stringWidth(string) - 2, 1, 16);
        if (this.additionTime) {
            if (this.timeToEnd < this.extraTime / 2) {
                graphics.drawString("2et", 0, 1, 16);
            } else {
                graphics.drawString("1et", 0, 1, 16);
            }
        }
        graphics.setFont(this.f);
        graphics.setColor(0x80FF80);
        graphics.drawString(MenuScreen.commands[userCommand], 0, 12, 16);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(MenuScreen.commands[compCommand], gWidth - this.f.stringWidth(MenuScreen.commands[compCommand]), 12, 16);
    }

    public void fault() {
        mode = 14;
        if (this.goalKeepers[this.faultTeam].distance(ball) < this.goalKeepers[1 - this.faultTeam].distance(ball) && 74 <= GameScreen.ball.x && GameScreen.ball.x <= 276 && (GameScreen.ball.y <= 90 || GameScreen.ball.y >= 460)) {
            this.messageType = 17;
            this.messageTime = 3000;
        } else {
            this.messageType = 18;
            this.messageTime = 3000;
        }
    }

    public void penaltyKick() {
        int n = 175;
        int n2 = 90 - playerHeight;
        int n3 = 20;
        int n4 = 0;
        if (this.goalKeepers[this.faultTeam].y > 275) {
            n2 = 460;
            n3 = -20;
            n4 = 4;
        }
        int n5 = -1;
        this.faultKicker = -1;
        int n6 = 0;
        while (n6 < 14) {
            if (this.all[n6].type == 1 - this.faultTeam && (this.faultKicker == -1 || n5 > this.all[n6].distance(n, n2))) {
                this.faultKicker = n6;
                n5 = this.all[n6].distance(n, n2);
            }
            while (this.all[n6].x + playerWidth >= 74 && this.all[n6].x <= 276 && (this.all[n6].y <= 90 || this.all[n6].y + playerHeight >= 460)) {
                this.all[n6].y += n3;
            }
            this.all[n6].hasBall = false;
            this.all[n6].active = false;
            ++n6;
        }
        this.goalKeepers[this.faultTeam].x = n;
        this.all[this.faultKicker].setPos(n, n2);
        this.all[this.faultKicker].direction = n4;
        this.all[this.faultKicker].setBallOwn();
        this.all[this.faultKicker].correctBallPosition();
        mode = 15;
    }

    public void doPenaltyKick() {
        this.all[this.faultKicker].hasBall = false;
        ball.kickBall(this.all[this.faultKicker].direction, 0, 3 + this.rnd(5));
        ball.ballMove();
        mode = 1;
    }

    public void doFreeKick() {
        this.all[this.faultKicker].hasBall = false;
        ball.kickBall(this.all[this.faultKicker].direction);
        ball.ballMove();
        mode = 1;
    }

    public void freeKick() {
        int n;
        int n2;
        int n3 = -1;
        this.faultKicker = -1;
        boolean[] blArray = new boolean[14];
        int n4 = 0;
        while (n4 < 14) {
            if (this.all[n4].type == 1 - this.faultTeam && (this.faultKicker == -1 || n3 > this.all[n4].distance(GameScreen.ball.x, GameScreen.ball.y))) {
                this.faultKicker = n4;
                n3 = this.all[n4].distance(GameScreen.ball.x, GameScreen.ball.y);
            }
            blArray[n4] = false;
            this.all[n4].hasBall = false;
            this.all[n4].active = false;
            ++n4;
        }
        int n5 = 0;
        int[][] nArray = new int[3][2];
        if (GameScreen.ball.y >= 90 && GameScreen.ball.y + GameScreen.ball.sH <= 460) {
            if (this.goalKeepers[this.faultTeam].y < GameScreen.ball.y) {
                n5 = 0;
                n2 = -50;
                n = n2 * (this.goalKeepers[this.faultTeam].x - GameScreen.ball.x) / (this.goalKeepers[this.faultTeam].y - GameScreen.ball.y);
            } else {
                n5 = 4;
                n2 = 50;
                n = n2 * (this.goalKeepers[this.faultTeam].x - GameScreen.ball.x) / (this.goalKeepers[this.faultTeam].y - GameScreen.ball.y);
            }
            nArray[0][0] = n - 15;
            nArray[0][1] = n2;
            nArray[1][0] = n;
            nArray[1][1] = n2;
            nArray[2][0] = n + 15;
            nArray[2][1] = n2;
        } else {
            if (this.goalKeepers[this.faultTeam].x < GameScreen.ball.x) {
                n5 = 6;
                n2 = 0;
                n = -50;
            } else {
                n5 = 2;
                n2 = 0;
                n = 50;
            }
            nArray[0][0] = n;
            nArray[0][1] = n2 - 15;
            nArray[1][0] = n;
            nArray[1][1] = n2;
            nArray[2][0] = n;
            nArray[2][1] = n2 + 15;
        }
        this.all[this.faultKicker].setPos(GameScreen.ball.x, GameScreen.ball.y);
        this.all[this.faultKicker].direction = n5;
        this.all[this.faultKicker].setBallOwn();
        this.all[this.faultKicker].correctBallPosition();
        if ((fieldY <= 90 || fieldY + screenHeight >= 460) && this.goalKeepers[this.faultTeam].distance(ball) < this.goalKeepers[1 - this.faultTeam].distance(ball)) {
            int n6 = 0;
            while (n6 < 3) {
                if (GameScreen.ball.x + nArray[n6][0] >= 10 && GameScreen.ball.x + nArray[n6][0] + playerWidth <= 340 && GameScreen.ball.y + nArray[n6][1] >= 30 && GameScreen.ball.y + nArray[n6][1] + playerHeight <= 520) {
                    n3 = -1;
                    int n7 = -1;
                    int n8 = 0;
                    while (n8 < 14) {
                        if (!(this.all[n8].type != this.faultTeam || blArray[n8] || n7 != -1 && this.all[n8].distance(ball) >= n3)) {
                            n7 = n8;
                            n3 = this.all[n8].distance(ball);
                        }
                        ++n8;
                    }
                    blArray[n7] = true;
                    this.all[n7].setPos(GameScreen.ball.x + nArray[n6][0], GameScreen.ball.y + nArray[n6][1]);
                    this.all[n7].direction = n5;
                }
                ++n6;
            }
        }
        mode = 16;
    }

    public void ballOutside() {
        if (GameScreen.ball.y > 30 && GameScreen.ball.y + GameScreen.ball.sH / 2 < 520) {
            this.nearestPlayer = -1;
            int n = 0;
            while (n < 14) {
                this.all[n].hasBall = false;
                this.all[n].active = false;
                this.all[n].targetReached = true;
                if (this.all[n].type == 1 - GameScreen.ball.lastBallOwner && (this.nearestPlayer == -1 || this.all[this.nearestPlayer].distance(ball) > this.all[n].distance(ball))) {
                    this.nearestPlayer = n;
                }
                ++n;
            }
            this.all[this.nearestPlayer].setTarget(GameScreen.ball.x, GameScreen.ball.y, nearestPlayerDirection);
            int[] nArray = new int[]{0, 1};
            int n2 = 0;
            while (n2 < 14) {
                if (n2 != this.nearestPlayer) {
                    while (nArray[this.all[n2].type] < nearBallPositions.length) {
                        int n3 = GameScreen.ball.x + GameScreen.ball.sW / 2;
                        int n4 = GameScreen.ball.y + GameScreen.ball.sH / 2;
                        if (this.all[n2].type == 1 - GameScreen.ball.lastBallOwner) {
                            n3 += nearBallPositions[nArray[this.all[n2].type]][0] * 3 / 5;
                            n4 += nearBallPositions[nArray[this.all[n2].type]][1] * 3 / 5;
                        } else {
                            n3 += nearBallPositions[nArray[this.all[n2].type]][0] * 4 / 5;
                            n4 += nearBallPositions[nArray[this.all[n2].type]][1] * 4 / 5;
                        }
                        if (10 <= n3 + playerWidth / 2 && n3 - playerWidth / 2 <= 340 && 30 <= n4 + playerHeight / 2 && n4 - playerHeight / 2 <= 520) {
                            this.all[n2].setTarget(n3, n4, this.all[n2].direction);
                            int n5 = this.all[n2].type;
                            nArray[n5] = nArray[n5] + 1;
                            break;
                        }
                        int n6 = this.all[n2].type;
                        nArray[n6] = nArray[n6] + 1;
                    }
                    if (this.all[n2].targetReached) {
                        this.all[n2].setPos(10 + this.rnd(330), 40 + this.rnd(470));
                    }
                }
                ++n2;
            }
            this.messageType = 14;
            this.messageTime = 3000;
            mode = 8;
        } else {
            int n = 0;
            while (n < 16) {
                this.all[n].hasBall = false;
                this.all[n].active = false;
                ++n;
            }
            this.messageType = ball.distance(this.goalKeepers[GameScreen.ball.lastBallOwner]) > ball.distance(this.goalKeepers[1 - GameScreen.ball.lastBallOwner]) ? 12 : 13;
            this.messageTime = 3000;
            mode = 11;
        }
    }

    public void kickOutBall() {
        this.all[this.nearestPlayer].hasBall = false;
        if (nearestPlayerDirection % 2 == 1) {
            ball.kickBall(nearestPlayerDirection);
        } else if (nearestPlayerDirection == 0) {
            int n = this.rnd(3);
            if (n == 2) {
                ball.kickBall(7);
            } else {
                ball.kickBall(n);
            }
        } else {
            ball.kickBall(nearestPlayerDirection - 1 + this.rnd(3));
        }
        ball.ballMove();
        mode = 1;
    }

    public void goalKick() {
        int n = 0;
        if (this.goalKeepers[1].distance(ball) < this.goalKeepers[0].distance(ball)) {
            n = 1;
        }
        this.goalKeepers[n].setBallOwn();
        this.goalKeepers[n].direction = this.goalKeepers[n].y < 275 ? 4 : 0;
        this.goalKeepers[n].correctBallPosition();
    }

    public void cornerKick() {
        int n = -1;
        int n2 = 13;
        int n3 = 33;
        int n4 = 3;
        if (ball.distance(340, 30) < ball.distance(n2, n3)) {
            n2 = 337;
            n3 = 33;
            n4 = 5;
        }
        if (ball.distance(340, 520) < ball.distance(n2, n3)) {
            n2 = 337;
            n3 = 517;
            n4 = 7;
        }
        if (ball.distance(10, 520) < ball.distance(n2, n3)) {
            n2 = 13;
            n3 = 517;
            n4 = 1;
        }
        int n5 = 0;
        while (n5 < 14) {
            if (this.all[n5].type == 1 - GameScreen.ball.lastBallOwner && (n == -1 || this.all[n].distance(n2, n3) > this.all[n5].distance(n2, n3))) {
                n = n5;
            }
            ++n5;
        }
        this.all[n].setPos(n2, n3);
        this.all[n].direction = n4;
        this.all[n].setBallOwn();
        this.all[n].correctBallPosition();
    }

    public void goalLineKickBall() {
        int n = 0;
        while (n < 16) {
            if (this.all[n].hasBall) {
                int n2 = this.all[n].direction;
                if (this.messageType == 12) {
                    int n3 = -1;
                    int n4 = -1;
                    int n5 = 0;
                    while (n5 < 14) {
                        if (this.all[n].type == this.all[n5].type && (n3 == -1 || this.all[n].distance(this.all[n5]) < n4)) {
                            n4 = this.all[n].distance(this.all[n5]);
                            n3 = n5;
                        }
                        ++n5;
                    }
                    if (this.all[n].y < 275) {
                        n2 = 4;
                        n4 = this.all[n3].distance(this.all[n].x, this.all[n].y + 10);
                        if (n4 > this.all[n3].distance(this.all[n].x + 10, this.all[n].y + 10)) {
                            n4 = this.all[n3].distance(this.all[n].x + 10, this.all[n].y + 10);
                            n2 = 3;
                        }
                        if (n4 > this.all[n3].distance(this.all[n].x - 10, this.all[n].y + 10)) {
                            n4 = this.all[n3].distance(this.all[n].x - 10, this.all[n].y + 10);
                            n2 = 5;
                        }
                    } else {
                        n2 = 0;
                        n4 = this.all[n3].distance(this.all[n].x, this.all[n].y - 10);
                        if (n4 > this.all[n3].distance(this.all[n].x + 10, this.all[n].y - 10)) {
                            n4 = this.all[n3].distance(this.all[n].x + 10, this.all[n].y - 10);
                            n2 = 1;
                        }
                        if (n4 > this.all[n3].distance(this.all[n].x - 10, this.all[n].y - 10)) {
                            n4 = this.all[n3].distance(this.all[n].x - 10, this.all[n].y - 10);
                            n2 = 7;
                        }
                    }
                }
                this.all[n].hasBall = false;
                ball.kickBall(n2);
                ball.ballMove();
            }
            ++n;
        }
        mode = 1;
    }

    public void run() {
        while (!GameMidlet.stopGame) {
            try {
                int n;
                if (mode == 0) {
                    Thread.sleep(500L);
                    continue;
                }
                if (mode == 11) {
                    if (this.messageTime <= 0) {
                        if (this.messageType == 12) {
                            this.goalKick();
                        } else {
                            this.cornerKick();
                        }
                        this.goalLineKickWait = 0;
                        mode = 12;
                    }
                } else if (mode == 12) {
                    ++this.goalLineKickWait;
                    if (GameScreen.ball.lastBallOwner == 1 && this.goalLineKickWait >= 5 || GameScreen.ball.lastBallOwner == 0 && this.keyKick) {
                        this.goalLineKickBall();
                        this.keyKick = false;
                    }
                } else if (mode == 13 && this.messageTime <= 0) {
                    this.kickOffTeam = 1 - this.startKickOffTeam;
                    this.startRound(1 - this.compSide);
                } else if (mode == 14 && this.messageTime <= 0) {
                    this.faultKickWait = 0;
                    if (this.messageType == 17) {
                        this.penaltyKick();
                    } else {
                        this.freeKick();
                    }
                } else if (mode == 15) {
                    ++this.faultKickWait;
                    if (this.faultTeam == 0) {
                        if (this.faultKickWait > 10) {
                            this.doPenaltyKick();
                        } else if (this.faultKickWait == 7) {
                            this.all[this.faultKicker].direction = GameScreen.ball.y < 275 ? (this.rnd(3) == 0 ? 7 : this.rnd(2)) : 3 + this.rnd(3);
                            this.all[this.faultKicker].correctBallPosition();
                        }
                    } else if (this.keyKick) {
                        this.doPenaltyKick();
                    } else if (direction != -1) {
                        this.all[this.faultKicker].direction = direction;
                        this.all[this.faultKicker].correctBallPosition();
                    }
                } else if (mode == 16) {
                    ++this.faultKickWait;
                    if (this.faultTeam == 0) {
                        if (this.faultKickWait > 10) {
                            this.doFreeKick();
                        } else if (this.faultKickWait == 7) {
                            if (this.all[this.faultKicker].direction == 0) {
                                this.all[this.faultKicker].direction = this.rnd(3) == 0 ? 7 : this.rnd(2);
                            } else if (this.all[this.faultKicker].direction == 4) {
                                this.all[this.faultKicker].direction = 3 + this.rnd(3);
                            }
                            this.all[this.faultKicker].correctBallPosition();
                        }
                    } else if (this.keyKick) {
                        this.doFreeKick();
                    } else if (direction != -1) {
                        this.all[this.faultKicker].direction = direction;
                        this.all[this.faultKicker].correctBallPosition();
                    }
                } else if (mode == 6 && this.messageTime <= 0) {
                    if (this.gameType == 0) {
                        mode = 0;
                        GameMidlet.m_display.setCurrent((Displayable)GameMidlet.menuScreen);
                    } else if (this.scoreComp > this.scoreUser) {
                        mode = 0;
                        GameMidlet.m_display.setCurrent((Displayable)GameMidlet.menuScreen);
                    } else if (this.scoreComp == this.scoreUser) {
                        mode = 0;
                        GameMidlet.m_display.setCurrent((Displayable)GameMidlet.menuScreen);
                    } else if (this.round == 3) {
                        mode = 0;
                        GameMidlet.m_display.setCurrent((Displayable)GameMidlet.menuScreen);
                    } else {
                        this.scoreUser = 0;
                        this.scoreComp = 0;
                        this.timeToEnd = this.roundTime * 10;
                        this.firstTime = true;
                        this.randomizePlayers();
                        this.startKickOffTeam = this.kickOffTeam = this.rnd(2);
                        this.selectCompCommand();
                        this.startRound(0);
                        this.messageTime = 3000;
                        this.messageType = ++this.round;
                    }
                } else if (mode == 5) {
                    ++this.goalTime;
                    if (this.goalTime > 15) {
                        this.startRound(this.compSide);
                    }
                } else if (mode == 3) {
                    if (this.keyKick) {
                        mode = 1;
                        this.keyKick = false;
                    }
                } else if (mode == 8) {
                    boolean bl = true;
                    n = 0;
                    while (n < 14) {
                        bl = this.all[n].goToTarget() && bl;
                        bl = this.all[n].goToTarget() && bl;
                        bl = this.all[n].goToTarget() && bl;
                        ++n;
                    }
                    if (this.all[this.nearestPlayer].distance(ball) < 50) {
                        this.all[this.nearestPlayer].setBallOwn();
                        this.all[this.nearestPlayer].correctBallPosition();
                    }
                    if (bl) {
                        mode = 9;
                    }
                    this.keyKick = false;
                } else if (mode == 9) {
                    if (this.nearestPlayer >= 7 || this.keyKick) {
                        this.kickOutBall();
                    }
                } else if (mode == 4) {
                    boolean bl = true;
                    n = 0;
                    while (n < 7) {
                        bl = this.users[n].goToTarget() && bl;
                        bl = this.comps[n].goToTarget() && bl;
                        ++n;
                    }
                    if (bl) {
                        mode = 3;
                    }
                } else if (mode == 1) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17 = -1;
                    n = 0;
                    while (n < 7) {
                        if (this.users[n].hasBall) {
                            n17 = n;
                        }
                        ++n;
                    }
                    boolean[] blArray = new boolean[7];
                    int n18 = 0;
                    while (n18 < 7) {
                        blArray[n18] = false;
                        this.users[n18].active = false;
                        ++n18;
                    }
                    if (n17 != -1) {
                        blArray[n17] = true;
                        this.users[n17].userMove();
                        this.users[n17].active = true;
                        if (this.keyKick) {
                            ball.kickBall(this.users[n17].direction);
                            this.users[n17].hasBall = false;
                            this.keyKick = false;
                        }
                    } else {
                        int n19 = -1;
                        n16 = -1;
                        n15 = 0;
                        while (n15 < 7) {
                            if (n19 == -1 || n19 > ball.distance(this.users[n15])) {
                                n19 = ball.distance(this.users[n15]);
                            }
                            if (n16 < ball.distance(this.users[n15])) {
                                n16 = ball.distance(this.users[n15]);
                            }
                            ++n15;
                        }
                        n14 = 0;
                        while (n14 < 7) {
                            if (n19 == ball.distance(this.users[n14]) && (ball.distance(this.users[n14]) != n16 || n19 == n16)) {
                                blArray[n14] = true;
                                this.users[n14].userMove();
                                this.users[n14].active = true;
                            }
                            ++n14;
                        }
                    }
                    boolean[] blArray2 = new boolean[nearBallPositions.length];
                    n16 = 0;
                    while (n16 < nearBallPositions.length) {
                        blArray2[n16] = false;
                        ++n16;
                    }
                    n15 = 0;
                    while (n15 < 7) {
                        if (!blArray[n15]) {
                            n14 = GameScreen.ball.x + GameScreen.ball.sW / 2;
                            n13 = GameScreen.ball.y + GameScreen.ball.sH / 2;
                            n12 = -1;
                            n11 = -1;
                            n10 = 0;
                            while (n10 < nearBallPositions.length) {
                                if (!(blArray2[n10] || n11 != -1 && n12 <= this.users[n15].distance(n14 + nearBallPositions[n10][0], n13 + nearBallPositions[n10][1]))) {
                                    n11 = n10;
                                    n12 = this.users[n15].distance(n14 + nearBallPositions[n10][0], n13 + nearBallPositions[n10][1]);
                                }
                                ++n10;
                            }
                            if (n11 != -1) {
                                blArray2[n11] = true;
                                if (this.users[n15].distance(n14 + nearBallPositions[n11][0], n13 + nearBallPositions[n11][1]) > this.users[n15].distanceAfterMove(n14 + nearBallPositions[n11][0], n13 + nearBallPositions[n11][1], n14 + nearBallPositions[n11][0], n13 + nearBallPositions[n11][1])) {
                                    this.users[n15].moveTo(n14 + nearBallPositions[n11][0], n13 + nearBallPositions[n11][1], true);
                                }
                                blArray[n15] = true;
                            }
                        }
                        ++n15;
                    }
                    n14 = -1;
                    n17 = -1;
                    n13 = 0;
                    while (n13 < 7) {
                        if (this.comps[n13].hasBall) {
                            n17 = n13;
                        }
                        ++n13;
                    }
                    n12 = 0;
                    while (n12 < 7) {
                        blArray[n12] = false;
                        ++n12;
                    }
                    if (n17 != -1) {
                        if (this.comps[n17].x - this.comps[n17].speed / 2 - 1 <= this.destXCurrent && this.destXCurrent <= this.comps[n17].x + this.comps[n17].speed / 2 + 1) {
                            this.destXCurrent = 145 + Math.abs(this.r.nextInt()) % 60;
                        }
                        n11 = this.destXCurrent;
                        n10 = 75;
                        if (this.compSide == 0) {
                            n10 = 475;
                        }
                        if ((n9 = this.comps[n17].steps(GameScreen.ball.x, GameScreen.ball.y, n11, n10)) <= 1) {
                            n8 = this.comps[n17].direction;
                            if (this.compSide == 0 && (n8 > 5 || n8 < 3)) {
                                n8 = 4;
                            }
                            if (this.compSide == 1 && n8 != 7 && n8 != 0 && n8 != 1) {
                                n8 = 0;
                            }
                            ball.kickBall(n8);
                            this.comps[n17].hasBall = false;
                        } else {
                            n8 = -1;
                            n7 = -1;
                            if (stepsDone >= 5) {
                                n6 = 0;
                                while (n6 < 8) {
                                    n5 = GameScreen.ball.x;
                                    n4 = GameScreen.ball.y;
                                    n3 = 0;
                                    n2 = 0;
                                    block15: while (n2 == 0 && n3 < Ball.speeds.length + 5) {
                                        if (n3 < Ball.speeds.length) {
                                            n5 += Ball.speeds[n6][n3][0];
                                            n4 += Ball.speeds[n6][n3][1];
                                        }
                                        ++n3;
                                        int n20 = 0;
                                        while (n20 < 7) {
                                            if (this.comps[n20].steps(this.comps[n20].x, this.comps[n20].y, n5, n4) <= n3) {
                                                n2 = 1;
                                                continue block15;
                                            }
                                            ++n20;
                                        }
                                    }
                                    if (n2 != 0 && (n8 == -1 || n3 + this.comps[0].steps(n5, n4, n11, n10) < n7)) {
                                        n8 = n6;
                                        n7 = n3 + this.comps[0].steps(n5, n4, n11, n10);
                                    }
                                    ++n6;
                                }
                            }
                            if (n7 < n9 && n7 != -1) {
                                ball.kickBall(n8);
                                this.comps[n17].hasBall = false;
                            } else {
                                this.comps[n17].moveTo(n11, n10, true);
                            }
                            blArray[n17] = true;
                        }
                    } else {
                        n11 = -1;
                        n10 = 0;
                        while (n10 < 7) {
                            if (n11 == -1 || n11 > this.comps[n10].distance(GameScreen.ball.x + GameScreen.ball.sW / 2 - this.comps[n10].sW / 2, GameScreen.ball.y + GameScreen.ball.sH / 2 - this.comps[n10].sH / 2)) {
                                n11 = this.comps[n10].distance(GameScreen.ball.x + GameScreen.ball.sW / 2 - this.comps[n10].sW / 2, GameScreen.ball.y + GameScreen.ball.sH / 2 - this.comps[n10].sH / 2);
                            }
                            ++n10;
                        }
                        n9 = 0;
                        while (n9 < 7) {
                            if (n11 * 2 >= this.comps[n9].distance(GameScreen.ball.x + GameScreen.ball.sW / 2 - this.comps[n9].sW / 2, GameScreen.ball.y + GameScreen.ball.sH / 2 - this.comps[n9].sH / 2)) {
                                blArray[n9] = true;
                                if (this.comps[n9].distanceAfterMove(GameScreen.ball.x + GameScreen.ball.sW / 2 - this.comps[n9].sW / 2, GameScreen.ball.y + GameScreen.ball.sH / 2 - this.comps[n9].sH / 2, GameScreen.ball.x + GameScreen.ball.sW / 2 - this.comps[n9].sW / 2, GameScreen.ball.y + GameScreen.ball.sH / 2 - this.comps[n9].sH / 2) < this.comps[n9].distance(GameScreen.ball.x + GameScreen.ball.sW / 2 - this.comps[n9].sW / 2, GameScreen.ball.y + GameScreen.ball.sH / 2 - this.comps[n9].sH / 2)) {
                                    this.comps[n9].moveTo(GameScreen.ball.x + GameScreen.ball.sW / 2 - this.comps[n9].sW / 2, GameScreen.ball.y + GameScreen.ball.sH / 2 - this.comps[n9].sH / 2, false);
                                    n14 = -1;
                                } else {
                                    n14 = n9;
                                }
                            }
                            ++n9;
                        }
                    }
                    n11 = 0;
                    while (n11 < nearBallPositions.length) {
                        blArray2[n11] = false;
                        ++n11;
                    }
                    n10 = 0;
                    while (n10 < 7) {
                        if (!blArray[n10]) {
                            n9 = GameScreen.ball.x + GameScreen.ball.sW / 2;
                            n8 = GameScreen.ball.y + GameScreen.ball.sH / 2;
                            n7 = -1;
                            n6 = -1;
                            n5 = 0;
                            while (n5 < nearBallPositions.length) {
                                if (!(blArray2[n5] || n6 != -1 && n7 <= this.comps[n10].distance(n9 + nearBallPositions[n5][0] * 12 / 10, n8 + nearBallPositions[n5][1] * 12 / 10))) {
                                    n6 = n5;
                                    n7 = this.comps[n10].distance(n9 + nearBallPositions[n5][0] * 12 / 10, n8 + nearBallPositions[n5][1] * 12 / 10);
                                }
                                ++n5;
                            }
                            if (n6 != -1) {
                                blArray2[n6] = true;
                                if (this.comps[n10].distance(n9 + nearBallPositions[n6][0] * 12 / 10, n8 + nearBallPositions[n6][1] * 12 / 10) > this.comps[n10].distanceAfterMove(n9 + nearBallPositions[n6][0] * 12 / 10, n8 + nearBallPositions[n6][1], n9 + nearBallPositions[n6][0] * 12 / 10, n8 + nearBallPositions[n6][1] * 12 / 10)) {
                                    this.comps[n10].moveTo(n9 + nearBallPositions[n6][0] * 12 / 10, n8 + nearBallPositions[n6][1] * 12 / 10, true);
                                }
                                blArray[n10] = true;
                            }
                        }
                        ++n10;
                    }
                    ++stepsDone;
                    n9 = ball.ballMove();
                    n8 = 0;
                    if (Math.abs(GameScreen.ball.y - this.goalKeepers[1].y) < Math.abs(GameScreen.ball.y - this.goalKeepers[0].y)) {
                        n8 = 1;
                    }
                    if (n9 != 0 && GameScreen.ball.x >= 140 && GameScreen.ball.x <= 210) {
                        if (GameScreen.ball.x >= this.goalKeepers[n8].x && GameScreen.ball.x < this.goalKeepers[n8].x + this.goalKeepers[n8].sW) {
                            if (this.goalKeepers[n8].y < 275) {
                                GameScreen.ball.x = this.goalKeepers[n8].x + this.goalKeepers[n8].sW / 2;
                                GameScreen.ball.y = this.goalKeepers[n8].y;
                                ball.kickBall(3 + this.rnd(3), -7);
                            } else {
                                GameScreen.ball.x = this.goalKeepers[n8].x + this.goalKeepers[n8].sW / 2;
                                GameScreen.ball.y = this.goalKeepers[n8].y;
                                n7 = this.rnd(3);
                                if (n7 == 2) {
                                    n7 = 7;
                                }
                                ball.kickBall(n7, -7);
                            }
                        } else {
                            mode = 5;
                            SPlayer.play(2);
                            if (this.goalKeepers[n8].y < 275 && this.compSide == 0 || this.goalKeepers[n8].y > 275 && this.compSide == 1) {
                                ++this.scoreUser;
                                this.kickOffTeam = 1;
                            } else {
                                ++this.scoreComp;
                                this.kickOffTeam = 0;
                            }
                            if (GameScreen.ball.ballSpeed < Ball.speeds[GameScreen.ball.direction].length && 140 <= GameScreen.ball.x + Ball.speeds[GameScreen.ball.direction][GameScreen.ball.ballSpeed][0] && GameScreen.ball.x + GameScreen.ball.sW + Ball.speeds[GameScreen.ball.direction][GameScreen.ball.ballSpeed][0] <= 210 && (GameScreen.ball.y + Ball.speeds[GameScreen.ball.direction][GameScreen.ball.ballSpeed][1] <= 30 || GameScreen.ball.y + Ball.speeds[GameScreen.ball.direction][GameScreen.ball.ballSpeed][1] >= 520)) {
                                GameScreen.ball.x += Ball.speeds[GameScreen.ball.direction][GameScreen.ball.ballSpeed][0];
                                GameScreen.ball.y += Ball.speeds[GameScreen.ball.direction][GameScreen.ball.ballSpeed][1];
                            }
                            this.goalTime = 0;
                        }
                    }
                    if (GameScreen.ball.ballSpeed >= Ball.speeds.length && (GameScreen.ball.y <= 40 || GameScreen.ball.y >= 510) && GameScreen.ball.x >= this.goalKeepers[n8].x && GameScreen.ball.x <= this.goalKeepers[n8].x + this.goalKeepers[n8].sW) {
                        n7 = 0;
                        n6 = 0;
                        while (n6 < 7) {
                            n7 = n7 != 0 || this.users[n6].hasBall || this.comps[n6].hasBall ? 1 : 0;
                            ++n6;
                        }
                        if (n7 == 0) {
                            if (this.goalKeepers[n8].y < 275) {
                                GameScreen.ball.x = this.goalKeepers[n8].x + this.goalKeepers[n8].sW / 2;
                                GameScreen.ball.y = this.goalKeepers[n8].y;
                                ball.kickBall(3 + this.rnd(3), -7);
                            } else {
                                GameScreen.ball.x = this.goalKeepers[n8].x + this.goalKeepers[n8].sW / 2;
                                GameScreen.ball.y = this.goalKeepers[n8].y;
                                n5 = this.rnd(3);
                                if (n5 == 2) {
                                    n5 = 7;
                                }
                                ball.kickBall(n5, -7);
                            }
                        }
                    }
                    n7 = 0;
                    while (n7 < 2) {
                        if (this.goalKeepers[n7].x + this.goalKeepers[n7].sW / 2 < GameScreen.ball.x + GameScreen.ball.sW / 2 && this.goalKeepers[n7].x + this.goalKeepers[n7].sW < 210) {
                            this.goalKeepers[n7].x = this.goalKeepers[n7].x + this.goalKeepers[n7].speed * (GameScreen.ball.ballSpeed < Ball.speeds[0].length && GameScreen.ball.direction % 2 == 1 ? 7 + this.rnd(4) : 2) / 2;
                        }
                        if (this.goalKeepers[n7].x + this.goalKeepers[n7].sW / 2 > GameScreen.ball.x + GameScreen.ball.sW / 2 && this.goalKeepers[n7].x > 140) {
                            this.goalKeepers[n7].x = this.goalKeepers[n7].x - this.goalKeepers[n7].speed * (GameScreen.ball.ballSpeed < Ball.speeds[0].length && GameScreen.ball.direction % 2 == 1 ? 7 + this.rnd(4) : 2) / 2;
                        }
                        ++n7;
                    }
                    n6 = -1;
                    n5 = 0;
                    while (n5 < 7) {
                        if (this.users[n5].hasBall) {
                            n6 = n5;
                        }
                        if (this.comps[n5].hasBall) {
                            n6 = 7 + n5;
                        }
                        ++n5;
                    }
                    n4 = -1;
                    n3 = 0;
                    while (n3 < 7) {
                        if ((n6 >= 7 || n6 == -1) && ball.distance(this.users[n3]) < 50) {
                            n4 = n3;
                        }
                        if ((n6 < 7 || n6 == -1) && ball.distance(this.comps[n3]) < 50) {
                            n4 = 7 + n3;
                        }
                        ++n3;
                    }
                    if (n4 != -1) {
                        n2 = 0;
                        while (n2 < 7) {
                            this.users[n2].hasBall = false;
                            this.comps[n2].hasBall = false;
                            if (n2 == n4) {
                                this.users[n2].setBallOwn();
                            }
                            if (n2 + 7 == n4) {
                                this.comps[n2].setBallOwn();
                            }
                            ++n2;
                        }
                    } else if (n14 != -1) {
                        this.comps[n14].setBallOwn();
                    }
                    if (n6 != -1 && n4 != -1) {
                        if (n4 < 7 && (this.keyKick || this.rnd(10) == 0)) {
                            this.faultTeam = 0;
                            this.fault();
                        } else if (n4 >= 7 && this.rnd(5) == 0) {
                            this.faultTeam = 1;
                            this.fault();
                        }
                    }
                    this.keyKick = false;
                    if (!(mode != 1 || GameScreen.ball.x > 10 && GameScreen.ball.x + GameScreen.ball.sW / 2 < 340 && GameScreen.ball.y > 30 && GameScreen.ball.y + GameScreen.ball.sH / 2 < 520 || GameScreen.ball.x >= 140 && GameScreen.ball.x <= 210)) {
                        this.ballOutside();
                    }
                    if (this.timeToEnd - 2 <= 0 && this.firstTime) {
                        this.timeToEnd = this.roundTime * 10;
                        this.firstTime = false;
                        mode = 13;
                        this.messageTime = 3000;
                        this.messageType = 16;
                    } else if (this.timeToEnd > 0) {
                        this.timeToEnd -= 2;
                    } else if (this.scoreComp == this.scoreUser && this.scoreComp == 0 && !this.additionTime && this.gameType == 1) {
                        this.extraTime = 2 * this.roundTime * 10 / 2;
                        this.timeToEnd += 2 * this.roundTime * 10 / 2;
                        this.additionTime = true;
                    } else {
                        this.messageTime = 6000;
                        if (this.gameType == 0 || this.gameType == 1 && this.round < 3) {
                            if (this.scoreComp > this.scoreUser) {
                                this.messageType = 5;
                            } else if (this.scoreComp == this.scoreUser) {
                                this.messageType = 8;
                            } else if (this.scoreComp < this.scoreUser) {
                                this.messageType = 6;
                            }
                        } else if (this.scoreComp > this.scoreUser) {
                            this.messageType = 5;
                        } else if (this.scoreComp == this.scoreUser) {
                            this.messageType = 8;
                        } else if (this.scoreComp < this.scoreUser) {
                            this.messageType = 7;
                        }
                        mode = 6;
                    }
                }
                this.setCenterPoint(GameScreen.ball.x, GameScreen.ball.y);
                this.repaint();
                if (mode == 4 || mode == 8) {
                    if (this.messageTime > 0) {
                        this.messageTime -= 40;
                    }
                    lastReleased += 4;
                    Thread.sleep(20L);
                } else {
                    if (this.messageTime > 0) {
                        this.messageTime -= 200;
                    }
                    lastReleased += 15;
                    Thread.sleep(150L);
                }
                if (this.nextMessageType == -1 || this.messageTime > 0) continue;
                this.messageType = this.nextMessageType;
                this.messageTime = 3000;
                this.nextMessageType = -1;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    protected void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 1: {
                this.keyDown = false;
                this.keyLeft = false;
                this.keyRight = false;
                this.keyUp = false;
                lastReleased = 0;
                break;
            }
            case 6: {
                this.keyDown = false;
                this.keyLeft = false;
                this.keyRight = false;
                this.keyUp = false;
                lastReleased = 0;
                break;
            }
            case 5: {
                this.keyDown = false;
                this.keyLeft = false;
                this.keyRight = false;
                this.keyUp = false;
                lastReleased = 0;
                break;
            }
            case 2: {
                this.keyDown = false;
                this.keyLeft = false;
                this.keyRight = false;
                this.keyUp = false;
                lastReleased = 0;
                break;
            }
            default: {
                switch (n) {
                    case 49: {
                        this.keyUp = false;
                        this.keyLeft = false;
                        break block0;
                    }
                    case 51: {
                        this.keyUp = false;
                        this.keyRight = false;
                        break block0;
                    }
                    case 57: {
                        this.keyDown = false;
                        this.keyRight = false;
                        break block0;
                    }
                    case 55: {
                        this.keyDown = false;
                        this.keyLeft = false;
                    }
                }
            }
        }
        this.setDirection();
    }

    public static void softKey1Pressed() {
        if (mode == 7) {
            mode = 0;
            GameMidlet.m_display.setCurrent((Displayable)GameMidlet.menuScreen);
        } else if (mode != 0) {
            if (mode != 2) {
                previousMode = mode;
            }
            mode = 7;
        }
    }

    public static void softKey2Pressed() {
        if (mode == 7 || mode == 2) {
            mode = previousMode;
        } else if (mode != 0) {
            previousMode = mode;
            mode = 2;
        }
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n == -6) {
            GameScreen.softKey1Pressed();
        } else if (n == -7) {
            GameScreen.softKey2Pressed();
        }
        block0 : switch (n2) {
            case 1: {
                this.keyUp = true;
                if (lastDirection == 2 && lastReleased < 31) {
                    this.keyRight = true;
                }
                if (lastDirection != 6 || lastReleased >= 31) break;
                this.keyLeft = true;
                break;
            }
            case 6: {
                this.keyDown = true;
                if (lastDirection == 2 && lastReleased < 31) {
                    this.keyRight = true;
                }
                if (lastDirection != 6 || lastReleased >= 31) break;
                this.keyLeft = true;
                break;
            }
            case 5: {
                this.keyRight = true;
                if (lastDirection == 0 && lastReleased < 31) {
                    this.keyUp = true;
                }
                if (lastDirection != 4 || lastReleased >= 31) break;
                this.keyDown = true;
                break;
            }
            case 2: {
                this.keyLeft = true;
                if (lastDirection == 0 && lastReleased < 31) {
                    this.keyUp = true;
                }
                if (lastDirection != 4 || lastReleased >= 31) break;
                this.keyDown = true;
                break;
            }
            case 8: {
                this.keyKick = true;
                break;
            }
            default: {
                switch (n) {
                    case 49: {
                        this.keyUp = true;
                        this.keyLeft = true;
                        break block0;
                    }
                    case 51: {
                        this.keyUp = true;
                        this.keyRight = true;
                        break block0;
                    }
                    case 57: {
                        this.keyDown = true;
                        this.keyRight = true;
                        break block0;
                    }
                    case 55: {
                        this.keyDown = true;
                        this.keyLeft = true;
                    }
                }
            }
        }
        this.setDirection();
        if (direction != -1) {
            lastDirection = direction;
        }
    }

    public void setDirection() {
        direction = this.keyUp ? (this.keyLeft ? 7 : (this.keyRight ? 1 : 0)) : (this.keyDown ? (this.keyLeft ? 5 : (this.keyRight ? 3 : 4)) : (this.keyLeft ? 6 : (this.keyRight ? 2 : -1)));
    }

    public void setCenterPoint(int n, int n2) {
        fieldX = n < screenWidth / 2 ? 0 : (n > 350 - screenWidth / 2 ? 350 - screenWidth : n - screenWidth / 2);
        fieldY = n2 < screenHeight / 2 ? 0 : (n2 > 550 - screenHeight / 2 ? 550 - screenHeight : n2 - screenHeight / 2);
    }

    static {
        nearBallPositions = new int[][]{{-70, -70}, {-70, 70}, {70, -70}, {70, 70}, {0, -150}, {0, 150}, {-150, 0}, {150, 0}, {-70, -200}, {-70, 200}, {70, -200}, {70, 200}};
        compCommand = 0;
        userCommand = 0;
        compCommandColor = 0;
        userCommandColor = 0;
        fieldX = 0;
        fieldY = 0;
        infoHeight = 20;
        direction = -1;
        lastReleased = 1000;
        lastDirection = -1;
        stepsDone = 0;
        nearestPlayerDirection = 0;
        mode = 0;
        previousMode = 0;
    }
}

