/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Air_Gunner
extends MIDlet
implements CommandListener {
    private Display display = Display.getDisplay((MIDlet)this);
    private Form fmMain;
    private Command cmExit;
    private Command cmStart;
    private Command cmBack;
    private AGAnimationCanvas canvas = new AGAnimationCanvas(this);
    private RecordStore AG_rs = null;
    static final String REC_STORE = "AirGunnerUserScores";
    private int[] scoreArray;
    private int[] TheScore;
    private int bestScore;
    private int lastScore;
    private int presentScore;
    private int Turns;
    private Alert alAlert;
    private boolean storeExits = true;
    int gameCounter = 0;

    public Air_Gunner() {
        this.fmMain = new Form("");
        this.cmStart = new Command("Start", 1, 1);
        this.cmExit = new Command("Exit", 7, 1);
        try {
            Image image = Image.createImage((String)"/cover_page.png");
            this.fmMain.append((Item)new ImageItem(null, image, 3, null));
        }
        catch (Exception exception) {
            System.out.println("error with image load: " + exception);
        }
        this.fmMain.append("Using the radar locate and shoot down the enemy spaceships before they destroy you. (Version 1.0) \u00a9 Saranjeet Raj");
        this.fmMain.addCommand(this.cmStart);
        this.fmMain.addCommand(this.cmExit);
        this.fmMain.setCommandListener((CommandListener)this);
        this.scoreArray = new int[3];
        this.TheScore = new int[3];
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.fmMain);
    }

    public void CloseApp() {
        this.display.setCurrent((Displayable)this.fmMain);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmExit) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.cmStart) {
            this.display.setCurrent((Displayable)this.canvas);
            this.canvas.repaint();
            this.openRecStore();
            if (!this.storeExits) {
                int n = 0;
                while (n < 3) {
                    this.TheScore[n] = 1;
                    ++n;
                }
                this.openRecStoreCreate();
                this.writeFirstData(this.TheScore);
                this.closeRecStore();
            } else {
                this.closeRecStore();
            }
            ++this.gameCounter;
            if (this.gameCounter > 1) {
                this.canvas.reStartAG();
            }
        }
    }

    public void displayScore() {
        this.alAlert = new Alert("Score", "Present Score    " + this.Turns + " Last Score         " + this.lastScore + " Best Score         " + this.TheScore[2], null, null);
        this.alAlert.setTimeout(-2);
        this.display.setCurrent(this.alAlert, (Displayable)this.fmMain);
    }

    public void openRecStoreCreate() {
        try {
            this.AG_rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
        }
        catch (Exception exception) {
            this.storeExits = true;
        }
    }

    public void writeFirstData(int[] nArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            boolean bl = true;
            int n = 0;
            while (n < nArray.length) {
                dataOutputStream.writeInt(nArray[n]);
                dataOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.AG_rs.addRecord(byArray, 0, byArray.length);
                byteArrayOutputStream.reset();
                ++n;
            }
            byteArrayOutputStream.close();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(" there is an error in write streams1:  " + exception);
        }
    }

    public void RRScore(int n) {
        this.Turns = n;
    }

    public void RMSScore() {
        this.openRecStore();
        this.readSream();
        this.calculateScore();
        this.writeScores();
        this.closeRecStore();
        this.displayScore();
    }

    public void openRecStore() {
        try {
            this.AG_rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)false);
        }
        catch (Exception exception) {
            this.storeExits = false;
        }
    }

    public void closeRecStore() {
        try {
            this.AG_rs.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println(" there is an error closing  the RMS:  " + exception);
        }
    }

    public void writeScores() {
        this.TheScore[0] = this.Turns;
    }

    public void writeStream(int[] nArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            boolean bl = true;
            int n = 0;
            while (n < nArray.length) {
                dataOutputStream.writeInt(nArray[n]);
                dataOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.AG_rs.setRecord(n + 1, byArray, 0, byArray.length);
                byteArrayOutputStream.reset();
                ++n;
            }
            byteArrayOutputStream.close();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(" there is an error in write streams:  " + exception);
        }
    }

    public void readSream() {
        try {
            byte[] byArray = new byte[50];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = 1;
            while (n <= this.AG_rs.getNumRecords()) {
                this.AG_rs.getRecord(n, byArray, 0);
                this.scoreArray[n - 1] = dataInputStream.readInt();
                byteArrayInputStream.reset();
                ++n;
            }
            this.presentScore = this.scoreArray[0];
            this.lastScore = this.scoreArray[1];
            this.bestScore = this.scoreArray[2];
            byteArrayInputStream.close();
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(" there is an error in read streams:  " + exception);
        }
    }

    public void calculateScore() {
        this.presentScore = this.Turns;
        this.TheScore[0] = this.Turns;
        this.TheScore[1] = this.Turns;
        this.TheScore[2] = this.Turns > this.bestScore ? this.Turns : this.bestScore;
        this.writeStream(this.TheScore);
    }
}

