/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class GameCanvas
extends Canvas {
    static final int KEY_UP = -1;
    static final int KEY_DOWN = -2;
    static final int KEY_LEFT = -3;
    static final int KEY_RIGHT = -4;
    static final int KEY_FIRE = -5;
    static final int KEY_COMR = -5;
    static final int KEY_COML = 32;
    static final int KEY_NUM0 = 48;
    static final int KEY_NUM1 = 49;
    static final int KEY_NUM2 = 50;
    static final int KEY_NUM3 = 51;
    static final int KEY_NUM4 = 52;
    static final int KEY_NUM5 = 53;
    static final int KEY_NUM6 = 54;
    static final int KEY_NUM7 = 55;
    static final int KEY_NUM8 = 56;
    static final int KEY_NUM9 = 57;
    static final int KEY_STAR = 42;
    static final int KEY_POUND = 35;
    static final int KEY_VOL_UP = -13;
    static final int KEY_VOL_DOWN = -14;
    static final int INIT = 0;
    static final int MENU = 1;
    static final int OPTION = 2;
    static final int VIEW_TEAMINFO = 3;
    static final int VIEW_CREDIT = 4;
    static final int PLAYING = 5;
    static final int GAME_END = 6;
    static final int PLAYER = 0;
    static final int COMPUTER = 1;
    static final int PITCHER_READY = 0;
    static final int PITCHING = 1;
    static final int PITCH_BALL = 2;
    static final int DEFENSE = 3;
    static final int VIEW_INFO = 4;
    static final int VIEW_DISPLAY = 5;
    static final int OPENING = 6;
    static final int CHANGE_PLAYER = 9;
    static final int STEAL = 10;
    static final int CALL_TIME = 11;
    static final int ATTACK_SCREEN = 0;
    static final int DEFENSE_SCREEN = 1;
    static boolean helpImgOn = false;
    static final int MENU_REF_X = 28;
    static final int MENU_REF_Y = 40;
    static int FONT_HEIGHT = -1;
    static int NOKIA_VERSION = 7650;
    static final int ITEM_HEIGHT = 19;
    public static boolean backLight = false;
    public static boolean vibration = false;
    public static boolean isSoundOn = false;
    public static boolean keyEnable = true;
    public static boolean isSave;
    static int menuIndex;
    public static int state;
    private static final int CNT_MENUITEM = 4;
    private static final int CNT_OPTIONITEM = 3;
    public static Image title;
    public static Image logo;
    public static Image backImg;
    public static Image pitcherImg;
    public static Image batterImg;
    public static Image batImg;
    public static Image plateLR;
    public static Image plateC;
    public static Image runnerImg;
    public static Image ballImg;
    public static Image fenceImg;
    public static Image fenceCImg;
    public static Image number1Img;
    public static Image groundImg;
    public static Image runStatImg;
    public static Image displayImg;
    public static Image decisionImg;
    public static Image resultImg;
    public static Image iconsImg;
    public static Image teamnameImg;
    public static Image addedImgA;
    public static Image addedImgD;
    public static Image scoreboardImg;
    public static Image leftBatImg;
    public static Image stuff_fastballImg;
    public static Image stuff_curveballImg;
    public static Image stuff_forkballImg;
    public static Image stuff_sliderImg;
    public static Image stuff_sinkerImg;
    public static Image inn_topImg;
    public static Image inn_bottomImg;
    public static Image inn_stImg;
    public static Image inn_ndImg;
    public static Image inn_rdImg;
    public static Image inn_thImg;
    public static Image menu_bgImg;
    public static Image menuImg;
    public static Image menu_selImg;
    public static Image optionOffImg;
    public static Image optionOff_selImg;
    public static Image optionOnImg;
    public static Image optionOn_selImg;
    Image offImage;
    Image offImage2;
    Image fullImage;
    Graphics offScreen;
    Graphics offScreen2;
    Graphics fullGraphics;
    public Font font;
    public static Random ran;
    public static GeneralThread generalThread;
    public static RecordStore rs;
    public static StringBuffer strBuffer;
    public byte[] rsData;
    public static int curScreen;
    public static int attacker;
    public static int playState;
    public static int pitcherPosX;
    public static int pitcherPosY;
    public static int batterPosX;
    public static int batterPosY;
    public static int currentBatterType;
    public static int preBatterType;
    public static int curBatterNb;
    public static int curComBatterNb;
    public static int curPitcherNb;
    public static int curComPitcherNb;
    public static int pitcherType;
    public static int changeBatter;
    public static int changePitcher;
    public static int changeComPitcher;
    public static int changeNb;
    public static int changeIndex;
    public static int[] changeItem;
    public static int oldBatterNb;
    public static int[] pitchingNb;
    public static int curInning;
    public static int curPressKey;
    public static int prePressKey;
    public static int stealRunner;
    public static int runnerInfo;
    public static int[] gameScore;
    public static int[] hitScore;
    public static int[][] inningScore;
    public static final int ref_x = 10;
    public static int teamVictory;
    public static int teamDefeat;
    public static String pitcherName;
    public static int[] pitcherInfo;
    public static String batterName;
    public static int[] batterInfo;
    public static int ballCount;
    public static int strikeCount;
    public static int outCount;
    public static final int S_BOUND_SWING = 0;
    public static final int S_FLY_SWING = 1;
    public static final int L_FLY_SWING = 2;
    public static final int HIT1_SWING = 3;
    public static final int HIT2_SWING = 4;
    public static final int HOMERUN_SWING = 5;
    public static final String PITCHER_NAME = "JOHNKURTJACK";
    public static final int[] PITCHER_INFO;
    public static final String BATTER_NAME = "GEROJIAMSOSABONSJONSTODDLUISSHWNIVAN";
    public static final int[] BATTER_INFO;
    public static final int[] DEFENSE_POS;
    public static int[][] defensePos;
    public static final int[] BALL_IMAGE_INFO;
    public static final int[][][] PITCH_BALL_INFO;
    public static final int[] SHADOW_BALL_INFO;
    public static final int[][][] HIT_BALL_INFO1;
    public static final int[] HIT_BALL_INFO2;
    public static final int[][] RUNNER_POS;
    private static int endAniCount;
    static int LCD_WIDTH;
    static int LCD_HEIGHT;
    static int WIDTH;
    static int HEIGHT;
    static int correctionX;
    static int correctionY;

    public void paint(Graphics graphics) {
        if (state == 5) {
            if (playState == 3 || playState == 5 || playState == 6) {
                graphics.drawImage(addedImgD, 0, 0, 20);
                Drawer.drawImage(this.fullGraphics, 0, 0, addedImgD);
                if (playState == 5) {
                    this.drawDisplay2();
                }
            } else {
                Drawer.drawImage(this.fullGraphics, 0, 0, addedImgA);
                if (currentBatterType == 1) {
                    Drawer.drawClipImage(this.offScreen, batImg, 34, 89, 28, 13, 0, 0);
                    Drawer.drawClipImage(this.fullGraphics, batImg, 34 + correctionX, 89 + correctionY, 28, 13, 0, 0);
                }
                if (currentBatterType == 2) {
                    Drawer.drawImage(this.fullGraphics, 5, 84, leftBatImg);
                }
            }
        } else if (state == 6) {
            graphics.drawImage(addedImgD, 0, 0, 20);
            Drawer.drawImage(this.fullGraphics, 0, 0, addedImgD);
            this.drawDisplay2();
        }
        if (helpImgOn) {
            this.drawHelpImg2();
        }
        if (state == 5) {
            Drawer.drawImage(this.fullGraphics, correctionX, correctionY, this.offImage);
        }
        Drawer.drawImage(graphics, 0, 0, this.fullImage);
    }

    public void showNotify() {
        generalThread.start();
        this.show();
    }

    public GameCanvas() {
        LCD_WIDTH = this.getWidth();
        LCD_HEIGHT = this.getHeight();
        WIDTH = 120;
        HEIGHT = 112;
        correctionX = (LCD_WIDTH - WIDTH) / 2;
        correctionY = (LCD_HEIGHT - HEIGHT) / 2;
        pitcherPosX = 33;
        pitcherPosY = 23;
        batterPosX = 0;
        batterPosY = 50;
        if (this.offScreen == null) {
            this.offImage = Image.createImage((int)120, (int)112);
            this.offScreen = this.offImage.getGraphics();
            this.offImage2 = Image.createImage((int)120, (int)112);
            this.offScreen2 = this.offImage2.getGraphics();
            if (NOKIA_VERSION == 7650) {
                this.fullImage = Image.createImage((int)LCD_WIDTH, (int)LCD_HEIGHT);
                this.fullGraphics = this.fullImage.getGraphics();
            }
            this.font = this.offScreen.getFont();
            FONT_HEIGHT = this.font.getHeight();
            ran = new Random();
        }
        try {
            groundImg = Image.createImage((String)"/ground.png");
            System.out.println("Loaded [ground.png]");
            title = Image.createImage((String)"/TITLE_3_0_0.png");
            System.out.println("Loaded [TITLE_3_0_0.png]");
            batterImg = Image.createImage((String)"/batter.png");
            System.out.println("Loaded [batter.png]");
            backImg = Image.createImage((String)"/back.png");
            System.out.println("Loaded [back.png]");
            ballImg = Image.createImage((String)"/ball.png");
            System.out.println("Loaded [ball.png]");
            number1Img = Image.createImage((String)"/number1.png");
            System.out.println("Loaded [number1.png]");
            decisionImg = Image.createImage((String)"/decision.png");
            System.out.println("Loaded [decision.png]");
            displayImg = Image.createImage((String)"/display.png");
            System.out.println("Loaded [display.png]");
            batImg = Image.createImage((String)"/bat.png");
            System.out.println("Loaded [bat.png]");
            plateLR = Image.createImage((String)"/plate_lr.png");
            System.out.println("Loaded [plate_lr.png]");
            plateC = Image.createImage((String)"/plate_c.png");
            System.out.println("Loaded [plate_c.png]");
            iconsImg = Image.createImage((String)"/icons.png");
            System.out.println("Loaded [icons.png]");
            runStatImg = Image.createImage((String)"/run_stat.png");
            System.out.println("Loaded [run_stat.png]");
            pitcherImg = Image.createImage((String)"/pitcher.png");
            System.out.println("Loaded [pitcher.png]");
            resultImg = Image.createImage((String)"/result.png");
            System.out.println("Loaded [result.png]");
            logo = Image.createImage((String)"/logo.png");
            System.out.println("Loaded [logo.png]");
            fenceCImg = Image.createImage((String)"/fence_c.png");
            System.out.println("Loaded [fence_c.png]");
            teamnameImg = Image.createImage((String)"/teamname.png");
            System.out.println("Loaded [teamname.png]");
            fenceImg = Image.createImage((String)"/fence.png");
            System.out.println("Loaded [fence.png]");
            runnerImg = Image.createImage((String)"/runner.png");
            System.out.println("Loaded [runner.png]");
            addedImgA = Image.createImage((String)"/ADDED_ATTACK.png");
            System.out.println("Loaded [ADDED_ATTACK.png]");
            addedImgD = Image.createImage((String)"/ADDED_DEFENSE.png");
            System.out.println("Loaded [ADDED_DEFENSE.png]");
            scoreboardImg = Image.createImage((String)"/SCOREBOARD.png");
            System.out.println("Loaded [SCOREBOARD.png]");
            leftBatImg = Image.createImage((String)"/LEFTBAT.png");
            System.out.println("Loaded [LEFTBAT.png]");
            stuff_fastballImg = Image.createImage((String)"/STUFF_FASTBALL.png");
            System.out.println("Loaded [STUFF_FASTBALL.png]");
            stuff_curveballImg = Image.createImage((String)"/STUFF_CURVEBALL.png");
            System.out.println("Loaded [STUFF_CURVEBALL.png]");
            stuff_forkballImg = Image.createImage((String)"/STUFF_FORKBALL.png");
            System.out.println("Loaded [STUFF_FORKBALL.png]");
            stuff_sliderImg = Image.createImage((String)"/STUFF_SLIDER.png");
            System.out.println("Loaded [STUFF_SLIDER.png]");
            stuff_sinkerImg = Image.createImage((String)"/STUFF_SINKER.png");
            System.out.println("Loaded [STUFF_SINKER.png]");
            inn_topImg = Image.createImage((String)"/INN_TOP.png");
            System.out.println("Loaded [INN_TOP.png]");
            inn_bottomImg = Image.createImage((String)"/INN_BOTTOM.png");
            System.out.println("Loaded [INN_BOTTOM.png]");
            inn_stImg = Image.createImage((String)"/INN_ST.png");
            System.out.println("Loaded [INN_ST.png]");
            inn_ndImg = Image.createImage((String)"/INN_ND.png");
            System.out.println("Loaded [INN_ND.png]");
            inn_rdImg = Image.createImage((String)"/INN_RD.png");
            System.out.println("Loaded [INN_RD.png]");
            inn_thImg = Image.createImage((String)"/INN_TH.png");
            System.out.println("Loaded [INN_TH.png]");
            menu_bgImg = Image.createImage((String)"/MENU_BG.png");
            System.out.println("Loaded [MENU_BG.png]");
            menuImg = Image.createImage((String)"/MENU.png");
            System.out.println("Loaded [MENU.png]");
            menu_selImg = Image.createImage((String)"/MENU_SEL.png");
            System.out.println("Loaded [MENU_SEL.png]");
            optionOffImg = Image.createImage((String)"/OPTION_OFF.png");
            System.out.println("Loaded [OPTION_OFF.png]");
            optionOff_selImg = Image.createImage((String)"/OPTION_OFF_SEL.png");
            System.out.println("Loaded [OPTION_OFF_SEL.png]");
            optionOnImg = Image.createImage((String)"/OPTION_ON.png");
            System.out.println("Loaded [OPTION_ON.png]");
            optionOn_selImg = Image.createImage((String)"/OPTION_ON_SEL.png");
            System.out.println("Loaded [OPTION_ON_SEL.png]");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String[] stringArray = RecordStore.listRecordStores();
            int n = 0;
            while (n < stringArray.length) {
                System.out.println(n + stringArray[n]);
                RecordStore.deleteRecordStore((String)stringArray[n]);
                ++n;
            }
            rs = RecordStore.openRecordStore((String)"gameinfo", (boolean)true);
            if (rs.getNumRecords() == 0) {
                this.rsData = new byte[3];
                rs.addRecord(this.rsData, 0, 3);
                this.rsData = new byte[22];
                rs.addRecord(this.rsData, 0, 22);
                this.rsData = new byte[19];
                rs.addRecord(this.rsData, 0, 19);
                this.rsData = new byte[2];
                rs.addRecord(this.rsData, 0, 2);
            }
            this.rsData = rs.getRecord(1);
            isSave = this.rsData[0] == 1;
            teamVictory = this.rsData[1];
            teamDefeat = this.rsData[2];
        }
        catch (Exception exception) {
            // empty catch block
        }
        generalThread = new GeneralThread();
        generalThread.setPriority(10);
    }

    public void initialize() {
        curInning = 0;
        pitcherPosX = 33;
        attacker = 1;
        int n = 0;
        while (n < inningScore.length) {
            GameCanvas.inningScore[n][1] = 0;
            GameCanvas.inningScore[n][0] = 0;
            ++n;
        }
        GameCanvas.hitScore[1] = 0;
        GameCanvas.hitScore[0] = 0;
        GameCanvas.gameScore[1] = 0;
        GameCanvas.gameScore[0] = 0;
        curPitcherNb = 0;
        curComPitcherNb = 0;
        curBatterNb = 0;
        curComBatterNb = 0;
        changePitcher = 0;
        changeBatter = 0;
        changeComPitcher = 1;
        oldBatterNb = -1;
    }

    public void show() {
        switch (state) {
            case 0: {
                if (NOKIA_VERSION == 7650) {
                    Drawer.clearScreen(this.fullGraphics);
                    Drawer.drawImage(this.fullGraphics, 0, 0, title);
                    break;
                }
                Drawer.clearScreen(this.offScreen);
                this.drawFence();
                Drawer.drawImage(this.offScreen, 16, 14, title);
                Drawer.drawClipImage(this.offScreen, pitcherImg, 8, 62, 103, 26, 5, 0);
                Drawer.drawImage(this.offScreen, 17, 92, logo);
                break;
            }
            case 1: 
            case 2: {
                if (NOKIA_VERSION == 7650) {
                    this.drawFrame3();
                    menuIndex = 0;
                    this.drawMenuItem3(menuIndex);
                    this.repaint();
                    break;
                }
                this.drawFrame();
                menuIndex = 0;
                this.drawMenuItem(menuIndex);
                this.repaint();
            }
        }
    }

    public void setState(int n) {
        state = n;
    }

    private void drawFrame() {
    }

    private void drawFrame2() {
    }

    private void drawFrame3() {
        if (state == 1) {
            Drawer.drawImage(this.fullGraphics, 0, 0, menuImg);
        } else if (state == 2) {
            Drawer.drawImage(this.fullGraphics, 0, 0, optionOffImg);
        }
    }

    private void drawMenuItem(int n) {
    }

    private void drawMenuItem2(int n) {
    }

    private void drawMenuItem3(int n) {
        if (state == 1) {
            Drawer.drawImage(this.fullGraphics, 0, 0, menuImg);
            if (n == 0) {
                Drawer.drawClipImage(this.fullGraphics, menu_selImg, 9, 31, 160, 17, 9, 31);
            } else if (n == 1) {
                Drawer.drawClipImage(this.fullGraphics, menu_selImg, 9, 52, 160, 17, 9, 52);
            } else if (n == 2) {
                Drawer.drawClipImage(this.fullGraphics, menu_selImg, 9, 73, 160, 17, 9, 73);
            } else if (n == 3) {
                Drawer.drawClipImage(this.fullGraphics, menu_selImg, 9, 94, 160, 17, 9, 94);
            }
        } else if (state == 2) {
            Drawer.drawImage(this.fullGraphics, 0, 0, optionOffImg);
            if (isSoundOn) {
                Drawer.drawClipImage(this.fullGraphics, optionOnImg, 9, 45, 160, 17, 9, 45);
            }
            if (vibration) {
                Drawer.drawClipImage(this.fullGraphics, optionOnImg, 9, 66, 160, 17, 9, 66);
            }
            if (n == 0) {
                Drawer.drawClipImage(this.fullGraphics, isSoundOn ? optionOn_selImg : optionOff_selImg, 9, 45, 160, 17, 9, 45);
            } else if (n == 1) {
                Drawer.drawClipImage(this.fullGraphics, vibration ? optionOn_selImg : optionOff_selImg, 9, 66, 160, 17, 9, 66);
            } else if (n == 2) {
                Drawer.drawClipImage(this.fullGraphics, optionOn_selImg, 9, 87, 160, 17, 9, 87);
            }
        }
    }

    private void drawTeamInfo() {
        this.drawFence();
        Drawer.drawString(this.offScreen, "TEAMINFO", 18, 16);
        strBuffer.setLength(0);
        strBuffer.append("WL : ").append(teamVictory).append("W ").append(teamDefeat).append("L");
        Drawer.drawString(this.offScreen, strBuffer.toString(), 60 - this.font.stringWidth(strBuffer.toString()) / 2, 37);
        Drawer.drawFillRect(this.offScreen, 5, 52, 110, 2, -5);
        Drawer.drawString(this.offScreen, "AVG : .310", 12, 60);
        Drawer.drawString(this.offScreen, "ERA : 3.54", 12, 76);
    }

    private void drawTeamInfo2() {
    }

    private void drawTeamInfo3() {
        Drawer.drawImage(this.fullGraphics, 0, 0, menu_bgImg);
        Font font = this.fullGraphics.getFont();
        int n = this.fullGraphics.getColor();
        this.fullGraphics.setColor(0xFFFFFF);
        this.fullGraphics.setFont(Font.getFont((int)64, (int)1, (int)0));
        Drawer.drawString(this.fullGraphics, "- TEAM INFO -", 13 + correctionX, 14 + correctionY);
        Drawer.drawString(this.fullGraphics, "Wins  : " + teamVictory, 17 + correctionX, 40 + correctionY);
        Drawer.drawString(this.fullGraphics, "Loses : " + teamVictory, 17 + correctionX, 56 + correctionY);
        Drawer.drawString(this.fullGraphics, "Avg   : .310", 17 + correctionX, 72 + correctionY);
        Drawer.drawString(this.fullGraphics, "ERA   : 3.54", 17 + correctionX, 88 + correctionY);
        this.fullGraphics.setColor(n);
        this.fullGraphics.setFont(font);
    }

    private void drawCredit() {
        Drawer.drawImage(this.fullGraphics, 0, 0, menu_bgImg);
        Font font = this.fullGraphics.getFont();
        int n = this.fullGraphics.getColor();
        this.fullGraphics.setColor(0xFFFFFF);
        this.fullGraphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        Drawer.drawString(this.fullGraphics, "GameVIL . Inc", LCD_WIDTH / 2, 48, 1);
        this.fullGraphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        Drawer.drawString(this.fullGraphics, "All rights reserved", LCD_WIDTH / 2, 73, 1);
        this.fullGraphics.setFont(Font.getFont((int)0, (int)5, (int)8));
        Drawer.drawString(this.fullGraphics, "http://mobile.gamevil.com/", LCD_WIDTH / 2, 98, 1);
        this.fullGraphics.setColor(n);
        this.fullGraphics.setFont(font);
    }

    public void save1() {
        byte[] byArray = new byte[22];
        try {
            int n = 0;
            while (n < 9) {
                byArray[n * 2 + 0] = (byte)inningScore[n][0];
                byArray[n * 2 + 1] = (byte)inningScore[n][1];
                ++n;
            }
            byArray[19] = (byte)gameScore[1];
            byArray[18] = (byte)gameScore[0];
            byArray[21] = (byte)hitScore[1];
            byArray[20] = (byte)hitScore[0];
            rs.setRecord(2, byArray, 0, 22);
            byArray[0] = (byte)curInning;
            byArray[1] = (byte)attacker;
            byArray[2] = (byte)runnerInfo;
            byArray[3] = (byte)outCount;
            byArray[4] = (byte)curPitcherNb;
            byArray[5] = (byte)curComPitcherNb;
            byArray[6] = (byte)curBatterNb;
            byArray[7] = (byte)curComBatterNb;
            byArray[8] = (byte)pitcherType;
            byArray[9] = (byte)(changeBatter & 0x7F);
            byArray[10] = (byte)(changeBatter >> 7 & 0x7F);
            byArray[11] = (byte)(changeBatter >> 14 & 0x7F);
            byArray[12] = (byte)(changePitcher & 0x7F);
            byArray[13] = (byte)(changePitcher >> 7 & 0x7F);
            byArray[14] = (byte)(changePitcher >> 14 & 0x7F);
            byArray[15] = (byte)changeComPitcher;
            byArray[16] = (byte)pitchingNb[0];
            byArray[17] = (byte)pitchingNb[1];
            byArray[18] = (byte)oldBatterNb;
            rs.setRecord(3, byArray, 0, 19);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.save3();
    }

    public void save3() {
        try {
            rs.setRecord(4, new byte[]{(byte)strikeCount, (byte)ballCount}, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        try {
            this.rsData = rs.getRecord(3);
            curInning = this.rsData[0];
            attacker = this.rsData[1];
            runnerInfo = this.rsData[2];
            outCount = this.rsData[3];
            curPitcherNb = this.rsData[4];
            curComPitcherNb = this.rsData[5];
            curBatterNb = this.rsData[6];
            curComBatterNb = this.rsData[7];
            pitcherType = this.rsData[8];
            changeComPitcher = 0;
            changePitcher = 0;
            changeBatter = 0;
            int n = 0;
            while (n < 3) {
                changeBatter |= this.rsData[9 + n] << n * 7;
                changePitcher |= this.rsData[12 + n] << n * 7;
                ++n;
            }
            changeComPitcher = this.rsData[15];
            GameCanvas.pitchingNb[0] = this.rsData[16];
            GameCanvas.pitchingNb[1] = this.rsData[17];
            oldBatterNb = this.rsData[18];
            this.rsData = rs.getRecord(2);
            int n2 = 0;
            while (n2 < 9) {
                GameCanvas.inningScore[n2][0] = this.rsData[n2 * 2 + 0];
                GameCanvas.inningScore[n2][1] = this.rsData[n2 * 2 + 1];
                ++n2;
            }
            GameCanvas.gameScore[1] = this.rsData[19];
            GameCanvas.gameScore[0] = this.rsData[18];
            GameCanvas.hitScore[1] = this.rsData[21];
            GameCanvas.hitScore[0] = this.rsData[20];
            this.rsData = rs.getRecord(4);
            strikeCount = this.rsData[0];
            ballCount = this.rsData[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawRoundBox(int n, int n2, int n3, int n4) {
        Drawer.drawRect(this.offScreen, n + 2, n2 + 2, n3 - 4, n4 - 4, -3);
        Drawer.drawRect(this.offScreen, n + 1, n2 + 1, n3 - 2, n4 - 2, -5);
        Drawer.drawLine(this.offScreen, n + 2, n2 + 2, n + 2, n2 + 2, -5);
        Drawer.drawLine(this.offScreen, n + n3 - 3, n2 + 2, n + n3 - 3, n2 + 2, -5);
        Drawer.drawLine(this.offScreen, n + 2, n2 + n4 - 3, n + 2, n2 + n4 - 3, -5);
        Drawer.drawLine(this.offScreen, n + n3 - 3, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3, -5);
        Drawer.drawLine(this.offScreen, n + 2, n2 + 0, n + n3 - 3, n2 + 0, -4);
        Drawer.drawLine(this.offScreen, n + 0, n2 + 2, n + 0, n2 + n4 - 3, -4);
        Drawer.drawLine(this.offScreen, n + 2, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1, -4);
        Drawer.drawLine(this.offScreen, n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 3, -4);
        Drawer.drawLine(this.offScreen, n + 1, n2 + 1, n + 1, n2 + 1, -4);
        Drawer.drawLine(this.offScreen, n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1, -4);
        Drawer.drawLine(this.offScreen, n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2, -4);
        Drawer.drawLine(this.offScreen, n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2, -4);
        Drawer.drawFillRect(this.offScreen, n + 3, n2 + 3, n3 - 6, n4 - 6, -2);
    }

    private void drawRoundBox2(int n, int n2, int n3, int n4) {
        Drawer.drawRect(this.offScreen, n + 2, n2 + 2, n3 - 4, n4 - 4, -3);
        Drawer.drawRect(this.offScreen, n + 1, n2 + 1, n3 - 2, n4 - 2, -5);
        Drawer.drawLine(this.offScreen, n + 2, n2 + 2, n + 2, n2 + 2, -5);
        Drawer.drawLine(this.offScreen, n + n3 - 3, n2 + 2, n + n3 - 3, n2 + 2, -5);
        Drawer.drawLine(this.offScreen, n + 2, n2 + n4 - 3, n + 2, n2 + n4 - 3, -5);
        Drawer.drawLine(this.offScreen, n + n3 - 3, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3, -5);
        Drawer.drawLine(this.offScreen, n + 2, n2 + 0, n + n3 - 3, n2 + 0, -4);
        Drawer.drawLine(this.offScreen, n + 0, n2 + 2, n + 0, n2 + n4 - 3, -4);
        Drawer.drawLine(this.offScreen, n + 2, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1, -4);
        Drawer.drawLine(this.offScreen, n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 3, -4);
        Drawer.drawLine(this.offScreen, n + 1, n2 + 1, n + 1, n2 + 1, -4);
        Drawer.drawLine(this.offScreen, n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1, -4);
        Drawer.drawLine(this.offScreen, n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2, -4);
        Drawer.drawLine(this.offScreen, n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2, -4);
        Drawer.drawFillRect(this.offScreen, n + 3, n2 + 3, n3 - 6, n4 - 6, -2);
        Drawer.drawRect(this.fullGraphics, n + 2 + correctionX, n2 + 2 + correctionY, n3 - 4, n4 - 4, -3);
        Drawer.drawRect(this.fullGraphics, n + 1 + correctionX, n2 + 1 + correctionY, n3 - 2, n4 - 2, -5);
        Drawer.drawLine(this.fullGraphics, n + 2 + correctionX, n2 + 2 + correctionY, n + 2 + correctionX, n2 + 2 + correctionY, -5);
        Drawer.drawLine(this.fullGraphics, n + n3 - 3 + correctionX, n2 + 2 + correctionY, n + n3 - 3 + correctionX, n2 + 2 + correctionY, -5);
        Drawer.drawLine(this.fullGraphics, n + 2 + correctionX, n2 + n4 - 3 + correctionY, n + 2 + correctionX, n2 + n4 - 3 + correctionY, -5);
        Drawer.drawLine(this.fullGraphics, n + n3 - 3 + correctionX, n2 + n4 - 3 + correctionY, n + n3 - 3 + correctionX, n2 + n4 - 3 + correctionY, -5);
        Drawer.drawLine(this.fullGraphics, n + 2 + correctionX, n2 + 0 + correctionY, n + n3 - 3 + correctionX, n2 + 0 + correctionY, -4);
        Drawer.drawLine(this.fullGraphics, n + 0 + correctionX, n2 + 2 + correctionY, n + 0 + correctionX, n2 + n4 - 3 + correctionY, -4);
        Drawer.drawLine(this.fullGraphics, n + 2 + correctionX, n2 + n4 - 1 + correctionY, n + n3 - 3 + correctionX, n2 + n4 - 1 + correctionY, -4);
        Drawer.drawLine(this.fullGraphics, n + n3 - 1 + correctionX, n2 + 2 + correctionY, n + n3 - 1 + correctionX, n2 + n4 - 3 + correctionY, -4);
        Drawer.drawLine(this.fullGraphics, n + 1 + correctionX, n2 + 1 + correctionY, n + 1 + correctionX, n2 + 1 + correctionY, -4);
        Drawer.drawLine(this.fullGraphics, n + n3 - 2 + correctionX, n2 + 1 + correctionY, n + n3 - 2 + correctionX, n2 + 1 + correctionY, -4);
        Drawer.drawLine(this.fullGraphics, n + 1 + correctionX, n2 + n4 - 2 + correctionY, n + 1 + correctionX, n2 + n4 - 2 + correctionY, -4);
        Drawer.drawLine(this.fullGraphics, n + n3 - 2 + correctionX, n2 + n4 - 2 + correctionY, n + n3 - 2 + correctionX, n2 + n4 - 2 + correctionY, -4);
        Drawer.drawFillRect(this.fullGraphics, n + 3 + correctionX, n2 + 3 + correctionY, n3 - 6, n4 - 6, -2);
    }

    public void playStart() {
        this.drawAttackScreen2();
        this.drawBatter(0);
        this.drawPlayerInfo();
        this.repaint();
        playState = 4;
    }

    public void gameEnd() {
        keyEnable = false;
        this.setState(6);
        if (NOKIA_VERSION == 7650) {
            this.drawDisplay2();
        } else {
            this.drawDisplay();
        }
        if (gameScore[0] > gameScore[1] || gameScore[0] == gameScore[1] && hitScore[0] > hitScore[1]) {
            Drawer.drawClipImage(this.offScreen, resultImg, 24, 17, 72, 16, 0, 0);
            ++teamVictory;
        } else {
            Drawer.drawClipImage(this.offScreen, resultImg, 31, 18, 57, 14, 0, 16);
            ++teamDefeat;
        }
        try {
            rs.setRecord(1, new byte[]{0, (byte)teamVictory, (byte)teamDefeat}, 0, 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pause(800);
        keyEnable = true;
    }

    public void drawStrike() {
        int n = 0;
        while (n < 2) {
            if (strikeCount > n) {
                Drawer.drawClipImage(this.offScreen, iconsImg, 94 + 7 * n, 85, 5, 5, 47, 0);
            } else {
                Drawer.drawClipImage(this.offScreen, iconsImg, 94 + 7 * n, 85, 5, 5, 52, 0);
            }
            ++n;
        }
    }

    public void drawBall() {
        int n = 0;
        while (n < 3) {
            if (ballCount > n) {
                Drawer.drawClipImage(this.offScreen, iconsImg, 94 + 7 * n, 92, 5, 5, 47, 0);
            } else {
                Drawer.drawClipImage(this.offScreen, iconsImg, 94 + 7 * n, 92, 5, 5, 52, 0);
            }
            ++n;
        }
    }

    public void drawOut() {
        int n = 0;
        while (n < 2) {
            if (outCount > n) {
                Drawer.drawClipImage(this.offScreen, iconsImg, 94 + 7 * n, 99, 5, 5, 47, 0);
            } else {
                Drawer.drawClipImage(this.offScreen, iconsImg, 94 + 7 * n, 99, 5, 5, 52, 0);
            }
            ++n;
        }
    }

    public void drawAttackScreen() {
        if (curScreen != 0) {
            Drawer.drawFillRect(this.offScreen2, 0, 0, 120, 90, Drawer.rgbPixel(146, 219, 171));
            Drawer.drawImage(this.offScreen2, 0, 0, backImg);
            Drawer.drawLine(this.offScreen2, 46, 31, 0, 39, -2);
            Drawer.drawLine(this.offScreen2, 46, 32, 0, 40, -2);
            Drawer.drawLine(this.offScreen2, 46, 33, 0, 41, -2);
            Drawer.drawLine(this.offScreen2, 47, 31, 119, 43, -2);
            Drawer.drawLine(this.offScreen2, 47, 32, 119, 44, -2);
            Drawer.drawLine(this.offScreen2, 47, 33, 119, 45, -2);
            int n = 0;
            while (n < 2) {
                Drawer.drawLine(this.offScreen2, 39, 44 + 7 * n, 55, 44 + 7 * n, Drawer.rgbPixel(0, 182, 171));
                Drawer.drawLine(this.offScreen2, 33, 45 + 5 * n, 62, 45 + 5 * n, Drawer.rgbPixel(0, 182, 171));
                Drawer.drawLine(this.offScreen2, 30, 46 + 3 * n, 64, 46 + 3 * n, Drawer.rgbPixel(0, 182, 171));
                Drawer.drawLine(this.offScreen2, 29, 47 + n, 65, 47 + n, Drawer.rgbPixel(0, 182, 171));
                ++n;
            }
            Drawer.drawLine(this.offScreen2, 24, 83, 70, 83, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawLine(this.offScreen2, 7, 84, 88, 84, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawLine(this.offScreen2, 0, 85, 99, 85, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawLine(this.offScreen2, 24, 84, 70, 84, Drawer.rgbPixel(219, 146, 0));
            Drawer.drawLine(this.offScreen2, 7, 85, 88, 85, Drawer.rgbPixel(219, 146, 0));
            Drawer.drawRect(this.offScreen2, 0, 86, 120, 26, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawLine(this.offScreen2, 0, 86, 99, 86, Drawer.rgbPixel(219, 146, 0));
            Drawer.drawFillRect(this.offScreen2, 1, 87, 118, 24, Drawer.rgbPixel(219, 146, 0));
            Drawer.drawLine(this.offScreen2, 0, 91, 25, 96, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawLine(this.offScreen2, 0, 92, 25, 97, -2);
            Drawer.drawLine(this.offScreen2, 0, 93, 25, 98, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawLine(this.offScreen2, 119, 86, 70, 96, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawLine(this.offScreen2, 119, 87, 70, 97, -2);
            Drawer.drawLine(this.offScreen2, 119, 88, 70, 98, Drawer.rgbPixel(146, 73, 0));
            Drawer.drawClipImage(this.offScreen2, plateLR, 0, 97, 35, 15, 0, 0);
            Drawer.drawClipImage(this.offScreen2, plateLR, 60, 97, 44, 15, 39, 0);
            Drawer.drawImage(this.offScreen2, 37, 99, plateC);
            curScreen = 0;
        }
        Drawer.drawImage(this.offScreen, 0, 0, this.offImage2);
        preBatterType = -1;
        this.drawPitcher(0);
    }

    public void drawAttackScreen2() {
        if (curScreen != 0) {
            Drawer.drawImage(this.offScreen2, -correctionX, -correctionY, addedImgA);
            curScreen = 0;
        }
        Drawer.drawImage(this.offScreen, 0, 0, this.offImage2);
        preBatterType = -1;
        this.drawPitcher(0);
    }

    public void drawRunnerWin() {
        this.drawRoundBox(81, 49, 37, 29);
        Drawer.drawFillRect(this.offScreen, 84, 52, 31, 23, Drawer.rgbPixel(255, 255, 171));
        Drawer.drawImage(this.offScreen, 87, 53, runStatImg);
        if ((runnerInfo & 1) == 1) {
            Drawer.drawFillRect(this.offScreen, 104, 62, 5, 5, Drawer.rgbPixel(255, 146, 0));
        }
        if ((runnerInfo >> 1 & 1) == 1) {
            Drawer.drawFillRect(this.offScreen, 97, 56, 5, 5, Drawer.rgbPixel(255, 146, 0));
        }
        if ((runnerInfo >> 2 & 1) == 1) {
            Drawer.drawFillRect(this.offScreen, 90, 62, 5, 5, Drawer.rgbPixel(255, 146, 0));
        }
    }

    public void drawBallWin() {
        this.drawRoundBox(81, 80, 37, 29);
        Drawer.drawFillRect(this.offScreen, 84, 83, 31, 23, Drawer.rgbPixel(219, 255, 255));
        Drawer.drawClipImage(this.offScreen, iconsImg, 86, 85, 5, 19, 58, 0);
        this.drawStrike();
        this.drawBall();
        this.drawOut();
    }

    public void drawDefenseScreen() {
        Drawer.drawFillRect(this.offScreen, 0, 25, 120, 50, Drawer.rgbPixel(146, 219, 171));
        Drawer.drawClipImage(this.offScreen, groundImg, 0, 0, 120, 27, 0, 0);
        Drawer.drawClipImage(this.offScreen, groundImg, 0, 44, 120, 68, 0, 27);
    }

    public void drawDefensePlayer(int n) {
        int n2 = 0;
        while (n2 < defensePos.length) {
            if (n2 != n && n2 != 2 && (n2 != 4 || n != 2) && (n != 1 && n != 3 || n2 != 0)) {
                Drawer.drawClipImage(this.offScreen, runnerImg, defensePos[n2][0], defensePos[n2][1], 11, 13, 0, 0);
            }
            ++n2;
        }
    }

    public void drawFence() {
        Drawer.clearScreen(this.offScreen);
        Drawer.drawClipImage(this.offScreen, fenceImg, 0, 0, 37, 16, 0, 0);
        Drawer.drawClipImage(this.offScreen, fenceImg, 82, 0, 38, 16, 37, 0);
        Drawer.drawClipImage(this.offScreen, fenceImg, 0, 96, 37, 16, 0, 16);
        Drawer.drawClipImage(this.offScreen, fenceImg, 82, 96, 38, 16, 37, 16);
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < 5) {
                Drawer.drawImage(this.offScreen, 37 + 9 * n2, 107 * n, fenceCImg);
                ++n2;
            }
            ++n;
        }
    }

    public void drawFence2() {
        int n = fenceImg.getWidth() / 2;
        int n2 = fenceImg.getHeight() / 2;
        Drawer.clearScreen(this.fullGraphics);
        Drawer.drawClipImage(this.fullGraphics, fenceImg, 0, 0, n, n2, 0, 0);
        Drawer.drawClipImage(this.fullGraphics, fenceImg, LCD_WIDTH - n - 1, 0, n, n2, n, 0);
        Drawer.drawClipImage(this.fullGraphics, fenceImg, 0, LCD_HEIGHT - n2, n, n2, 0, n2);
        Drawer.drawClipImage(this.fullGraphics, fenceImg, LCD_WIDTH - n - 1, LCD_HEIGHT - n2, n, n2, n, n2);
    }

    public void drawHelpImg() {
        if (attacker == 1) {
            generalThread.setDirection(5);
            this.drawGlove();
            if (pitcherPosX == 33) {
                Drawer.drawClipImage(this.offScreen, iconsImg, 20, 33, 11, 11, 0, 7);
                Drawer.drawClipImage(this.offScreen, iconsImg, 64, 33, 11, 11, 11, 7);
            }
            this.drawRoundBox(61, 1, 58, 32);
            Drawer.drawClipImage(this.offScreen, iconsImg, 67, 5, 12, 11, 22, 7);
            Drawer.drawClipImage(this.offScreen, iconsImg, 84, 5, 12, 11, 46, 7);
            Drawer.drawClipImage(this.offScreen, iconsImg, 101, 5, 12, 11, 34, 7);
            if (pitcherType == 0) {
                Drawer.drawString(this.offScreen, "S", 67, 16);
                Drawer.drawString(this.offScreen, "C", 84, 16);
                Drawer.drawString(this.offScreen, "F", 101, 17);
            } else {
                Drawer.drawString(this.offScreen, "S", 67, 16);
                Drawer.drawString(this.offScreen, "K", 84, 16);
                Drawer.drawString(this.offScreen, "P", 101, 16);
            }
        } else {
            Drawer.drawImage(this.offScreen, 33, 75, number1Img);
            this.drawScoreWin2();
        }
        this.drawBallWin();
        this.drawRunnerWin();
    }

    public void drawHelpImg2() {
        helpImgOn = true;
        if (attacker == 1) {
            this.drawGlove();
            if (pitcherPosX == 33) {
                Drawer.drawClipImage(this.offScreen, iconsImg, 20, 33, 11, 11, 0, 7);
                Drawer.drawClipImage(this.offScreen, iconsImg, 64, 33, 11, 11, 11, 7);
            }
            Drawer.drawFillRect(this.offScreen, 61, -12, 85, 45, -2);
            this.drawRoundBox2(61, -12, 85, 45);
            Drawer.drawClipImage(this.offScreen, iconsImg, 66, -8, 12, 11, 22, 7);
            Drawer.drawClipImage(this.offScreen, iconsImg, 66, 4, 12, 11, 46, 7);
            Drawer.drawClipImage(this.offScreen, iconsImg, 66, 16, 12, 11, 34, 7);
            Drawer.drawClipImage(this.fullGraphics, iconsImg, 66 + correctionX, -8 + correctionY, 12, 11, 22, 7);
            Drawer.drawClipImage(this.fullGraphics, iconsImg, 66 + correctionX, 4 + correctionY, 12, 11, 46, 7);
            Drawer.drawClipImage(this.fullGraphics, iconsImg, 66 + correctionX, 16 + correctionY, 12, 11, 34, 7);
            if (pitcherType == 0) {
                Drawer.drawImage(this.offScreen, 80, -8, stuff_fastballImg);
                Drawer.drawImage(this.fullGraphics, 80 + correctionX, -8 + correctionY, stuff_fastballImg);
                Drawer.drawImage(this.offScreen, 80, 4, stuff_curveballImg);
                Drawer.drawImage(this.fullGraphics, 80 + correctionX, 4 + correctionY, stuff_curveballImg);
                Drawer.drawImage(this.offScreen, 80, 16, stuff_forkballImg);
                Drawer.drawImage(this.fullGraphics, 80 + correctionX, 16 + correctionY, stuff_forkballImg);
            } else {
                Drawer.drawImage(this.offScreen, 80, -8, stuff_fastballImg);
                Drawer.drawImage(this.fullGraphics, 80 + correctionX, -8 + correctionY, stuff_fastballImg);
                Drawer.drawImage(this.offScreen, 80, 4, stuff_sliderImg);
                Drawer.drawImage(this.fullGraphics, 80 + correctionX, 4 + correctionY, stuff_sliderImg);
                Drawer.drawImage(this.offScreen, 80, 16, stuff_sinkerImg);
                Drawer.drawImage(this.fullGraphics, 80 + correctionX, 16 + correctionY, stuff_sinkerImg);
            }
        } else {
            Drawer.drawImage(this.offScreen, 33, 75, number1Img);
            this.drawScoreWin2();
        }
        this.drawBallWin();
        this.drawRunnerWin();
    }

    public void eraseHelpImg() {
        Drawer.drawClipImage(this.offScreen, this.offImage2, 33, 75, 37, 35, 33, 75);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 20, 33, 11, 11, 20, 33);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 64, 33, 11, 11, 64, 33);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 61, 1, 58, 32, 61, 1);
        this.drawBatter(0);
        this.drawScoreWin2();
    }

    public void eraseHelpImg2() {
        Drawer.drawClipImage(this.offScreen, this.offImage2, 33, 75, 37, 35, 33, 75);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 20, 33, 11, 11, 20, 33);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 64, 33, 11, 11, 64, 33);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 61, -12, 85, 45, 61, -12);
        Drawer.drawClipImage(this.fullGraphics, this.offImage2, 33 + correctionX, 75 + correctionY, 37, 35, 33, 75);
        Drawer.drawClipImage(this.fullGraphics, this.offImage2, 20 + correctionX, 33 + correctionY, 11, 11, 20, 33);
        Drawer.drawClipImage(this.fullGraphics, this.offImage2, 64 + correctionX, 33 + correctionY, 11, 11, 64, 33);
        Drawer.drawClipImage(this.fullGraphics, this.offImage2, 61 + correctionX, -12 + correctionY, 85, 45, 61, -12);
        this.drawBatter(0);
        this.drawScoreWin2();
        helpImgOn = false;
    }

    public void drawScoreWin() {
        this.drawRoundBox(61, 1, 58, 29);
        this.drawBallImg(this.offScreen, 67, 6, 3);
        this.drawBallImg(this.offScreen, 105, 6, 3);
        Drawer.drawString(this.offScreen, curInning + 1 + "", 78, 4);
        Drawer.drawClipImage(this.offScreen, decisionImg, 86, 6, 7, 9, 112, 11);
        if (attacker == 1) {
            Drawer.drawClipImage(this.offScreen, decisionImg, 94, 6, 7, 9, 120, 11);
        } else {
            Drawer.drawClipImage(this.offScreen, decisionImg, 94, 6, 7, 9, 127, 11);
        }
        Drawer.drawFillRect(this.offScreen, 66, 16, 9, 9, -3);
        Drawer.drawFillRect(this.offScreen, 105, 16, 9, 9, -3);
        Drawer.drawClipImage(this.offScreen, displayImg, 67, 17, 7, 7, 77, 5);
        Drawer.drawClipImage(this.offScreen, displayImg, 106, 17, 7, 7, 84, 5);
        Drawer.drawLine(this.offScreen, 88, 20, 91, 20, -5);
        this.drawDisplayNb(gameScore[0], 75, 15);
        this.drawDisplayNb(gameScore[1], 92, 15);
    }

    public void drawScoreWin2() {
        this.drawRoundBox(61, 1, 58, 29);
        this.drawBallImg(this.offScreen, 65, 6, 3);
        this.drawBallImg(this.offScreen, 107, 6, 3);
        if (attacker == 1) {
            Drawer.drawImage(this.offScreen, 74, 6, inn_topImg);
        } else {
            Drawer.drawImage(this.offScreen, 74, 6, inn_bottomImg);
        }
        Font font = this.offScreen.getFont();
        this.offScreen.setFont(Font.getFont((int)0, (int)0, (int)8));
        this.offScreen.drawString(Integer.toString(curInning + 1), 97, 4, 24);
        this.offScreen.setFont(font);
        if (curInning + 1 == 1) {
            Drawer.drawImage(this.offScreen, 98, 6, inn_stImg);
        } else if (curInning + 1 == 2) {
            Drawer.drawImage(this.offScreen, 98, 6, inn_ndImg);
        } else if (curInning + 1 == 3) {
            Drawer.drawImage(this.offScreen, 98, 6, inn_rdImg);
        } else {
            Drawer.drawImage(this.offScreen, 98, 6, inn_thImg);
        }
        Drawer.drawFillRect(this.offScreen, 66, 16, 9, 9, -3);
        Drawer.drawFillRect(this.offScreen, 105, 16, 9, 9, -3);
        Drawer.drawClipImage(this.offScreen, displayImg, 67, 17, 7, 7, 77, 5);
        Drawer.drawClipImage(this.offScreen, displayImg, 106, 17, 7, 7, 84, 5);
        Drawer.drawLine(this.offScreen, 88, 20, 91, 20, -5);
        this.drawDisplayNb(gameScore[0], 75, 15);
        this.drawDisplayNb(gameScore[1], 92, 15);
    }

    public boolean drawChangeWin() {
        changeNb = attacker == 1 ? changePitcher >> 10 & 0xF : changeBatter >> 10 & 0xF;
        if (changeNb == 2) {
            return false;
        }
        changeNb = 2 - changeNb + 1;
        this.drawRoundBox(32, 11, 59, 38 + 28 * (changeNb - 1));
        Drawer.drawRect(this.offScreen, 36, 15, 51, 30 + 28 * (changeNb - 1), -3);
        Drawer.drawClipImage(this.offScreen, iconsImg, 40, 19, 43, 7, 0, 0);
        int n = 30;
        if (attacker == 1) {
            int n2 = 1;
            while (n2 < 3) {
                if (n2 != (changePitcher & 0xFF)) {
                    Drawer.drawString(this.offScreen, pitcherName.substring(n2 * 3, (n2 + 1) * 3), 46, n);
                    this.drawDefenseRate(47, n + 14, pitcherInfo[n2] & 0xFFF);
                    GameCanvas.changeItem[(n - 30) / 28] = n2;
                    n += 28;
                }
                ++n2;
            }
        } else {
            int n3 = 9;
            while (n3 < 11) {
                if (n3 != (changeBatter & 0xFF)) {
                    Drawer.drawString(this.offScreen, batterName.substring(n3 * 3, (n3 + 1) * 3), 46, n);
                    this.drawAttackRate(47, n + 14, batterInfo[n3]);
                    GameCanvas.changeItem[(n - 30) / 28] = n3;
                    n += 28;
                }
                ++n3;
            }
        }
        Drawer.drawString(this.offScreen, "BACK", 46, n);
        changeIndex = changeNb - 1;
        Drawer.drawClipImage(this.offScreen, iconsImg, 40, 32 + 28 * changeIndex, 4, 7, 43, 0);
        return true;
    }

    public void drawBallImg(Graphics graphics, int n, int n2, int n3) {
        int n4 = BALL_IMAGE_INFO[n3] >> 10 & 0xFF;
        int n5 = BALL_IMAGE_INFO[n3] & 0xFF;
        Drawer.drawClipImage(graphics, ballImg, n, n2, n5, n5, n4, 0);
    }

    public void drawShadowImg(Graphics graphics, int n, int n2, int n3) {
        int n4 = BALL_IMAGE_INFO[n3] >> 10 & 0xFF;
        int n5 = BALL_IMAGE_INFO[n3] & 0xFF;
        Drawer.drawClipImage(graphics, ballImg, n, n2, n5, n5, n4, 8);
    }

    public void drawDisplay() {
        int n = 0;
        if (state == 6) {
            n = 4;
        }
        this.drawDefenseScreen();
        Drawer.drawFillRect(this.offScreen, 1, 30 + n, 118, 52, -2);
        Drawer.drawRect(this.offScreen, 1, 30 + n, 118, 52, -4);
        Drawer.drawRect(this.offScreen, 2, 31 + n, 116, 50, -5);
        Drawer.drawRect(this.offScreen, 4, 33 + n, 112, 38, -5);
        Drawer.drawFillRect(this.offScreen, 5, 45 + n, 110, 2, -5);
        Drawer.drawFillRect(this.offScreen, 16, 34 + n, 2, 36, -5);
        Drawer.drawLine(this.offScreen, 5, 58 + n, 114, 58 + n, -5);
        int n2 = 0;
        while (n2 < 6) {
            Drawer.drawLine(this.offScreen, 31 + 14 * n2, 34 + n, 31 + 14 * n2, 69 + n, -5);
            ++n2;
        }
        Drawer.drawClipImage(this.offScreen, displayImg, 4, 73 + n, 112, 5, 0, 0);
        int n3 = 0;
        while (n3 < 7) {
            Drawer.drawFillRect(this.offScreen, 19 + 14 * n3, 35 + n, 11, 9, Drawer.rgbPixel(0, 219, 255));
            ++n3;
        }
        int n4 = Math.max(curInning - 2, 0);
        if (curInning > 6) {
            n4 = 4;
        }
        int n5 = n4;
        while (n5 < n4 + 5) {
            Drawer.drawClipImage(this.offScreen, displayImg, 21 + 14 * (n5 - n4), 36 + n, 7, 7, n5 * 7, 5);
            ++n5;
        }
        Drawer.drawClipImage(this.offScreen, displayImg, 91, 36 + n, 7, 7, 70, 5);
        Drawer.drawClipImage(this.offScreen, displayImg, 105, 36 + n, 7, 7, 63, 5);
        Drawer.drawFillRect(this.offScreen, 6, 35 + n, 9, 9, Drawer.rgbPixel(0, 219, 255));
        Drawer.drawLine(this.offScreen, 5, 34 + n, 15, 44 + n, -5);
        Drawer.drawLine(this.offScreen, 6, 34 + n, 15, 43 + n, -2);
        Drawer.drawLine(this.offScreen, 5, 35 + n, 14, 44 + n, -2);
        Drawer.drawFillRect(this.offScreen, 5, 48 + n, 11, 9, Drawer.rgbPixel(0, 219, 255));
        Drawer.drawFillRect(this.offScreen, 5, 60 + n, 11, 9, Drawer.rgbPixel(0, 219, 255));
        Drawer.drawClipImage(this.offScreen, displayImg, 7, 61 + n, 7, 7, 77, 5);
        Drawer.drawClipImage(this.offScreen, displayImg, 7, 49 + n, 7, 7, 84, 5);
        int n6 = n4;
        while (n6 < curInning) {
            this.drawDisplayNb(inningScore[n6][1], 18 + 14 * (n6 - n4), 47 + n);
            this.drawDisplayNb(inningScore[n6][0], 18 + 14 * (n6 - n4), 59 + n);
            ++n6;
        }
        if (attacker == 0) {
            this.drawDisplayNb(inningScore[curInning][1], 18 + 14 * (curInning - n4), 47 + n);
        }
        this.drawDisplayNb(gameScore[1], 88, 47 + n);
        this.drawDisplayNb(gameScore[0], 88, 59 + n);
        this.drawDisplayNb(hitScore[1], 102, 47 + n);
        this.drawDisplayNb(hitScore[0], 102, 59 + n);
    }

    public void drawDisplay2() {
        int n = 0;
        if (state == 6) {
            n = 4;
        }
        this.drawDefenseScreen();
        Drawer.drawImage(this.offScreen, -5, 30, scoreboardImg);
        Drawer.drawImage(this.fullGraphics, -5 + correctionX, 30 + correctionY, scoreboardImg);
        int n2 = Math.max(curInning - 2, 0);
        if (curInning > 6) {
            n2 = 4;
        }
        int n3 = n2;
        while (n3 < curInning) {
            this.drawDisplayNb2(inningScore[n3][1], 24 + 14 * (n3 - n2), 47 + n);
            this.drawDisplayNb2(inningScore[n3][0], 24 + 14 * (n3 - n2), 59 + n);
            ++n3;
        }
        if (attacker == 0) {
            this.drawDisplayNb2(inningScore[curInning][1], 24 + 14 * (curInning - n2), 47 + n);
        }
        this.drawDisplayNb2(gameScore[1], 94, 47 + n);
        this.drawDisplayNb2(gameScore[0], 94, 59 + n);
        this.drawDisplayNb2(hitScore[1], 108, 47 + n);
        this.drawDisplayNb2(hitScore[0], 108, 59 + n);
    }

    public void drawDisplayNb(int n, int n2, int n3) {
        if (n < 10) {
            Drawer.drawClipImage(this.offScreen, displayImg, n2 + 4, n3 + 2, 5, 7, n * 5, 12);
        } else {
            Drawer.drawClipImage(this.offScreen, displayImg, n2 + 1, n3 + 2, 5, 7, n / 10 * 5, 12);
            Drawer.drawClipImage(this.offScreen, displayImg, n2 + 7, n3 + 2, 5, 7, n % 10 * 5, 12);
        }
    }

    public void drawDisplayNb2(int n, int n2, int n3) {
        if (n < 10) {
            Drawer.drawClipImage(this.offScreen, displayImg, n2 + 4, n3 + 2, 5, 7, n * 5, 12);
            Drawer.drawClipImage(this.fullGraphics, displayImg, n2 + 4 + correctionX, n3 + 2 + correctionY, 5, 7, n * 5, 12);
        } else {
            Drawer.drawClipImage(this.offScreen, displayImg, n2 + 1, n3 + 2, 5, 7, n / 10 * 5, 12);
            Drawer.drawClipImage(this.fullGraphics, displayImg, n2 + 1, n3 + 2, 5 + correctionX, 7 + correctionY, n / 10 * 5, 12);
            Drawer.drawClipImage(this.offScreen, displayImg, n2 + 7, n3 + 2, 5, 7, n % 10 * 5, 12);
            Drawer.drawClipImage(this.fullGraphics, displayImg, n2 + 7, n3 + 2, 5 + correctionX, 7 + correctionY, n % 10 * 5, 12);
        }
    }

    public void drawGlove() {
        int n = GameCanvas.generalThread.horizon + (pitcherPosX - 33) / 5;
        int n2 = GameCanvas.generalThread.pitchBallType - 1;
        Drawer.drawClipImage(this.offScreen, this.offImage2, 29, 79, 40, 29, 29, 79);
        this.drawBatter(0);
        Drawer.drawClipImage(this.offScreen, displayImg, 41 + 6 * n, 88 + 9 * n2, 16, 11, 91, 5);
    }

    public void drawPitcher(int n) {
        Drawer.drawClipImage(this.offScreen, this.offImage2, pitcherPosX - 2, pitcherPosY, 24, 26, pitcherPosX, pitcherPosY);
        if (n == 2 && pitcherType == 1) {
            Drawer.drawClipImage(this.offScreen, pitcherImg, pitcherPosX - 2, pitcherPosY, 22, 26, 89, 0);
        } else {
            Drawer.drawClipImage(this.offScreen, pitcherImg, pitcherPosX, pitcherPosY, 22, 26, 22 * n, 0);
        }
    }

    public void drawBatter(int n) {
        currentBatterType = n;
        if (preBatterType == 1 && n != 1) {
            Drawer.drawClipImage(this.offScreen, this.offImage2, 34, 89, 28, 13, 34, 89);
        }
        Drawer.drawClipImage(this.offScreen, batterImg, batterPosX, batterPosY, 36, 60, 36 * n, 0);
        Drawer.drawClipImage(this.fullGraphics, batterImg, batterPosX + correctionX, batterPosY + correctionY, 36, 60, 36 * n, 0);
        preBatterType = n;
    }

    public void drawPlayerInfo() {
        this.save1();
        if (preBatterType != 0) {
            this.drawBatter(0);
        }
        this.drawRoundBox(54, 40, 64, 33);
        this.drawRoundBox(54, 76, 64, 33);
        String string = "";
        if (attacker == 0) {
            if (curBatterNb < 9) {
                Drawer.drawString(this.offScreen, curBatterNb + 1 + "", 63, 79);
            }
            Drawer.drawString(this.offScreen, batterName.substring(curBatterNb * 3, (curBatterNb + 1) * 3), 72, 79);
            this.drawAttackRate(73, 93, batterInfo[curBatterNb]);
            int n = PITCHER_INFO[curComPitcherNb] >> 15 & 0x1F;
            int n2 = PITCHER_INFO[curComPitcherNb] >> 10 & 0x1F;
            int n3 = PITCHER_INFO[curComPitcherNb] & 0x3FF;
            Drawer.drawString(this.offScreen, PITCHER_NAME.substring(n, n + n2), 61 + (4 - n2) * 6, 44);
            Drawer.drawString(this.offScreen, n3 / 100 + "." + n3 % 100, 73, 57);
        } else {
            Drawer.drawString(this.offScreen, pitcherName.substring(curPitcherNb * 3, (curPitcherNb + 1) * 3), 67, 44);
            this.drawDefenseRate(73, 57, pitcherInfo[curPitcherNb] & 0xFFF);
            Drawer.drawString(this.offScreen, curComBatterNb + 1 + "", 59, 79);
            int n = BATTER_INFO[curComBatterNb] >> 15 & 0x1F;
            int n4 = BATTER_INFO[curComBatterNb] >> 10 & 0x1F;
            int n5 = BATTER_INFO[curComBatterNb] & 0x3FF;
            Drawer.drawString(this.offScreen, BATTER_NAME.substring(n, n + n4), 66 + (4 - n4) * 6, 79);
            Drawer.drawString(this.offScreen, "." + n5, 73, 93);
        }
    }

    public void drawAttackRate(int n, int n2, int n3) {
        Drawer.drawString(this.offScreen, "." + n3, n, n2);
    }

    public void drawDefenseRate(int n, int n2, int n3) {
        strBuffer.setLength(0);
        strBuffer.append(n3 / 100).append(".").append(n3 % 100 / 10).append(n3 % 10);
        Drawer.drawString(this.offScreen, strBuffer.toString().trim(), n, n2);
    }

    private void itemSelected(int n) {
        if (state == 1) {
            switch (n) {
                case 0: {
                    this.initialize();
                    this.setState(5);
                    this.drawDefenseScreen();
                    Drawer.drawClipImage(this.offScreen, teamnameImg, 3, 28, 46, 16, 0, 0);
                    Drawer.drawClipImage(this.offScreen, teamnameImg, 75, 28, 38, 16, 46, 0);
                    Drawer.drawClipImage(this.offScreen, teamnameImg, 53, 29, 17, 11, 84, 0);
                    playState = 6;
                    break;
                }
                case 1: {
                    state = 2;
                    this.show();
                    break;
                }
                case 2: {
                    state = 3;
                    this.drawTeamInfo();
                }
            }
        } else {
            switch (n) {
                case 0: {
                    backLight = !backLight;
                    this.drawMenuItem(0);
                    break;
                }
                case 1: {
                    vibration = !vibration;
                    this.drawMenuItem(1);
                    break;
                }
                case 2: {
                    state = 1;
                    this.show();
                }
            }
        }
    }

    private void itemSelected2(int n) {
    }

    private void itemSelected3(int n) {
        if (state == 1) {
            switch (n) {
                case 0: {
                    this.initialize();
                    this.setState(5);
                    this.drawDefenseScreen();
                    int n2 = 46;
                    int n3 = 38;
                    int n4 = teamnameImg.getWidth() - n2 - n3;
                    int n5 = n2 + 4 + n4 + 4 + n3;
                    int n6 = 36;
                    Drawer.drawClipImage(this.fullGraphics, teamnameImg, (LCD_WIDTH - n5) / 2, n6, n2, teamnameImg.getHeight(), 0, 0);
                    Drawer.drawClipImage(this.fullGraphics, teamnameImg, (LCD_WIDTH - n5) / 2 + n2 + 4, n6 + 1, n4, teamnameImg.getHeight(), n2 + n3, 0);
                    Drawer.drawClipImage(this.fullGraphics, teamnameImg, (LCD_WIDTH - n5) / 2 + n2 + 4 + n4 + 4, n6, n3, teamnameImg.getHeight(), n2, 0);
                    playState = 6;
                    break;
                }
                case 1: {
                    state = 2;
                    this.show();
                    break;
                }
                case 2: {
                    state = 3;
                    this.drawTeamInfo3();
                    break;
                }
                case 3: {
                    state = 4;
                    this.drawCredit();
                }
            }
        } else if (state == 2) {
            System.out.println("index===============" + n);
            switch (n) {
                case 0: {
                    isSoundOn = !isSoundOn;
                    this.drawMenuItem3(0);
                    break;
                }
                case 1: {
                    vibration = !vibration;
                    this.drawMenuItem3(1);
                    break;
                }
                case 2: {
                    state = 1;
                    this.show();
                }
            }
        }
    }

    public void keyPressed(int n) {
        if (n == -8) {
            return;
        }
        if (n == 63521) {
            outCount = 3;
        }
        if (!keyEnable) {
            return;
        }
        block1 : switch (state) {
            case 0: {
                if (!(n == -1 | n == -2 | n == -3 | n == -4 | n == 32 | n == -5 | n == 48 | n == 49 | n == 50 | n == 51 | n == 52 | n == 53 | n == 54 | n == 55 | n == 56 | n == 57 | n == 42 | n == 35)) break;
                this.setState(1);
                this.show();
                break;
            }
            case 3: {
                if (!(n == -1 | n == -2 | n == -3 | n == -4 | n == 32 | n == -5 | n == 48 | n == 49 | n == 50 | n == 51 | n == 52 | n == 53 | n == 54 | n == 55 | n == 56 | n == 57 | n == 42 | n == 35)) break;
                this.setState(1);
                this.show();
                break;
            }
            case 4: {
                if (!(n == -1 | n == -2 | n == -3 | n == -4 | n == 32 | n == -5 | n == 48 | n == 49 | n == 50 | n == 51 | n == 52 | n == 53 | n == 54 | n == 55 | n == 56 | n == 57 | n == 42 | n == 35)) break;
                this.setState(1);
                this.show();
                break;
            }
            case 1: 
            case 2: {
                int n2;
                int n3 = n2 = state == 1 ? 4 : 3;
                if (n >= 49 && n <= 49 + n2 - 1) {
                    if (NOKIA_VERSION == 7650) {
                        this.itemSelected3(n - 49);
                    } else {
                        this.itemSelected(n - 49);
                    }
                }
                switch (n) {
                    case -1: {
                        menuIndex = menuIndex == 0 ? n2 - 1 : --menuIndex;
                        if (NOKIA_VERSION == 7650) {
                            this.drawMenuItem3(menuIndex);
                            break;
                        }
                        this.drawMenuItem(menuIndex);
                        break;
                    }
                    case -2: {
                        menuIndex = menuIndex == n2 - 1 ? 0 : ++menuIndex;
                        if (NOKIA_VERSION == 7650) {
                            this.drawMenuItem3(menuIndex);
                            break;
                        }
                        this.drawMenuItem(menuIndex);
                        break;
                    }
                    case -5: 
                    case 32: {
                        if (NOKIA_VERSION == 7650) {
                            this.itemSelected3(menuIndex);
                            break;
                        }
                        this.itemSelected(menuIndex);
                    }
                }
                this.repaint();
                break;
            }
            case 5: {
                switch (playState) {
                    case 4: {
                        this.drawAttackScreen2();
                        this.drawBatter(0);
                        generalThread.setDirection(5);
                        this.drawHelpImg2();
                        this.repaint();
                        playState = 0;
                        break block1;
                    }
                    case 0: {
                        if (n == 32 && generalThread.readyCount < 10) {
                            generalThread.readyCount = 0;
                            this.eraseHelpImg2();
                            helpImgOn = false;
                            playState = 11;
                        }
                        if (attacker == 1) {
                            if (n == -3 && pitcherPosX >= 33) {
                                Drawer.drawClipImage(this.offScreen, this.offImage2, 20, 33, 11, 11, 20, 33);
                                Drawer.drawClipImage(this.offScreen, this.offImage2, 64, 33, 11, 11, 64, 33);
                                this.drawPitcher(0);
                                Drawer.drawClipImage(this.offScreen, this.offImage2, (pitcherPosX -= 5) + 22, pitcherPosY, 5, 26, pitcherPosX + 22, pitcherPosY);
                                this.drawGlove();
                            } else if (n == -4 && pitcherPosX <= 33) {
                                Drawer.drawClipImage(this.offScreen, this.offImage2, 20, 33, 11, 11, 20, 33);
                                Drawer.drawClipImage(this.offScreen, this.offImage2, 64, 33, 11, 11, 64, 33);
                                this.drawPitcher(0);
                                Drawer.drawClipImage(this.offScreen, this.offImage2, (pitcherPosX += 5) - 5, pitcherPosY, 5, 26, pitcherPosX - 5, pitcherPosY);
                                this.drawGlove();
                            }
                            if (n >= 49 && n <= 57) {
                                generalThread.setDirection(n - 48);
                                this.drawGlove();
                            }
                            if (n == 42 || n == 35 || n == 48) {
                                if (n == 42) {
                                    generalThread.setBallType(0, 0);
                                } else if (n == 35) {
                                    generalThread.setBallType(0, 1);
                                } else if (pitcherType == 0) {
                                    generalThread.setBallType(-1, 0);
                                } else {
                                    generalThread.setBallType(1, 0);
                                }
                                this.eraseHelpImg2();
                                playState = 1;
                            }
                            this.repaint();
                            break block1;
                        }
                        this.steal();
                        break block1;
                    }
                    case 2: {
                        if (attacker != 0) break block1;
                        if (n >= 49 && n <= 57) {
                            generalThread.setSwingInfo(n - 48);
                            break block1;
                        }
                        if (n != 48 || runnerInfo == 0) break block1;
                        this.steal();
                        break block1;
                    }
                    case 5: {
                        this.playStart();
                        break block1;
                    }
                    case 3: {
                        prePressKey = n;
                        curPressKey = n;
                        break block1;
                    }
                    case 6: {
                        if (NOKIA_VERSION == 7650) {
                            this.drawDisplay2();
                        } else {
                            this.drawDisplay();
                        }
                        this.repaint();
                        playState = 5;
                        try {
                            rs.setRecord(1, new byte[]{1, (byte)teamVictory, (byte)teamDefeat}, 0, 3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.save1();
                        break block1;
                    }
                    case 9: {
                        if (n == -1 && changeIndex > 0) {
                            Drawer.drawFillRect(this.offScreen, 40, 32 + 28 * changeIndex, 4, 7, -2);
                            Drawer.drawClipImage(this.offScreen, iconsImg, 40, 32 + 28 * --changeIndex, 4, 7, 43, 0);
                        } else if (n == -2 && changeIndex < changeNb - 1) {
                            Drawer.drawFillRect(this.offScreen, 40, 32 + 28 * changeIndex, 4, 7, -2);
                            Drawer.drawClipImage(this.offScreen, iconsImg, 40, 32 + 28 * ++changeIndex, 4, 7, 43, 0);
                        } else if (n == -5 || n == 32) {
                            if (changeIndex != changeNb - 1) {
                                if (attacker == 1) {
                                    changePitcher += 1024;
                                    curPitcherNb = changeItem[changeIndex];
                                    changePitcher = changePitcher & 0xFFFFFF00 | changeItem[changeIndex];
                                    pitcherType = pitcherInfo[curPitcherNb] >> 20 & 1;
                                    GameCanvas.pitchingNb[0] = 0;
                                } else {
                                    changeBatter += 1024;
                                    oldBatterNb = curBatterNb;
                                    curBatterNb = changeItem[changeIndex];
                                    changeBatter = changeBatter & 0xFFFFFF00 | changeItem[changeIndex];
                                }
                            }
                            this.drawAttackScreen2();
                            this.drawPlayerInfo();
                            playState = 4;
                        }
                        this.repaint();
                        break block1;
                    }
                }
                break;
            }
            case 6: {
                this.initialize();
                this.setState(0);
                this.show();
                this.repaint();
            }
        }
    }

    public void keyReleased(int n) {
        curPressKey = -100;
    }

    public void steal() {
        if ((runnerInfo >> 1 & 1) == 1 && (runnerInfo >> 2 & 1) == 0) {
            stealRunner = 2;
        } else if ((runnerInfo & 1) == 1 && (runnerInfo >> 1 & 1) == 0) {
            stealRunner = 1;
        }
    }

    public void increaseStrike() {
        if (++strikeCount > 2) {
            this.pause(300);
            Drawer.drawClipImage(this.offScreen, this.offImage2, 38, 74, 28, 7, 38, 74);
            Drawer.drawClipImage(this.offScreen, this.offImage2, 37, 83, 30, 11, 37, 83);
            Drawer.drawClipImage(this.offScreen, decisionImg, 43, 60, 20, 11, 67, 0);
            this.repaint();
            this.pause(500);
            Drawer.drawClipImage(this.offScreen, this.offImage2, 43, 60, 20, 11, 43, 60);
            this.increaseOut();
        } else {
            Drawer.drawClipImage(this.offScreen, iconsImg, 87 + 7 * strikeCount, 85, 5, 5, 47, 0);
        }
        this.save3();
    }

    public void increaseBall() {
        if (++ballCount > 3) {
            this.increaseRunner();
        } else {
            Drawer.drawClipImage(this.offScreen, iconsImg, 87 + 7 * ballCount, 92, 5, 5, 47, 0);
        }
        this.save3();
    }

    public void increaseOut() {
        ballCount = 0;
        strikeCount = 0;
        this.drawStrike();
        this.drawBall();
        this.nextBatter(false);
        if (++outCount > 2) {
            outCount = 0;
            this.changeAttacker();
        } else {
            this.drawAttackScreen2();
            this.drawPlayerInfo();
            playState = 4;
        }
    }

    public void increaseRunner() {
        ballCount = 0;
        strikeCount = 0;
        this.drawAttackScreen2();
        Drawer.drawClipImage(this.offScreen, this.offImage2, 38, 74, 28, 7, 38, 74);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 37, 83, 30, 11, 37, 83);
        Drawer.drawClipImage(this.offScreen, decisionImg, 34, 60, 38, 11, 87, 0);
        this.nextBatter(false);
        int n = 0;
        while (n < 3) {
            if ((runnerInfo >> n & 1) == 0) {
                runnerInfo |= 1 << n;
                break;
            }
            if (n == 2) {
                int n2 = attacker;
                gameScore[n2] = gameScore[n2] + 1;
            }
            ++n;
        }
        this.repaint();
        this.pause(800);
        Drawer.drawClipImage(this.offScreen, this.offImage2, 34, 60, 38, 11, 34, 60);
        this.drawBatter(0);
        this.drawPlayerInfo();
        playState = 4;
    }

    public void nextBatter(boolean bl) {
        if (attacker == 0) {
            if (oldBatterNb != -1) {
                curBatterNb = oldBatterNb;
                oldBatterNb = -1;
            }
            if (++curBatterNb == 9) {
                curBatterNb = 0;
            }
        } else if (++curComBatterNb == 9) {
            curComBatterNb = 0;
        }
    }

    public void changeAttacker() {
        attacker = 1 - attacker;
        runnerInfo = 0;
        if (attacker == 1) {
            if (++curInning == 9) {
                playState = -1;
                this.gameEnd();
                return;
            }
            pitcherType = pitcherInfo[curPitcherNb] >> 20 & 1;
        } else {
            if (pitchingNb[1] > 40 && changeComPitcher != 7) {
                boolean bl = false;
                while (!bl) {
                    curComPitcherNb = Math.abs(ran.nextInt()) % 2 + 1;
                    if ((changeComPitcher >> curComPitcherNb & 1) != 0) continue;
                    bl = true;
                    GameCanvas.pitchingNb[1] = 0;
                    changeComPitcher |= 1 << curComPitcherNb;
                }
            }
            pitcherType = PITCHER_INFO[curComPitcherNb] >> 20 & 1;
            if (curInning == 8 && gameScore[0] > gameScore[1]) {
                playState = -1;
                this.gameEnd();
                return;
            }
        }
        pitcherPosX = 33;
        if (NOKIA_VERSION == 7650) {
            this.drawDisplay2();
        } else {
            this.drawDisplay();
        }
        playState = 5;
    }

    public void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        state = -1;
        strBuffer = new StringBuffer();
        curScreen = -1;
        playState = -1;
        pitcherType = 0;
        changeItem = new int[2];
        pitchingNb = new int[2];
        curPressKey = -100;
        prePressKey = -100;
        stealRunner = 0;
        gameScore = new int[2];
        hitScore = new int[2];
        inningScore = new int[9][2];
        pitcherName = "PCHKBWKDS";
        pitcherInfo = new int[]{350, 1048870, 408};
        batterName = "JSKLJBSJHYJHLSYMHYLBKPJHJJHJJHPJM";
        batterInfo = new int[]{306, 340, 344, 355, 276, 328, 276, 328, 308, 284, 273};
        PITCHER_INFO = new int[]{4345, 135466, 1315050};
        BATTER_INFO = new int[]{4403, 135510, 266568, 397640, 528714, 659781, 790864, 921900, 1052969};
        DEFENSE_POS = new int[]{55364, 95296, 73772, 16448, 37932, 17435, 55314, 95259};
        defensePos = new int[8][2];
        BALL_IMAGE_INFO = new int[]{2, 2052, 6150, 12296};
        PITCH_BALL_INFO = new int[][][]{new int[][]{{51, 53, 32823, 32826, 65597, 65600, 65603, 98374, 98377, 98381, 98385}, {51, 54, 32825, 32829, 65601, 65605, 65611, 98383, 98388, 98393, 98399}, {51, 54, 32826, 32831, 65604, 65610, 65616, 98390, 98397, 98404, 98412}}, new int[][]{{51, 51, 32820, 32821, 65590, 65591, 65595, 98368, 98374, 98380, 98385}, {51, 52, 32821, 32822, 65593, 65597, 65602, 98376, 98383, 98391, 98399}, {51, 53, 32823, 32825, 65596, 65601, 65607, 98383, 98393, 98403, 98412}}};
        SHADOW_BALL_INFO = new int[]{58, 61, 32833, 32837, 32841, 65614, 65619, 65625, 98399, 98407, 98412};
        HIT_BALL_INFO1 = new int[][][]{new int[][]{{3177549, 3174466, 4236347}, {4246584, 61509, 2168886}, {2178106, 1140803, 1136715}}, new int[][]{{49232, 3179588}, {4240443, 64577, 2180154}, {86095, 1151035}}, new int[][]{{5257252, 5271591, 5272602}, {6347801, 6352926, 6365205}, {7437347, 7451674, 7453734}}, new int[][]{{5261359, 5271595}, {6341664, 6362145}, {7432234, 7448620}}, new int[][]{{5250104, 5244978}, {6328334, 6377487}, {7454778, 7457841}}, new int[][]{{5244937, 0x504004}, {6337541, 6354948, 6378500}, {7442437, 7457800}}};
        HIT_BALL_INFO2 = new int[]{84, 458729, 458725, 5780, 5681060, 1834980};
        RUNNER_POS = new int[][]{{55, 97}, {93, 68}, {55, 41}, {16, 68}, {55, 97}};
    }

    public class GeneralThread
    extends Thread {
        public static final int FAULT_SWING = 0;
        public final int FOUL;
        public static final int HIT_SWING = 2;
        public static final int FLY_ANI = 0;
        public static final int HOMERUN_BALL = 1;
        public static final int DEFENSE_BALL = 2;
        public static final int THROW_BALL = 3;
        public static final int DEFENSE_END = 4;
        private boolean alive = true;
        private boolean pitchBall = false;
        private boolean swing = false;
        private boolean isSwing = false;
        private boolean moveRunner = false;
        private boolean flyBall;
        private boolean firstMove;
        private int mul = 1;
        private int comSwingCount;
        private int comSwingType;
        int hitBall;
        private int hitRs;
        private int moveBallCount = 0;
        int swingCount = 0;
        private int readyCount = 0;
        public int pitchBallType = 1;
        public int horizon = 0;
        private int ballType1;
        private int ballType2;
        private int ballVelo;
        private int distance;
        private int swingVertical;
        private int swingHorizon;
        private int hitBallDirection;
        private int shadowPosX;
        private int shadowPosY;
        private int shadowNb;
        private int shadowCenterX;
        private int shadowCenterY;
        private int shadowWidth;
        private int hitBallTypeNb;
        public int ballPosX;
        public int ballPosY;
        public int ballNb;
        public int ballCenterX;
        public int ballCenterY;
        public int ballWidth;
        private int ballEndX;
        private int ballEndY;
        private int ballStartX;
        private int ballStartY;
        private int runnerNb;
        private int runnerCount;
        private int defenseNb;
        private int defenseState;
        private int homeinNb;
        private int[] runnerVelo = new int[4];
        private int[] runnerArray = new int[4];
        private int[] throwBallCount = new int[4];
        private int throwWhere;
        private int curBallIs;
        private int firstBound;
        private int firstBoundX;
        private int firstBoundY;
        private final int[] SWING_RATIO = new int[]{65, 50, 40, 20, 10};
        private final int[] HIT_RATIO = new int[]{51225, 40990, 20505, 50, 30};

        public GeneralThread() {
            this.FOUL = 1;
        }

        public void setSwingInfo(int n) {
            this.swingVertical = (n - 1) / 3;
            this.swingHorizon = (n - 1) % 3 + 1;
            this.swing = true;
        }

        public int hitProcess() {
            int n = 2 + (pitcherPosX - 33) / 5 + this.horizon;
            int n2 = attacker == 1 ? this.comSwingType : Math.abs(this.swingVertical - this.pitchBallType) + Math.abs(this.swingHorizon - n);
            int n3 = 0;
            int n4 = Math.abs(ran.nextInt()) % 100;
            int n5 = 0;
            int n6 = 0;
            if (attacker == 0) {
                if (curBatterNb == 9) {
                    n5 = 20;
                } else if (curBatterNb == 10) {
                    n6 = 20;
                }
            }
            block0 : switch (this.hitBallDirection) {
                case -1: 
                case 1: {
                    switch (n2) {
                        case 0: {
                            this.hitRs = n4 < 80 - this.distance * 5 ? 3 : 1;
                            n3 = 2;
                            break block0;
                        }
                        case 1: {
                            if (n4 < 30) {
                                this.hitRs = 1;
                                n3 = 2;
                            }
                            if (n4 < 60) {
                                this.hitRs = 0;
                                n3 = 2;
                                break block0;
                            }
                            if (n4 < 85) {
                                n3 = 1;
                                break block0;
                            }
                            n3 = 0;
                            break block0;
                        }
                    }
                    n3 = 0;
                    break;
                }
                case 0: {
                    switch (n2) {
                        case 0: {
                            this.hitRs = -1;
                            this.hitBallDirection = n - 2;
                            n3 = 2;
                            break;
                        }
                        case 1: {
                            if (n4 < 20 - this.distance * 10) {
                                this.hitRs = -1;
                                n3 = 2;
                                break;
                            }
                            if (n4 < 60 - this.distance * 10) {
                                this.hitRs = 1;
                                n3 = 2;
                                break;
                            }
                            if (n4 < 75) {
                                this.hitRs = 0;
                                n3 = 2;
                                break;
                            }
                            if (n4 < 90) {
                                n3 = 1;
                                break;
                            }
                            n3 = 0;
                            break;
                        }
                        default: {
                            n3 = n4 < 20 ? 1 : 0;
                        }
                    }
                    if (this.hitRs != -1) break;
                    n4 = Math.abs(ran.nextInt()) % 100;
                    this.hitRs = n4 < 40 - this.distance * 10 ? 3 : (n4 < 80 - this.distance * 20 + n5 ? 4 : 2);
                    n4 = Math.abs(ran.nextInt()) % 100;
                    if (this.hitRs != 4 || n4 >= 40 - this.distance * 15 + n6) break;
                    this.hitRs = 5;
                }
            }
            return n3;
        }

        public void setDirection(int n) {
            this.pitchBallType = (n - 1) / 3;
            this.horizon = (n - 1) % 3 - 1;
            int n2 = 2 + (pitcherPosX - 33) / 5 + this.horizon;
            this.distance = Math.abs(1 - this.pitchBallType) + Math.abs(2 - n2);
            if (Math.abs(2 - n2) == 2) {
                ++this.distance;
            }
        }

        public void setBallType(int n, int n2) {
            this.ballType1 = n;
            this.ballType2 = n2;
        }

        public boolean ballDecide() {
            int n = pitchingNb[1 - attacker] / 40 * 10;
            if (this.ballType1 != 0 || this.ballType2 != 0) {
                n += 10;
            }
            switch (this.distance) {
                case 0: {
                    return true;
                }
                case 1: {
                    return Math.abs(ran.nextInt()) % 100 < 70;
                }
                case 2: {
                    return Math.abs(ran.nextInt()) % 100 < 30;
                }
            }
            return false;
        }

        public void comSwing() {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            int n3 = this.SWING_RATIO[this.distance];
            if (ballCount == 3) {
                n3 -= 10;
            }
            if (strikeCount == 2) {
                n3 += 15;
            }
            if (Math.abs(ran.nextInt()) % 100 < n3) {
                int n4;
                n = this.HIT_RATIO[this.distance] >> 10 & 0xFF;
                n2 = this.HIT_RATIO[this.distance] & 0xFF;
                if (gameScore[0] > gameScore[1] + 3 && this.distance < 3) {
                    n += 10;
                }
                if ((BATTER_INFO[curComBatterNb] & 0xFF) > 300) {
                    n += 5;
                }
                if ((BATTER_INFO[curComBatterNb] & 0xFF) > 325) {
                    n += 5;
                }
                if ((BATTER_INFO[curComBatterNb] & 0xFF) < 300) {
                    n -= 5;
                }
                this.comSwingType = (n4 = Math.abs(ran.nextInt()) % 100) < n ? 0 : (n4 < n + n2 ? 1 : 2);
                this.swing = true;
            }
        }

        public void outInDefense(int n) {
            int n2;
            int n3;
            int n4 = this.runnerArray[n] >> 4 & 7;
            int n5 = this.runnerArray[n] & 0xF;
            if (n4 == 4) {
                n3 = RUNNER_POS[n4][0];
                n2 = RUNNER_POS[n4][1];
            } else {
                n3 = RUNNER_POS[n4][0] + (RUNNER_POS[n4 + 1][0] - RUNNER_POS[n4][0]) * n5 / 16;
                n2 = RUNNER_POS[n4][1] + (RUNNER_POS[n4 + 1][1] - RUNNER_POS[n4][1]) * n5 / 16;
            }
            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, n3, n2, 11, 13, n3, n2);
            ++outCount;
            --this.runnerNb;
            int n6 = n;
            while (n6 < this.runnerNb) {
                this.runnerArray[n6] = this.runnerArray[n6 + 1];
                this.runnerVelo[n6] = this.runnerVelo[n6 + 1];
                ++n6;
            }
            Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, n3 - 5, n2 - 12, 20, 11, 67, 0);
            GameCanvas.this.repaint();
            GameCanvas.this.pause(300);
            if (outCount == 3) {
                this.defenseState = 4;
            }
            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, n3 - 5, n2 - 12, 20, 11, n3 - 5, n2 - 12);
        }

        public void run() {
            while (this.alive) {
                int n;
                int n2;
                int n3;
                int n4;
                if (this.swing) {
                    this.isSwing = true;
                    ++this.swingCount;
                    if (this.swingCount < 5) {
                        if (this.swingCount % 2 == 0) {
                            GameCanvas.this.drawBatter(this.swingCount / 2);
                            GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, this.ballPosX, this.ballPosY, this.ballNb);
                            if (this.swingCount == 2 && this.moveBallCount >= 17 && this.moveBallCount <= 19) {
                                this.hitBallDirection = this.moveBallCount - 18;
                                this.hitBall = this.hitProcess();
                            }
                        }
                        if (this.swingCount / 2 == 1) {
                            Drawer.drawClipImage(GameCanvas.this.offScreen, batImg, 34, 89, 28, 13, 0, 0);
                            if (this.hitBall == 0 || attacker != 0 || vibration) {
                                // empty if block
                            }
                        }
                        if (this.swingCount == 4 && this.hitBall == 1) {
                            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.ballPosY, 8, 8, this.ballPosX, this.ballPosY);
                            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.shadowPosY, 8, 8, this.ballPosX, this.shadowPosY);
                            Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, 44, 60, 19, 11, 48, 0);
                            GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, 75, 89, 2);
                        }
                    } else if (this.swingCount == 6) {
                        if (this.hitBall == 2) {
                            n4 = 0;
                            while (n4 < 4) {
                                Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.ballPosY, 8, 8, this.ballPosX, this.ballPosY);
                                Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.shadowPosY, 8, 8, this.ballPosX, this.shadowPosY);
                                this.ballPosX += this.hitBallDirection * 4;
                                this.shadowPosY -= 3 + 2 * n4;
                                this.ballPosY = this.hitRs == 0 ? (this.ballPosY += (69 - this.ballPosY) / (4 - n4)) : (this.hitRs == 3 || this.hitRs == 4 ? (this.ballPosY += (63 - this.ballPosY) / (4 - n4)) : (this.ballPosY += (50 - this.ballPosY) / (4 - n4)));
                                this.ballPosY -= 3 + 3 * n4;
                                GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, this.ballPosX, this.ballPosY, 3);
                                GameCanvas.this.drawShadowImg(GameCanvas.this.offScreen, this.ballPosX + n4, this.shadowPosY, 3 - n4);
                                GameCanvas.this.repaint();
                                GameCanvas.this.pause(200);
                                ++n4;
                            }
                            this.hitBallTypeNb = Math.abs(ran.nextInt()) % HIT_BALL_INFO1[this.hitRs][this.hitBallDirection + 1].length;
                            this.ballEndX = HIT_BALL_INFO1[this.hitRs][this.hitBallDirection + 1][this.hitBallTypeNb] >> 10 & 0xFF;
                            this.ballEndY = HIT_BALL_INFO1[this.hitRs][this.hitBallDirection + 1][this.hitBallTypeNb] & 0xFF;
                            this.runnerCount = 0;
                            this.runnerNb = 1;
                            this.runnerArray[0] = 0;
                            this.runnerVelo[0] = 1;
                            n3 = 0;
                            while (n3 < 3) {
                                if ((runnerInfo >> n3 & 1) == 1) {
                                    this.runnerVelo[this.runnerNb] = 1;
                                    this.runnerArray[this.runnerNb] = (n3 + 1 << 4) + 1;
                                    if (stealRunner - 1 == n3) {
                                        int n5 = this.runnerNb;
                                        this.runnerArray[n5] = this.runnerArray[n5] + 2;
                                    }
                                    ++this.runnerNb;
                                }
                                ++n3;
                            }
                            if (this.hitRs == 4) {
                                endAniCount = 14;
                            } else if (this.hitRs == 0) {
                                endAniCount = 5;
                            } else {
                                endAniCount = 10;
                            }
                            n2 = 0;
                            while (n2 < defensePos.length) {
                                GameCanvas.defensePos[n2][0] = DEFENSE_POS[n2] >> 10 & 0xFF;
                                GameCanvas.defensePos[n2][1] = DEFENSE_POS[n2] & 0xFF;
                                ++n2;
                            }
                            GameCanvas.this.drawDefenseScreen();
                            this.defenseNb = HIT_BALL_INFO1[this.hitRs][this.hitBallDirection + 1][this.hitBallTypeNb] >> 20 & 0xFF;
                            GameCanvas.this.drawDefensePlayer(this.defenseNb);
                            Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, 54, 94, 11, 13, 11, 0);
                            Drawer.drawImage(GameCanvas.this.offScreen2, 0, 0, GameCanvas.this.offImage);
                            Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, defensePos[this.defenseNb][0], defensePos[this.defenseNb][1], 11, 13, 0, 0);
                            curScreen = 1;
                            this.homeinNb = 0;
                            this.moveBallCount = 0;
                            this.firstBound = 0;
                            n = 0;
                            while (n < 15) {
                                if ((HIT_BALL_INFO2[this.hitRs] >> n * 2 & 3) == 0) {
                                    this.firstBound = n;
                                    break;
                                }
                                ++n;
                            }
                            this.ballNb = HIT_BALL_INFO2[this.hitRs] >> this.firstBound * 2 & 3;
                            this.ballWidth = BALL_IMAGE_INFO[this.ballNb] & 0xFF;
                            if (this.hitRs == 1 || this.hitRs == 2) {
                                this.firstBoundX = 63 + (this.ballEndX - 63) * this.firstBound / endAniCount - this.ballWidth / 2;
                                this.firstBoundY = 105 + (this.ballEndY - 105) * this.firstBound / endAniCount - this.ballWidth / 2;
                            } else {
                                this.firstBoundX = this.ballEndX;
                                this.firstBoundY = this.ballEndY;
                            }
                            if (attacker == 1 && this.hitRs != 1) {
                                this.firstMove = false;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, displayImg, defensePos[this.defenseNb][0] + 2, defensePos[this.defenseNb][1] - 6, 7, 4, 65, 13);
                            }
                            playState = 3;
                            this.defenseState = 0;
                            this.curBallIs = -1;
                        } else if (this.hitBall == 1) {
                            if (strikeCount < 2) {
                                ++strikeCount;
                            }
                            GameCanvas.this.pause(300);
                            this.swingCount = 0;
                            this.moveBallCount = 0;
                            GameCanvas.this.drawAttackScreen2();
                            GameCanvas.this.drawBatter(0);
                            generalThread.setDirection(5);
                            GameCanvas.this.drawHelpImg2();
                            GameCanvas.this.repaint();
                            playState = 0;
                        }
                        this.swing = false;
                    }
                }
                switch (playState) {
                    case 0: {
                        if (attacker == 0) {
                            if (++this.readyCount == 10) {
                                n4 = ran.nextInt() % 2 * 5;
                                if (pitcherPosX + n4 >= 28 && pitcherPosX + n4 <= 38) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, pitcherPosX, pitcherPosY, 22, 26, pitcherPosX, pitcherPosY);
                                    pitcherPosX += n4;
                                    GameCanvas.this.drawPitcher(0);
                                    GameCanvas.this.repaint();
                                }
                            } else if (this.readyCount == 15) {
                                GameCanvas.this.eraseHelpImg2();
                                this.readyCount = 0;
                                this.setDirection(Math.abs(ran.nextInt()) % 9 + 1);
                                this.setBallType(pitcherType - 1 + Math.abs(ran.nextInt()) % 2, Math.abs(ran.nextInt()) % 2);
                                if (strikeCount == 0 && ballCount > 1) {
                                    n4 = 0;
                                    n4 = ballCount == 2 ? 3 : 5;
                                    if (Math.abs(ran.nextInt()) % 10 < n4) {
                                        this.setDirection(5 - (pitcherPosX - 33) / 5);
                                    } else {
                                        this.setDirection(5 - (pitcherPosX - 33) / 5 + 3 * (ran.nextInt() % 2));
                                    }
                                }
                                playState = 1;
                            }
                            GameCanvas.this.pause(100);
                            break;
                        }
                        GameCanvas.this.repaint();
                        GameCanvas.this.pause(100);
                        break;
                    }
                    case 1: {
                        stealRunner = 0;
                        this.readyCount = 0;
                        n4 = 0;
                        while (n4 < 4) {
                            GameCanvas.this.drawPitcher(n4);
                            GameCanvas.this.repaint();
                            GameCanvas.this.pause(200);
                            ++n4;
                        }
                        this.pitchBall = true;
                        this.hitBall = 0;
                        this.swingCount = 0;
                        if (attacker == 1) {
                            n3 = ran.nextInt();
                            this.comSwingCount = n3 % 2 == 0 ? 16 : (n3 > 0 ? 17 : 15);
                            if (runnerInfo != 0 && Math.abs(ran.nextInt()) % 100 > 95) {
                                GameCanvas.this.steal();
                            }
                        }
                        int n6 = 1 - attacker;
                        pitchingNb[n6] = pitchingNb[n6] + 1;
                        this.ballCenterX = pitcherPosX + 14;
                        this.isSwing = false;
                        playState = 2;
                        break;
                    }
                    case 2: {
                        if (this.moveBallCount == 24) {
                            this.ballVelo = 151 + ran.nextInt() % 7;
                            if (this.ballType1 != 0 || this.ballType2 != 0) {
                                this.ballVelo -= 12;
                            }
                            this.ballVelo -= pitchingNb[1 - attacker] / 20 * 5;
                            if (this.hitBall == 0) {
                                Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.ballPosY, this.ballWidth, this.ballWidth, this.ballPosX, this.ballPosY);
                                Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.shadowPosY, this.shadowWidth, this.shadowWidth, this.ballPosX, this.shadowPosY);
                                GameCanvas.this.drawBatter(0);
                                Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, 56, 74, 10, 7, 137, 11);
                                Drawer.drawClipImage(GameCanvas.this.offScreen, displayImg, 38, 74, 5, 7, this.ballVelo / 100 * 5, 12);
                                Drawer.drawClipImage(GameCanvas.this.offScreen, displayImg, 44, 74, 5, 7, this.ballVelo % 100 / 10 * 5, 12);
                                Drawer.drawClipImage(GameCanvas.this.offScreen, displayImg, 50, 74, 5, 7, this.ballVelo % 10 * 5, 12);
                                if (this.isSwing || this.ballDecide()) {
                                    if (!this.isSwing || strikeCount == 2) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, 37, 83, 30, 11, 0, 0);
                                        GameCanvas.this.repaint();
                                    }
                                    GameCanvas.this.increaseStrike();
                                } else {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, 43, 83, 18, 11, 30, 0);
                                    GameCanvas.this.increaseBall();
                                }
                                GameCanvas.this.repaint();
                                GameCanvas.this.pause(300);
                                if (strikeCount != 0 || ballCount != 0) {
                                    if (stealRunner != 0) {
                                        GameCanvas.this.drawDefenseScreen();
                                        n3 = 0;
                                        n2 = 0;
                                        n = 0;
                                        while (n < DEFENSE_POS.length) {
                                            n3 = DEFENSE_POS[n] >> 10 & 0xFF;
                                            n2 = DEFENSE_POS[n] & 0xFF;
                                            if (n == 2) {
                                                n3 = 54;
                                                n2 = 40;
                                            }
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, n3, n2, 11, 13, 0, 0);
                                            ++n;
                                        }
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, 54, 94, 11, 13, 11, 0);
                                        Drawer.drawImage(GameCanvas.this.offScreen2, 0, 0, GameCanvas.this.offImage);
                                        curScreen = 1;
                                        GameCanvas.this.repaint();
                                        playState = 10;
                                    } else {
                                        GameCanvas.this.pause(500);
                                        GameCanvas.this.drawBatter(0);
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, 38, 74, 28, 7, 38, 74);
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, 37, 83, 30, 11, 37, 83);
                                        generalThread.setDirection(5);
                                        GameCanvas.this.drawHelpImg2();
                                        GameCanvas.this.repaint();
                                        playState = 0;
                                    }
                                }
                                this.swing = false;
                            }
                            this.moveBallCount = 0;
                        } else if (this.moveBallCount < 22 && this.hitBall == 0) {
                            if (this.moveBallCount % 2 == 0) {
                                if (this.moveBallCount > 1) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.ballPosY, this.ballWidth, this.ballWidth, this.ballPosX, this.ballPosY);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.shadowPosY, this.shadowWidth, this.shadowWidth, this.ballPosX, this.shadowPosY);
                                }
                                this.ballNb = PITCH_BALL_INFO[this.ballType2][this.pitchBallType][this.moveBallCount / 2] >> 15 & 3;
                                this.ballWidth = BALL_IMAGE_INFO[this.ballNb] & 0xFF;
                                this.ballCenterY = PITCH_BALL_INFO[this.ballType2][this.pitchBallType][this.moveBallCount / 2] & 0xFF;
                                this.shadowNb = SHADOW_BALL_INFO[this.moveBallCount / 2] >> 15 & 3;
                                this.shadowWidth = BALL_IMAGE_INFO[this.shadowNb] & 0xFF;
                                this.shadowCenterY = SHADOW_BALL_INFO[this.moveBallCount / 2] & 0xFF;
                                if (this.moveBallCount % 2 == 0) {
                                    this.ballCenterX = this.moveBallCount < 11 ? (this.ballCenterX += this.ballType1) : (this.ballCenterX += this.horizon - this.ballType1);
                                }
                                if (this.moveBallCount == 10) {
                                    GameCanvas.this.drawPitcher(0);
                                }
                                this.ballPosX = this.ballCenterX - this.ballWidth / 2;
                                this.ballPosY = this.ballCenterY - this.ballWidth / 2;
                                this.shadowPosY = this.shadowCenterY - this.shadowWidth / 2;
                                GameCanvas.this.drawShadowImg(GameCanvas.this.offScreen, this.ballPosX, this.shadowPosY, this.shadowNb);
                                GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, this.ballPosX, this.ballPosY, this.ballNb);
                                if (this.swingCount / 2 == 1) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, batImg, 34, 89, 28, 13, 0, 0);
                                }
                            }
                            GameCanvas.this.repaint();
                            if (attacker == 1 && this.moveBallCount == this.comSwingCount) {
                                this.comSwing();
                            }
                        } else {
                            GameCanvas.this.repaint();
                        }
                        if (this.hitBall == 0) {
                            GameCanvas.this.pause(70);
                        } else {
                            GameCanvas.this.pause(100);
                        }
                        ++this.moveBallCount;
                        break;
                    }
                    case 3: {
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        n3 = 0;
                        this.moveRunner = false;
                        int n13 = 0;
                        while (n13 < this.runnerNb) {
                            if ((this.runnerArray[n13] >> 4 & 7) == 4) {
                                --this.runnerNb;
                                ++this.homeinNb;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, RUNNER_POS[4][0], RUNNER_POS[4][1], 11, 13, RUNNER_POS[4][0], RUNNER_POS[4][1]);
                            } else if (this.runnerVelo[n13] != 0) {
                                this.moveRunner = true;
                                n2 = this.runnerArray[n13] >> 4 & 7;
                                n = this.runnerArray[n13] & 0xF;
                                n12 = RUNNER_POS[n2][0] + (RUNNER_POS[n2 + 1][0] - RUNNER_POS[n2][0]) * n / 16;
                                n11 = RUNNER_POS[n2][1] + (RUNNER_POS[n2 + 1][1] - RUNNER_POS[n2][1]) * n / 16;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, n12, n11, 11, 13, n12, n11);
                                int n14 = n13;
                                this.runnerArray[n14] = this.runnerArray[n14] + this.runnerVelo[n13];
                                n2 = this.runnerArray[n13] >> 4 & 7;
                                n = this.runnerArray[n13] & 0xF;
                                if (n2 == 4) {
                                    n12 = RUNNER_POS[n2][0];
                                    n11 = RUNNER_POS[n2][1];
                                } else {
                                    n12 = RUNNER_POS[n2][0] + (RUNNER_POS[n2 + 1][0] - RUNNER_POS[n2][0]) * n / 16;
                                    n11 = RUNNER_POS[n2][1] + (RUNNER_POS[n2 + 1][1] - RUNNER_POS[n2][1]) * n / 16;
                                }
                                n3 = (n2 == 0 || n2 == 3) && this.runnerVelo[n13] > 0 || (n2 == 1 || n2 == 2) && this.runnerVelo[n13] < 0 ? 22 : 33;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, n12, n11, 11, 13, n3, 13);
                                if (n == 0) {
                                    if (n2 % 4 == this.curBallIs) {
                                        this.outInDefense(n13);
                                    } else if (this.defenseState != 0 && this.defenseState != 1 || this.defenseNb < 5) {
                                        this.runnerVelo[n13] = 0;
                                        Drawer.drawClipImage(GameCanvas.this.offScreen2, runnerImg, n12, n11, 11, 13, n3, 13);
                                    }
                                }
                                if (this.defenseState == 0 && n2 != 0 && (this.hitRs == 2 && n >= 6 || this.hitRs == 1 && n >= 3) && this.moveBallCount < this.firstBound) {
                                    this.runnerVelo[n13] = 0;
                                }
                            } else {
                                n2 = this.runnerArray[n13] >> 4 & 7;
                                n = this.runnerArray[n13] & 0xF;
                                n12 = RUNNER_POS[n2][0] + (RUNNER_POS[n2 + 1][0] - RUNNER_POS[n2][0]) * n / 16;
                                n11 = RUNNER_POS[n2][1] + (RUNNER_POS[n2 + 1][1] - RUNNER_POS[n2][1]) * n / 16;
                                Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, n12, n11, 11, 13, n3, 13);
                            }
                            ++n13;
                        }
                        switch (this.defenseState) {
                            case 0: {
                                if (this.moveBallCount <= endAniCount) {
                                    if (this.moveBallCount > 0) {
                                        if (this.ballNb == 0) {
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX - 1, this.ballPosY - 1, 4, 4, this.ballPosX - 1, this.ballPosY - 1);
                                        } else {
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.ballPosY, this.ballWidth, this.ballWidth, this.ballPosX, this.ballPosY);
                                        }
                                    }
                                    this.ballNb = HIT_BALL_INFO2[this.hitRs] >> this.moveBallCount * 2 & 3;
                                    this.ballWidth = BALL_IMAGE_INFO[this.ballNb] & 0xFF;
                                    this.ballPosX = 59 + (this.ballEndX - 59) * this.moveBallCount / endAniCount - this.ballWidth / 2;
                                    this.ballPosY = 105 + (this.ballEndY - 105) * this.moveBallCount / endAniCount - this.ballWidth / 2;
                                } else if (this.moveBallCount <= endAniCount + 3) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX - 1, this.ballPosY - 1, 4, 4, this.ballPosX - 1, this.ballPosY - 1);
                                    --this.ballPosY;
                                    if (this.ballPosY < 10) {
                                        this.ballPosY = 10;
                                    }
                                    if (Math.abs((this.ballEndX - 59) * 3) > Math.abs(this.ballEndY - 105)) {
                                        this.ballPosX += (this.ballEndX - 59) / Math.abs(this.ballEndX - 59);
                                        if (this.ballPosX < 0) {
                                            this.ballPosX = 0;
                                        } else if (this.ballPosX > 126) {
                                            this.ballPosX = 126;
                                        }
                                    }
                                }
                                GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, this.ballPosX, this.ballPosY, this.ballNb);
                                if (this.ballNb == 0) {
                                    Drawer.drawRect(GameCanvas.this.offScreen, this.ballPosX - 1, this.ballPosY - 1, 4, 4, -2);
                                }
                                int n15 = this.defenseNb == 2 ? 4 : 2;
                                if (this.moveBallCount < 4) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, defensePos[n15][0], defensePos[n15][1], 11, 13, defensePos[n15][0], defensePos[n15][1]);
                                    GameCanvas.defensePos[n15][0] = defensePos[n15][0] + (54 - defensePos[n15][0]) / (4 - this.moveBallCount);
                                    GameCanvas.defensePos[n15][1] = defensePos[n15][1] + (40 - defensePos[n15][1]) / (4 - this.moveBallCount);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, defensePos[n15][0], defensePos[n15][1], 11, 13, n15 == 2 ? 33 : 22, 0);
                                } else if (this.moveBallCount == 4) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen2, runnerImg, defensePos[n15][0], defensePos[n15][1], 11, 13, 0, 0);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, defensePos[n15][0], defensePos[n15][1], 11, 13, 0, 0);
                                }
                                if (this.defenseNb == 1 || this.defenseNb == 3) {
                                    int n16 = n15 = this.defenseNb == 1 ? 93 : 16;
                                    if (this.moveBallCount < 6) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, defensePos[0][0], defensePos[0][1], 11, 13, defensePos[0][0], defensePos[0][1]);
                                        GameCanvas.defensePos[0][0] = defensePos[0][0] + (n15 - defensePos[0][0]) / (6 - this.moveBallCount);
                                        GameCanvas.defensePos[0][1] = defensePos[0][1] + (67 - defensePos[0][1]) / (6 - this.moveBallCount);
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, defensePos[0][0], defensePos[0][1], 11, 13, n15 == 93 ? 22 : 33, 0);
                                    } else if (this.moveBallCount == 6) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen2, runnerImg, defensePos[0][0], defensePos[0][1], 11, 13, 0, 0);
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, defensePos[0][0], defensePos[0][1], 11, 13, 0, 0);
                                    }
                                }
                                Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, defensePos[this.defenseNb][0], defensePos[this.defenseNb][1], 11, 13, defensePos[this.defenseNb][0], defensePos[this.defenseNb][1]);
                                if (attacker == 1 && this.hitRs != 1) {
                                    n3 = 0;
                                    if (curPressKey != -100 || prePressKey != -100) {
                                        n10 = curPressKey != -100 ? curPressKey : prePressKey;
                                        prePressKey = -100;
                                        if (!this.firstMove) {
                                            this.firstMove = true;
                                            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, defensePos[this.defenseNb][0] + 2, defensePos[this.defenseNb][1] - 6, 7, 4, defensePos[this.defenseNb][0] + 2, defensePos[this.defenseNb][1] - 6);
                                        }
                                        if (n10 == 42 || n10 == -3) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[0] = nArray[0] - 2;
                                            if (defensePos[this.defenseNb][1] >= 14) {
                                                if (defensePos[this.defenseNb][0] < -5) {
                                                    GameCanvas.defensePos[this.defenseNb][0] = 0;
                                                }
                                            } else if (defensePos[this.defenseNb][1] >= 10) {
                                                if (defensePos[this.defenseNb][0] < 13) {
                                                    GameCanvas.defensePos[this.defenseNb][0] = 13;
                                                }
                                            } else if (defensePos[this.defenseNb][0] < 22) {
                                                GameCanvas.defensePos[this.defenseNb][0] = 22;
                                            }
                                            n3 = 33;
                                        } else if (n10 == 35 || n10 == -4) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[0] = nArray[0] + 2;
                                            if (defensePos[this.defenseNb][1] >= 14) {
                                                if (defensePos[this.defenseNb][0] > 117) {
                                                    GameCanvas.defensePos[this.defenseNb][0] = 117;
                                                }
                                            } else if (defensePos[this.defenseNb][1] >= 10) {
                                                if (defensePos[this.defenseNb][0] > 107) {
                                                    GameCanvas.defensePos[this.defenseNb][0] = 107;
                                                }
                                            } else if (defensePos[this.defenseNb][0] > 98) {
                                                GameCanvas.defensePos[this.defenseNb][0] = 98;
                                            }
                                            n3 = 22;
                                        } else if (n10 == 56 || n10 == -1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[1] = nArray[1] - 2;
                                            if (Math.abs(defensePos[this.defenseNb][0] + 5 - 64) < 38) {
                                                if (defensePos[this.defenseNb][1] < 5) {
                                                    GameCanvas.defensePos[this.defenseNb][1] = 5;
                                                }
                                            } else if (Math.abs(defensePos[this.defenseNb][0] + 5 - 64) < 47) {
                                                if (defensePos[this.defenseNb][1] < 10) {
                                                    GameCanvas.defensePos[this.defenseNb][1] = 10;
                                                }
                                            } else if (defensePos[this.defenseNb][1] < 14) {
                                                GameCanvas.defensePos[this.defenseNb][1] = 14;
                                            }
                                            n3 = 11;
                                        } else if (n10 == 48 || n10 == -2) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[1] = nArray[1] + 2;
                                            if (defensePos[this.defenseNb][1] > 85) {
                                                GameCanvas.defensePos[this.defenseNb][1] = 85;
                                            }
                                            n3 = 0;
                                        }
                                    }
                                } else if (this.hitRs == 5) {
                                    if (this.moveBallCount < 7) {
                                        int[] nArray = defensePos[this.defenseNb];
                                        nArray[1] = nArray[1] - 2;
                                        n3 = 11;
                                    }
                                } else {
                                    n3 = 0;
                                    if (this.hitRs == 4 && this.moveBallCount >= endAniCount) {
                                        if (defensePos[this.defenseNb][0] + 5 - this.ballPosX > 1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[0] = nArray[0] - 1;
                                            n3 = 33;
                                        } else if (defensePos[this.defenseNb][0] + 5 - this.ballPosX < -1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[0] = nArray[0] + 1;
                                            n3 = 22;
                                        } else if (defensePos[this.defenseNb][1] + 6 - this.ballPosY > 1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[1] = nArray[1] - 1;
                                            n3 = 11;
                                        } else if (defensePos[this.defenseNb][1] + 6 - this.ballPosY < -1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[1] = nArray[1] + 1;
                                            n3 = 0;
                                        }
                                    } else {
                                        n10 = 2;
                                        if (this.hitRs == 4) {
                                            n10 = 1;
                                        }
                                        if (defensePos[this.defenseNb][0] + 5 - this.firstBoundX > 1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[0] = nArray[0] - n10;
                                            n3 = 33;
                                        } else if (defensePos[this.defenseNb][0] + 5 - this.firstBoundX < -1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[0] = nArray[0] + n10;
                                            n3 = 22;
                                        } else if (defensePos[this.defenseNb][1] + 6 - this.firstBoundY > 1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[1] = nArray[1] - n10;
                                            n3 = 11;
                                        } else if (defensePos[this.defenseNb][1] + 6 - this.firstBoundY < -1) {
                                            int[] nArray = defensePos[this.defenseNb];
                                            nArray[1] = nArray[1] + n10;
                                            n3 = 0;
                                        }
                                    }
                                }
                                Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, defensePos[this.defenseNb][0], defensePos[this.defenseNb][1], 11, 13, n3, 0);
                                if (this.moveBallCount < this.firstBound && this.hitRs != 1 && attacker == 1) {
                                    Drawer.drawLine(GameCanvas.this.offScreen, this.firstBoundX - 2, this.firstBoundY - 2, this.firstBoundX + 2, this.firstBoundY + 2, -5);
                                    Drawer.drawLine(GameCanvas.this.offScreen, this.firstBoundX + 2, this.firstBoundY - 2, this.firstBoundX - 2, this.firstBoundY + 2, -5);
                                } else if (this.moveBallCount == this.firstBound) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.firstBoundX - 2, this.firstBoundY - 2, 5, 5, this.firstBoundX - 2, this.firstBoundY - 2);
                                    GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, this.ballPosX, this.ballPosY, this.ballNb);
                                }
                                if (this.ballNb == 0 && Math.abs(defensePos[this.defenseNb][0] + 5 - this.ballPosX) < 5 && Math.abs(defensePos[this.defenseNb][1] + 6 - this.ballPosY) < 6) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX - 1, this.ballPosY - 1, this.ballWidth + 2, this.ballWidth + 2, this.ballPosX - 1, this.ballPosY - 1);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen2, runnerImg, defensePos[this.defenseNb][0], defensePos[this.defenseNb][1], 11, 13, 0, 0);
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, defensePos[this.defenseNb][0], defensePos[this.defenseNb][1], 11, 13, 0, 0);
                                    if (this.moveBallCount > this.firstBound) {
                                        this.flyBall = false;
                                    } else {
                                        this.flyBall = true;
                                        this.outInDefense(0);
                                        if (this.defenseState == 4) break;
                                    }
                                    this.moveBallCount = 0;
                                    prePressKey = -100;
                                    curPressKey = -100;
                                    this.defenseState = 2;
                                    n10 = 0;
                                    while (n10 < this.runnerNb) {
                                        n2 = this.runnerArray[n10] >> 4 & 7;
                                        n = this.runnerArray[n10] & 0xF;
                                        if (this.flyBall) {
                                            this.runnerVelo[n10] = -1;
                                        } else if (n2 > 0 && this.runnerVelo[n10] > 0) {
                                            n9 = 0;
                                            if (n10 > 0) {
                                                int n17 = n9 = (this.runnerArray[n10 - 1] >> 4 & 7) == n2 - 1 && this.runnerVelo[n10 - 1] > 0 ? 1 : 0;
                                            }
                                            if (this.throwBallCount[(n2 + 1) % 4] <= 16 - n + 2 && n9 == 0 && n <= 10) {
                                                if (Math.abs(this.throwBallCount[(n2 + 1) % 4] - (16 - n)) <= 2) {
                                                    if (Math.abs(ran.nextInt()) % 10 < 5) {
                                                        this.runnerVelo[n10] = -1;
                                                    }
                                                } else {
                                                    this.runnerVelo[n10] = -1;
                                                }
                                            }
                                            if (n == 0 && this.runnerVelo[n10] < 0) {
                                                this.runnerVelo[n10] = 0;
                                            }
                                        }
                                        ++n10;
                                    }
                                    break;
                                }
                                if (this.moveBallCount == endAniCount && this.defenseState != 2 && this.hitRs == 5) {
                                    this.defenseState = 1;
                                }
                                if (this.moveBallCount == this.firstBound && this.defenseState != 2 && (this.hitRs == 1 || this.hitRs == 2)) {
                                    n10 = 1;
                                    while (n10 < this.runnerNb) {
                                        this.runnerVelo[n10] = 1;
                                        ++n10;
                                    }
                                }
                                ++this.moveBallCount;
                                break;
                            }
                            case 1: {
                                if (!this.moveRunner) {
                                    this.defenseState = 4;
                                    break;
                                }
                                ++this.moveBallCount;
                                if (this.moveBallCount / 3 % 2 == 0) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, 32, 14, 56, 13, 0, 11);
                                    break;
                                }
                                Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, 32, 14, 56, 13, 56, 11);
                                break;
                            }
                            case 2: {
                                if (this.moveBallCount == 0) {
                                    this.moveBallCount = 1;
                                    n10 = 0;
                                    while (n10 < 4) {
                                        this.throwBallCount[n10] = Math.abs(RUNNER_POS[n10][0] - this.ballPosX) + Math.abs(RUNNER_POS[n10][0] - this.ballPosY);
                                        int n18 = n10;
                                        this.throwBallCount[n18] = this.throwBallCount[n18] - 15;
                                        this.throwBallCount[n10] = this.throwBallCount[n10] < 0 ? 0 : this.throwBallCount[n10] / 25 + 1;
                                        int n19 = n10;
                                        this.throwBallCount[n19] = this.throwBallCount[n19] + 1;
                                        if (this.curBallIs == -1 && this.defenseNb >= 5) {
                                            int n20 = n10;
                                            this.throwBallCount[n20] = this.throwBallCount[n20] + 2;
                                            if (this.hitRs == 4) {
                                                int n21 = n10;
                                                this.throwBallCount[n21] = this.throwBallCount[n21] + 1;
                                            }
                                        } else if (this.throwBallCount[n10] > 2) {
                                            int n22 = n10;
                                            this.throwBallCount[n22] = this.throwBallCount[n22] - 1;
                                        }
                                        ++n10;
                                    }
                                    if (this.curBallIs != -1) {
                                        Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.ballPosY, this.ballWidth, this.ballWidth, this.ballPosX, this.ballPosY);
                                        if (this.flyBall) {
                                            n9 = 0;
                                            while (n9 < this.runnerNb) {
                                                n2 = this.runnerArray[n9] >> 4 & 7;
                                                n = this.runnerArray[n9] & 0xF;
                                                if (n2 % 4 == this.curBallIs) {
                                                    if (n != 0) {
                                                        this.outInDefense(n9);
                                                    } else {
                                                        Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, RUNNER_POS[n2][0] - 7, RUNNER_POS[n2][1] - 12, 23, 11, 125, 0);
                                                        GameCanvas.this.repaint();
                                                        GameCanvas.this.pause(300);
                                                        Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, RUNNER_POS[n2][0] - 7, RUNNER_POS[n2][1] - 12, 23, 11, RUNNER_POS[n2][0] - 7, RUNNER_POS[n2][1] - 12);
                                                    }
                                                }
                                                ++n9;
                                            }
                                        } else {
                                            n9 = this.curBallIs - 1;
                                            if (n9 < 0) {
                                                n9 = 3;
                                            }
                                            if (n9 < this.runnerNb && (n2 = this.runnerArray[n9] >> 4 & 7) == n9) {
                                                this.outInDefense(n9);
                                                if (this.defenseState == 4) break;
                                            }
                                            n8 = 0;
                                            while (n8 < this.runnerNb) {
                                                n2 = this.runnerArray[n8] >> 4 & 7;
                                                n = this.runnerArray[n8] & 0xF;
                                                if (n2 % 4 == this.curBallIs && n == 0) {
                                                    n12 = RUNNER_POS[n2][0];
                                                    n11 = RUNNER_POS[n2][1];
                                                    if (this.runnerVelo[n8] != 0 && ran.nextInt() % 2 != 0) {
                                                        this.outInDefense(n8);
                                                    } else {
                                                        Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, n12 - 7, n11 - 12, 23, 11, 125, 0);
                                                        GameCanvas.this.repaint();
                                                        GameCanvas.this.pause(300);
                                                        Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, n12 - 7, n11 - 12, 23, 11, n12 - 7, n11 - 12);
                                                    }
                                                }
                                                ++n8;
                                            }
                                        }
                                    }
                                }
                                if (attacker == 1) {
                                    if (curPressKey != -100 || prePressKey != -100) {
                                        n10 = curPressKey != -100 ? curPressKey : prePressKey;
                                        prePressKey = -100;
                                        if (this.curBallIs != 3 && (n10 == 42 || n10 == -3)) {
                                            this.throwWhere = 3;
                                            this.defenseState = 3;
                                        } else if (this.curBallIs != 1 && (n10 == 35 || n10 == -4)) {
                                            this.throwWhere = 1;
                                            this.defenseState = 3;
                                        } else if (this.curBallIs != 2 && (n10 == 56 || n10 == -1)) {
                                            this.throwWhere = 2;
                                            this.defenseState = 3;
                                        } else if (this.curBallIs != 0 && (n10 == 48 || n10 == -2)) {
                                            this.throwWhere = 0;
                                            this.defenseState = 3;
                                        }
                                    }
                                } else {
                                    n10 = -1;
                                    if (this.curBallIs != -1) {
                                        n9 = 0;
                                        while (n9 < this.runnerNb) {
                                            n2 = this.runnerArray[n9] >> 4 & 7;
                                            n = this.runnerArray[n9] & 0xF;
                                            if (n > 0 && ((n2 + 1) % 4 == this.curBallIs && this.runnerVelo[n9] > 0 || n2 == this.curBallIs && this.runnerVelo[n9] < 0)) {
                                                n10 = this.curBallIs;
                                            }
                                            ++n9;
                                        }
                                    }
                                    if (n10 == -1) {
                                        n10 = -1;
                                        n9 = 0;
                                        while (n9 < this.runnerNb) {
                                            n2 = this.runnerArray[n9] >> 4 & 7;
                                            n = this.runnerArray[n9] & 0xF;
                                            if (n2 == n9 && this.throwBallCount[(n2 + 1) % 4] <= 16 - n) {
                                                n10 = (n2 + 1) % 4;
                                            }
                                            ++n9;
                                        }
                                        if (n10 == -1) {
                                            n8 = 1000;
                                            n7 = this.runnerNb - 1;
                                            while (n7 >= 0) {
                                                n2 = this.runnerArray[n7] >> 4 & 7;
                                                n = this.runnerArray[n7] & 0xF;
                                                if (this.runnerVelo[n7] > 0) {
                                                    ++n2;
                                                }
                                                if (n8 > this.throwBallCount[n2 % 4] - (16 - n)) {
                                                    n10 = n2 % 4;
                                                    n8 = this.throwBallCount[n2 % 4] - (16 - n);
                                                }
                                                --n7;
                                            }
                                        }
                                        if (n10 != this.curBallIs && n10 > 0) {
                                            this.throwWhere = n10;
                                            this.defenseState = 3;
                                        }
                                    }
                                }
                                if (this.defenseState == 3) {
                                    this.moveBallCount = 0;
                                    this.ballStartX = this.ballPosX;
                                    this.ballStartY = this.ballPosY;
                                    this.ballEndX = RUNNER_POS[this.throwWhere][0] + 6;
                                    this.ballEndY = RUNNER_POS[this.throwWhere][1] + 6;
                                }
                                if (this.moveBallCount == 0 || this.defenseState != 2 || this.moveRunner) break;
                                this.defenseState = 4;
                                break;
                            }
                            case 3: {
                                if (this.moveBallCount > 0) {
                                    Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, this.ballPosX, this.ballPosY, this.ballWidth, this.ballWidth, this.ballPosX, this.ballPosY);
                                }
                                this.ballNb = 1;
                                this.ballWidth = BALL_IMAGE_INFO[this.ballNb] & 0xFF;
                                this.ballPosX = this.ballStartX + (this.ballEndX - this.ballStartX) * this.moveBallCount / this.throwBallCount[this.throwWhere] - this.ballWidth / 2;
                                this.ballPosY = this.ballStartY + (this.ballEndY - this.ballStartY) * this.moveBallCount / this.throwBallCount[this.throwWhere] - this.ballWidth / 2;
                                GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, this.ballPosX, this.ballPosY, this.ballNb);
                                if (this.moveBallCount == this.throwBallCount[this.throwWhere]) {
                                    this.moveBallCount = 0;
                                    this.curBallIs = this.throwWhere;
                                    this.defenseState = 2;
                                    break;
                                }
                                ++this.moveBallCount;
                                break;
                            }
                            case 4: {
                                if (this.hitRs > 2) {
                                    GameCanvas.this.nextBatter(true);
                                    int n23 = attacker;
                                    hitScore[n23] = hitScore[n23] + 1;
                                } else {
                                    GameCanvas.this.nextBatter(false);
                                }
                                this.moveBallCount = 0;
                                ballCount = 0;
                                strikeCount = 0;
                                if (outCount > 2) {
                                    outCount = 0;
                                    GameCanvas.this.pause(500);
                                    GameCanvas.this.changeAttacker();
                                    break;
                                }
                                GameCanvas.this.pause(1000);
                                int n24 = attacker;
                                gameScore[n24] = gameScore[n24] + this.homeinNb;
                                int[] nArray = inningScore[curInning];
                                int n25 = attacker;
                                nArray[n25] = nArray[n25] + this.homeinNb;
                                runnerInfo = 0;
                                n10 = 0;
                                while (n10 < this.runnerNb) {
                                    n2 = this.runnerArray[n10] >> 4 & 7;
                                    runnerInfo |= 1 << n2 - 1;
                                    ++n10;
                                }
                                GameCanvas.this.drawAttackScreen2();
                                GameCanvas.this.drawPlayerInfo();
                                playState = 4;
                            }
                        }
                        GameCanvas.this.repaint();
                        GameCanvas.this.pause(200);
                        break;
                    }
                    case 10: {
                        int n10 = 0;
                        int n9 = 0;
                        int n8 = 0;
                        int n7 = 0;
                        int n26 = 1;
                        while (n26 < 11) {
                            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, n10, n9, 4, 4, n10, n9);
                            Drawer.drawClipImage(GameCanvas.this.offScreen, GameCanvas.this.offImage2, n8, n7, 11, 13, n8, n7);
                            n10 = RUNNER_POS[0][0] + (RUNNER_POS[stealRunner + 1][0] - RUNNER_POS[0][0]) * n26 / 10 + 6 - 2;
                            n9 = RUNNER_POS[0][1] + (RUNNER_POS[stealRunner + 1][1] - RUNNER_POS[0][1]) * n26 / 10 + 6 - 2;
                            n8 = RUNNER_POS[stealRunner][0] + (RUNNER_POS[stealRunner + 1][0] - RUNNER_POS[stealRunner][0]) * (n26 + 5) / 15;
                            n7 = RUNNER_POS[stealRunner][1] + (RUNNER_POS[stealRunner + 1][1] - RUNNER_POS[stealRunner][1]) * (n26 + 5) / 15;
                            GameCanvas.this.drawBallImg(GameCanvas.this.offScreen, n10, n9, 1);
                            Drawer.drawClipImage(GameCanvas.this.offScreen, runnerImg, n8, n7, 11, 13, 33, 13);
                            GameCanvas.this.repaint();
                            GameCanvas.this.pause(150);
                            ++n26;
                        }
                        int n27 = 0;
                        int n28 = 0;
                        if (stealRunner == 2) {
                            n27 = 10;
                        }
                        n28 = this.ballVelo > 145 ? 30 - n27 : (this.ballVelo > 133 ? 50 - n27 : 70 - n27);
                        runnerInfo &= ~(1 << stealRunner - 1);
                        if (Math.abs(ran.nextInt()) % 100 < n28) {
                            Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, n8 - 7, n7 - 12, 23, 11, 125, 0);
                            runnerInfo |= 1 << stealRunner;
                        } else {
                            Drawer.drawClipImage(GameCanvas.this.offScreen, decisionImg, n8 - 5, n7 - 12, 20, 11, 67, 0);
                            ++outCount;
                        }
                        GameCanvas.this.repaint();
                        GameCanvas.this.pause(700);
                        if (outCount > 2) {
                            outCount = 0;
                            ballCount = 0;
                            strikeCount = 0;
                            GameCanvas.this.changeAttacker();
                        } else {
                            GameCanvas.this.drawAttackScreen2();
                            GameCanvas.this.drawBatter(0);
                            generalThread.setDirection(5);
                            GameCanvas.this.drawHelpImg2();
                            playState = 0;
                        }
                        GameCanvas.this.repaint();
                        GameCanvas.this.pause(400);
                        break;
                    }
                    case 11: {
                        if (GameCanvas.this.drawChangeWin()) {
                            GameCanvas.this.repaint();
                            playState = 9;
                            break;
                        }
                        playState = 0;
                        break;
                    }
                    default: {
                        GameCanvas.this.pause(100);
                    }
                }
            }
        }
    }
}

