<?
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| #                            POEM HACK                             # ||
|| #                    Programmed by AL3NDALEEB                      # ||
|| #                        al3ndaleeb@uk2.net                        # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

function fetch_poem_definitions(&$bbcodes)
{
	global $vboptions;

	if ($vboptions['allowedpoem'])
	{
		$bbcodes['custom']['find']['[poem'] = '#\[poe[m] (\s|&quot;|"|\'|)(.*)\\1\](<br>|<br />|\r\n|\n|\r)??(.*)(<br>|<br />|\r\n|\n|\r)??\[/poe[m]\]#esiU';
		$bbcodes['custom']['replace']['[poem'] = "handle_bbcode_normal('\\4', '\\2', '', 'poem')";
		$bbcodes['custom']['recurse']['poem'][0] = array('handler' => 'handle_bbcode_normal');
	}

	if ($vboptions['allowedtexteffect1'])
	{
		$bbcodes['custom']['find']['[grade='] = '#\[grade=(&quot;|"|\'|)(.*)\\1\](<br>|<br />|\r\n|\n|\r)??(.*)(<br>|<br />|\r\n|\n|\r)??\[/grade\]#esiU';
		$bbcodes['custom']['replace']['[grade='] = "handle_bbcode_normal('\\4', '\\2', '', 'grade')";
		$bbcodes['custom']['recurse']['grade'][0] = array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[glint]'] = '#\[glint\](<br>|<br />|\r\n|\n|\r)??(.*)(<br>|<br />|\r\n|\n|\r)??\[/glint\]#esiU';
		$bbcodes['custom']['replace']['[glint]'] = "handle_bbcode_normal('\\2', '', '', 'glint')";
		$bbcodes['custom']['recurse']['glint'][0] =  array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[blink]'] = '#\[blink\](<br>|<br />|\r\n|\n|\r)??(.*)(<br>|<br />|\r\n|\n|\r)??\[/blink\]#esiU';
		$bbcodes['custom']['replace']['[blink]'] = "handle_bbcode_normal('\\2', '', '', 'blink')";
		$bbcodes['custom']['recurse']['blink'][0] =  array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[glow='] = '#\[glow=(&quot;|"|\'|)([0-9a-fA-F]+)\\1\](<br>|<br />|\r\n|\n|\r)??(.*)(<br>|<br />|\r\n|\n|\r)??\[/glow\]#esiU';
		$bbcodes['custom']['replace']['[glow='] = "handle_bbcode_normal('\\4', '\\2', '', 'glow')";
		$bbcodes['custom']['recurse']['glow'][0] = array('handler' => 'handle_bbcode_normal');
	}

	if ($vboptions['allowedtexteffect2'])
	{	
		$bbcodes['custom']['find']['[frame='] = '#\[frame=(&quot;|"|\'|)([0-9]+)[ ]+([0-9]+)[ ]*\\1\](.*)\[/frame\]#esiU';
		$bbcodes['custom']['replace']['[frame='] = "handle_bbcode_normal('\\4', '\\2', '\\3', 'frame')";
		$bbcodes['custom']['recurse']['frame'][0] = array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[hr]'] = '#\[hr\]#esiU';
		$bbcodes['custom']['replace']['[hr]'] = "handle_bbcode_normal('hr', '', '', 'hr')";
		$bbcodes['custom']['recurse']['hr'][0] =  array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[line]'] = '#\[line\]#esiU';
		$bbcodes['custom']['replace']['[line]'] = "handle_bbcode_normal('line', '', '', 'hr')";
		$bbcodes['custom']['recurse']['line'][0] =  array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[mark='] = '#\[mark=(&quot;|"|\'|)([0-9a-fA-F]+)\\1\](.*)\[/mark\]#esiU';
		$bbcodes['custom']['replace']['[mark='] = "handle_bbcode_normal('\\3', '\\2', '', 'mark')";
		$bbcodes['custom']['recurse']['mark'][0] = array('handler' => 'handle_bbcode_normal');

	}

	if ($vboptions['allowedmedia'])
	{	
		$bbcodes['custom']['find']['[ramv]'] = '#\[ramv\](.*)\[/ramv\]#esiU';
		$bbcodes['custom']['replace']['[ramv]'] = "handle_bbcode_normal('\\1', '', '', 'ramv')";
		$bbcodes['custom']['recurse']['ramv'][0] =  array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[rams]'] = '#\[rams\](.*)\[/rams\]#esiU';
		$bbcodes['custom']['replace']['[rams]'] = "handle_bbcode_normal('\\1', '', '', 'rams')";
		$bbcodes['custom']['recurse']['rams'][0] =  array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[media]'] = '#\[media\](.*)\[/media\]#esiU';
		$bbcodes['custom']['replace']['[media]'] = "handle_bbcode_normal('\\1', '', '', 'media')";
		$bbcodes['custom']['recurse']['media'][0] =  array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[flash='] = '#\[flash=(&quot;|"|\'|)(.*)\\1\]([w|W][i|I][d|D][t|T][h|H][=])\\1([0-9]+)\\1[ ]+([h|H][e|E][i|I][g|G][h|H][t|T][=])\\1([0-9]+)\\1\[/flash\]#esiU';
		$bbcodes['custom']['replace']['[flash='] = "handle_bbcode_normal('\\2', '\\4','\\6', 'flash')";
		$bbcodes['custom']['recurse']['flash'][0] = array('handler' => 'handle_bbcode_normal');

		$bbcodes['custom']['find']['[bimg]'] = '#\[bimg\](.*)\[/bimg\]#esiU';
		$bbcodes['custom']['replace']['[bimg]'] = "handle_bbcode_normal('\\1', '', '', 'bimg')";
		$bbcodes['custom']['recurse']['bimg'][0] =  array('handler' => 'handle_bbcode_normal');

	}

	if ($vboptions['allowedjustify'])
	{
		$bbcodes['custom']['find']['[align='] = '#\[align=(&quot;|"|\'|)(right|left|justify|center)\\1\](<br>|<br />|\r\n|\n|\r)??(.*)(<br>|<br />|\r\n|\n|\r)??\[/align\]#esiU';
		$bbcodes['custom']['replace']['[align='] = "handle_bbcode_normal('\\4', '\\2', '', 'align')";
		$bbcodes['custom']['recurse']['align'][0] = array('handler' => 'handle_bbcode_normal');
	}

	if ($vboptions['allowedmove'])
	{	
		$bbcodes['custom']['find']['[move='] = '#\[move=(&quot;|"|\'|)(right|left|up|down)\\1\](.*)\[/move\]#esiU';
		$bbcodes['custom']['replace']['[move='] = "handle_bbcode_normal('\\3', '\\2', '', 'move')";
		$bbcodes['custom']['recurse']['move'][0] = array('handler' => 'handle_bbcode_normal');
	}


}// end function




function handle_bbcode_normal($message, $param1 = '', $param2 = '', $type = '' )
{
	
	// remove empty codes
	if (trim($message) == '' || $type == '')
	{
		return '';
	}

	// remove unnecessary escaped quotes
	$message = str_replace('\\"', '"', $message);
	
	if($type == 'poem'){
		
		// remove smilies from param
		$param1 = strip_smilies($param1);
		
		$param1 = str_replace('\\"', '"', $param1);
		$param1 = str_replace('&quot;', '"', $param1);
				
		$param1_find = array('/([a-z]+:)/si', '/&(?![a-z0-9#]+;)/si', '/&[a-z]+;([a-z0-9#]+;)/si', '/`/si', '/\'/si');
		$param1_replace = array('', '', '', '', '');
		$param1 = preg_replace($param1_find, $param1_replace, $param1);
				
		$param1 = str_replace('"', '&quot;', $param1);		

		$message = strip_bbcode($message, false, true);

		$message = poemtext_get($message);		
		$html = '<div tag="'.$param1.'" style="display:none">'.$message.'</div><script>doPoem(0)</script>';
		
	}elseif($type == 'frame'){
		
		$param1 = intval($param1);
		$param2 = intval($param2);
		if($param1 > 13 || $param1 < 1)
			$param1 = 1;
			
		if($param2 > 100 || $param2 < 0)
			$param2 = 100;
			
		$message = strip_bbcode_by_tag($message,'frame');
		
		$html  ='<center><table border="0" width="'.$param2.'%" cellpadding="0" cellspacing="0">';
		$html .='<tr><td width="1%"><img border="0" src="images/frames/'.$param1.'_cur.gif"></td><td width="33%" background="images/frames/'.$param1.'_u.gif"></td><td width="1%"><img border="0" src="images/frames/'.$param1.'_cul.gif"></td></tr>';
		$html .='<tr><td width="1%" background="images/frames/'.$param1.'_r.gif"></td>';
		$html .='<td align="center" width="33%" background="images/frames/'.$param1.'.gif">'.$message.'</td>';
		$html .='<td width="1%" background="images/frames/'.$param1.'_l.gif"></td></tr>';
		$html .='<tr><td width="1%"><img border="0" src="images/frames/'.$param1.'_cdr.gif"></td><td width="33%" background="images/frames/'.$param1.'_d.gif"></td><td width="1%"><img border="0" src="images/frames/'.$param1.'_cdl.gif"></td></tr>';
		$html .='</table></center>';
		
	}elseif($type == 'hr'){
		
		$html = '<hr noshade size=1>';
		
	}elseif($type == 'grade'){
		
		$param1 = strip_smilies($param1);

		$param1 = str_replace('\\"', '"', $param1);
		$param1 = str_replace('&quot;', '"', $param1);
		
		$param1_find = array('/([a-z]+:)/si', '/&(?![a-z0-9#]+;)/si', '/&[a-z]+;([a-z0-9#]+;)/si', '/`/si', '/\'/si');
		$param1_replace = array('', '', '', '', '');
		$param1 = preg_replace($param1_find, $param1_replace, $param1);

		$param1 = str_replace('"', '&quot;', $param1);
		
		$message = strip_bbcode_by_tag($message,'move');
		
		$html = '<div id="mygradient" tag="'.$param1.'" style="display:none">'.$message.'</div><script>drawGradient()</script>';
		
	}elseif($type == 'flash'){

		if (!preg_match('#^[a-z]+://#si', $message))
			return '';
			
		if( !$arr= @parse_url($message)){
			return '';
		}else{
			if(!isset($arr[path]) || $arr[path]=='/')
				return '';
				
			$message = 'http://'.$arr[host].$arr[path];
		}

		
		$param1 = intval($param1);
		$param2 = intval($param2);
		
		$html = '<div align="center">';
		$html .='<embed src="'.$message.'" width="'.$param1.'" height="'.$param2.'" quality="high" loop="true" menu="false" TYPE="application/x-shockwave-flash" AllowScriptAccess="never" nojava="true"></embed>';
		$html .='</div>';

	}elseif($type == 'glint'){
		
		$message = strip_bbcode_by_tag($message,'move');
		$html = '<div tag="1" id="myglinttext" style="filter:alpha(opacity=0);width:100%;padding:3;margin:-3">'.$message.'</div>';

	}elseif($type == 'ramv'){

		if (!preg_match('#^[a-z]+://#si', $message))
			return '';

		if( !$arr= @parse_url($message)){
			return '';
		}else{
			if(!isset($arr[path]) || $arr[path]=='/')
				return '';
				
			$message = 'http://'.$arr[host].$arr[path];
		}
		
		$html = '<div align="center">';
		$html .='<embed SRC="'.$message.'" type="audio/x-pn-realaudio-plugin" CONSOLE="Clip1" CONTROLS="ImageWindow,ControlPanel,StatusBar" HEIGHT="230" WIDTH=300" AUTOSTART="false" AllowScriptAccess="never" nojava="true"></embed>';
		$html .='</div>';

	}elseif($type == 'rams'){

		if (!preg_match('#^[a-z]+://#si', $message))
			return '';
			
		if( !$arr= @parse_url($message)){
			return '';
		}else{
			if(!isset($arr[path]) || $arr[path]=='/')
				return '';
				
			$message = 'http://'.$arr[host].$arr[path];
		}
							
		$html = '<div align="center">';
		$html .='<embed SRC="'.$message.'" type="audio/x-pn-realaudio-plugin" CONSOLE="Clip1" CONTROLS="ControlPanel,StatusBar" HEIGHT="100" WIDTH=300" AUTOSTART="false" AllowScriptAccess="never" nojava="true"></embed>';
		$html .='</div>';

	}elseif($type == 'media'){

		if (!preg_match('#^[a-z]+://#si', $message))
			return '';

		if( !$arr= @parse_url($message)){
			return '';
		}else{
			if(!isset($arr[path]) || $arr[path]=='/')
				return '';
				
			$message = 'http://'.$arr[host].$arr[path];
		}
					
		$html = '<div align="center">';
		$html .='<embed src="'.$message.'" AllowScriptAccess="never" nojava="true"></embed>';
		$html .='</div>';
		
	}elseif($type == 'blink'){
		
		$message = strip_bbcode_by_tag($message,'move');
		$html = '<span id="myblinktext">'.$message.'</span>';

	}elseif($type == 'glow'){
		
		$message = strip_bbcode_by_tag($message,'move');
		$html = '<div style="filter:glow(Color='.$param1.',Strength=5); width:100%;padding:3;margin:-3">'.$message.'</div>';

	}elseif($type == 'align'){

		$html = '<div align="'.$param1.'">'.$message.'</div>';

	}elseif($type == 'mark'){

		$html = '<span style="background-color:#'.$param1.'">'.$message.'</span>';

	}elseif($type == 'bimg'){

		if (!preg_match('#^[a-z]+://#si', $message))
			return '';

		if( !$arr= @parse_url($message)){
			return '';
		}else{
			if(!isset($arr[path]) || $arr[path]=='/')
				return '';
				
			$message = 'http://'.$arr[host].$arr[path];
		}
					
		$html = '<a href="'.$message.'" target="_blank"><img src="'.$message.'" border="0" width="300" alt="        "></a>';

	}elseif($type == 'move'){
		
		$message = strip_smilies($message);
		$message = strip_bbcode($message, false, true);
		$html = '<marquee direction="'.$param1.'" scrolldelay="120">'.$message.'</marquee>';

	}
	
	return $html;
}

// #################################################################################
function strip_bbcode_by_tag($message,$tag)
{
	$tag = preg_replace('#[^a-z0-9]#i', '', $tag);
	$find[0] = '#\[('.$tag.')=(&quot;|"|\'|)(.+)\\2\]#siU';
	$find[1] = '#\[/('.$tag.')\]#siU';
	$replace[0] = '';
	$replace[1] = '';

	return preg_replace($find, $replace, $message);
}


// #################################################################################  
function poemtext_get($message){

		$msg = '';
  	$message = preg_split('/\r/',$message);
  	foreach( $message as $line ){
  		if(preg_match('/(.*)=(.*)/', $line)){
  			$msg .= $line . "\n";
  		}		
  	}
  	return $msg;
}

?>