<?
/*****************************************************************************/
$send_to = "SmartFormBuilder User <name@name.com>";
$send_from = "www.name.com <name@name.com>";
$subject = " ";
$autoresponder_from = $send_to;
$thanks_msg = "  

       ";
$autoresponder_subject = "Re:  ";
$autoresponder_message = "  

       ";
/***************************************************************************/

do_formmail();

function do_formmail(){
    $form = get_form_data();
    send_mail($form);
    if ($autoresponder_enabled) auto_respond($form);
    done();
}

function get_form_data(){
    $vars = ($_SERVER['REQUEST_METHOD'] == 'GET') ? $_GET : $_POST;
    //strip spaces from all fields
    foreach ($vars as $k=>$v) $vars[$k] = trim($v);
    return $vars;
}

function _build_fields($vars){
    $skip_fields = array(
        'name_from',
        'email_from',
        'email_to',
        'name_to',
        'subject');

    foreach ($vars as $k=>$v)
        if (in_array($k, $skip_fields)) unset($vars[$k]);

    $max_length = 10; // max length of key field
    foreach ($vars as $k=>$v) {
        $klen = strlen($k);
        if (($klen > $max_length) && ($klen < 40))
            $max_length = $klen;
    }

    // make output text
    $out = "";
    foreach ($vars as $k=>$v){
        $k = str_replace('_', ' ', $k);
        $k = ucfirst($k);
        $len_diff = $max_length - strlen($k);
        if ($len_diff > 0)
            $fill = str_repeat('.', $len_diff);
        else
            $fill = '';
        $out .= $k."$fill...: $v\n";
    }
    return $out;
    
}

function send_mail($vars){
    global $send_to, $send_from;
    global $subject;
    global $REMOTE_ADDR;

    global $_FILES;
    $files = array(); //files (field names) to attach in mail
    if (count($_FILES)){
        $files = array_keys($_FILES);
    }

    // build mail
    $date_time = date('Y-m-d H:i:s');
    $mime_delimiter = md5(time());
    $fields = _build_fields($vars);
    $mail = <<<EOF
This is a MIME-encapsulated message

--$mime_delimiter
Content-type: text/plain
Content-Transfer-Encoding: 8bit

   :
$fields
--------------------
REMOTE IP : $REMOTE_ADDR
DATE/TIME : $date_time
EOF;

    if (count($files)){
        foreach ($files as $file){
            $file_name     = $_FILES[$file]['name'];
            $file_type     = $_FILES[$file]['type'];
            $file_tmp_name = $_FILES[$file]['tmp_name'];
            $file_cnt = "";
            $f=@fopen($file_tmp_name, "rb");
            if (!$f)
                continue;
            while($f && !feof($f))
                $file_cnt .= fread($f, 4096);
            fclose($f);
            if (!strlen($file_type)) $file_type="applicaton/octet-stream";
            if ($file_type == 'application/x-msdownload')
                $file_type = "applicaton/octet-stream";

            $mail .= "\n--$mime_delimiter\n";
            $mail .= "Content-type: $file_type\n";
            $mail .= "Content-Disposition: attachment; filename=\"$file_name\"\n";
            $mail .= "Content-Transfer-Encoding: base64\n\n";
            $mail .= chunk_split(base64_encode($file_cnt));
        }
    }
    $mail .= "\n--$mime_delimiter--";

    mail($send_to, $subject, $mail,"Mime-Version: 1.0\r\nFrom: $send_from\r\nContent-Type: multipart/mixed;\n boundary=\"$mime_delimiter\"\r\nContent-Disposition: inline");

}

function done(){
    echo "  

       ";
}

function auto_respond($vars){
    global $autoresponder_from, $autoresponder_message, $autoresponder_subject;
    $_send_to = "$vars[name_from] <".$vars[email_from].">";
    $_send_from = $autoresponder_from;
    mail($_send_to, $subj, $msg, "From: $_send_from");
}
?>

