<?php // PLUGIN_TITLE: Rebuild Thumbnails
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: rebuild_thumbnails.php                               *
 *        Copyright: (C) 2002 Jan Sorgalla                                *
 *            Email: jan@4homepages.de                                    *
 *              Web: http://www.4homepages.de                             *
 *    Scriptversion: 1.7                                                  *
 *                                                                        *
 *    File version:  1.0.3 (by V@no)                                      *
 *                                                                        *
 *    Never released without support from: Nicky (http://www.nicky.net)   *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (Lizenz.txt) fr weitere Informationen.                 *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (Licence.txt) for further information.                              *
 *                                                                        *
 *************************************************************************/

$nozip = 1;
define('IN_CP', 1);

$root_path = "./../../";
define('ROOT_PATH', $root_path);
require(ROOT_PATH.'admin/admin_global.php');
require(ROOT_PATH.'includes/image_utils.php');

if ($action == "") {
  $action = "checkthumbnails";
}

show_admin_header();

$convert_options = init_convert_options();
if ($convert_options['convert_error']) {
  echo $convert_options['convert_error'];
  show_admin_footer();
  exit;
}

function next_step($numoffset, $numimages, $autoredirect, $cat, $dimension, $resize_type, $quality, $remote) {
  global $site_sess;
  $page = $site_sess->url("rebuild_thumbnails.php?action=createthumbnails&numoffset=".$numoffset."&numimages=".$numimages."&autoredirect=".$autoredirect."&dimension=".$dimension."&cat=".$cat."&resize_type=".$resize_type."&quality=".$quality."&remote=".$remote);
if ($autoredirect) {
?>
<script language="javascript">
myvar = "";
timeout = 15;
function dorefresh() {
  window.status="Redirecting"+myvar;
  myvar = myvar + " .";
  timerID = setTimeout("dorefresh();", 100);
  if (timeout > 0) {
    timeout -= 1;
  }
  else {
    clearTimeout(timerID);
    window.status="";
    window.location="<?php echo $page; ?>";
  }
}
dorefresh();
</script>
<?php
}
?>
<br />
<table border="0" cellspacing="0" cellpadding="1">
  <tr>
    <td class="tableseparator">
      <table width="100%" border="0" cellspacing="0" cellpadding="3">
        <tr>
          <td class="tablerow2" align="center">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="<?php echo $page; ?>"><b>Click here to continue</b></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<br />
<?php
}

if ($action == "createthumbnails") {
  if (isset($HTTP_GET_VARS['dimension']) || isset($HTTP_POST_VARS['dimension'])) {
    $dimension = (isset($HTTP_GET_VARS['dimension'])) ? intval($HTTP_GET_VARS['dimension']) : intval($HTTP_POST_VARS['dimension']);
  }
  else {
    $dimension = $config['auto_thumbnail_dimension'];
  }
  if (isset($HTTP_GET_VARS['autoredirect']) || isset($HTTP_POST_VARS['autoredirect'])) {
    $autoredirect = (isset($HTTP_GET_VARS['autoredirect'])) ? intval($HTTP_GET_VARS['autoredirect']) : intval($HTTP_POST_VARS['autoredirect']);
  }
  else {
    $autoredirect = 0;
  }
  if (isset($HTTP_GET_VARS['resize_type']) || isset($HTTP_POST_VARS['resize_type'])) {
    $resize_type = (isset($HTTP_GET_VARS['resize_type'])) ? intval($HTTP_GET_VARS['resize_type']) : intval($HTTP_POST_VARS['resize_type']);
  }
  else {
    $resize_type = $config['auto_thumbnail_resize_type'];
  }
  if (isset($HTTP_GET_VARS['quality']) || isset($HTTP_POST_VARS['quality'])) {
    $quality = (isset($HTTP_GET_VARS['quality'])) ? intval($HTTP_GET_VARS['quality']) : intval($HTTP_POST_VARS['quality']);
  }
  else {
    $quality = $config['auto_thumbnail_quality'];
  }
  if (isset($HTTP_GET_VARS['cat']) || isset($HTTP_POST_VARS['cat'])) {
    $cat = (isset($HTTP_GET_VARS['cat'])) ? intval($HTTP_GET_VARS['cat']) : intval($HTTP_POST_VARS['cat']);
  }
  else {
    $cat = 0;
  }
  if (isset($HTTP_GET_VARS['numimages']) || isset($HTTP_POST_VARS['numimages'])) {
    $numimages = (isset($HTTP_GET_VARS['numimages'])) ? intval($HTTP_GET_VARS['numimages']) : intval($HTTP_POST_VARS['numimages']);
  }
  else {
    $numimages = 0;
  }
  if (isset($HTTP_GET_VARS['numoffset']) || isset($HTTP_POST_VARS['numoffset'])) {
    $numoffset = (isset($HTTP_GET_VARS['numoffset'])) ? intval($HTTP_GET_VARS['numoffset']) : intval($HTTP_POST_VARS['numoffset']);
  }
  else {
    $numoffset = 0;
  }
  if (isset($HTTP_GET_VARS['remote']) || isset($HTTP_POST_VARS['remote'])) {
    $remote = (isset($HTTP_GET_VARS['remote'])) ? intval($HTTP_GET_VARS['remote']) : intval($HTTP_POST_VARS['remote']);
  }
  else {
    $remote = 0;
  }
	if ($cat) {
		$condition = "WHERE cat_id = $cat";
	}else{
		$condition = "";
	}
 show_text_link("Cancel", "rebuild_thumbnails.php");

  $sql = "SELECT COUNT(image_id) as max
          FROM ".IMAGES_TABLE."
          ".$condition;
  $row = $site_db->query_firstrow($sql);
  $max = (isset($row['max'])) ? $row['max'] : 0;

  $numend = $numoffset + $numimages - 1;
  if ($numend + 1 >= $max) {
    $numend = $max;
  }

  $sql = "SELECT image_id, cat_id, image_name, image_media_file, image_thumb_file
          FROM ".IMAGES_TABLE."
          $condition
          ORDER BY cat_id
          LIMIT $numoffset, $numimages";
  $result = $site_db->query($sql);
	$i = $numoffset+1;

  $image_cache = array();
  while ($row = $site_db->fetch_array($result)) {
    echo "<p>".$lang['creating_thumbnail']."<a href=\"".ROOT_PATH."details.php?image_id=".$row['image_id']."\" target=\"_blank\">".$row['image_name']."</a> (".$row['image_media_file'].")\n";
    flush();
    @set_time_limit(90);
    $is_remote = is_remote($row['image_media_file']);
    $name = substr($row['image_media_file'],0,(strlen($row['image_media_file'])-strlen(strrchr($row['image_media_file'],".")))).".".substr(strrchr($row['image_media_file'],"."), 1);
    $media_file = MEDIA_PATH."/".$row['cat_id']."/".$name;
    if ($is_remote && !$remote) {
      echo "<br />&nbsp;&nbsp;&nbsp;<b class=\"marktext\">Remote media file, thumbnail rebuild skiped</b><p>";
    }else{
      if ($is_remote) {
        $media_file = MEDIA_TEMP_PATH."/".md5(time()).".".substr(strrchr($row['image_media_file'],"."), 1);
        $infile = @fopen ($row['image_media_file'], "rb");
        $outfile = @fopen ($media_file, "wb");
        while (!@feof ($infile)) {
          @fwrite($outfile, @fread ($infile, 1024));
        }
        @fclose($outfile);
        @fclose($infile);
      }
      if (file_exists($media_file)) {
        $image = @getimagesize($media_file);
//          if ($image[2] && ($image[2] > 0 && $image[2] < 4)) {
        if ($image && ($image[2] > (($convert_options['convert_tool'] == "gd2") ? 1 : 0) && $image[2] < 4)) {
          if (create_thumbnail($media_file, THUMB_PATH."/".$row['cat_id']."/".$name, $quality, $dimension, $resize_type)) {
            $sql = "UPDATE ".IMAGES_TABLE."
                    SET image_thumb_file = '".$name."'
                    WHERE image_id = ".$row['image_id'];
            $site_db->query($sql);
      
            echo "<br />&nbsp;&nbsp;&nbsp;<b>".$lang['creating_thumbnail_success']."</b><p>";
          }
          else {
            echo "<br />&nbsp;&nbsp;&nbsp;<b class=\"marktext\">".$lang['creating_thumbnail_error']."</b><p>";
          }
        }else{
          echo "<br />&nbsp;&nbsp;&nbsp;<b class=\"marktext\">Unsupported image format, thumbnail rebuild skiped</b><p>";
        }
      }else{
        echo "<br />&nbsp;&nbsp;&nbsp;<b class=\"marktext\">Media file missing, thumbnail rebuild skiped</b><p>";
      }
    }
    if ($is_remote && $remote){
    	unlink($media_file);
  	}
  }
  if ($numend < $max) {
    next_step($numend + 1, $numimages, $autoredirect, $cat, $dimension, $resize_type, $quality, $remote);
  }
  else {
  	echo "<p><b>Thumbnails Rebuild Complete!</b><p>\n";
  	show_text_link("Back", "rebuild_thumbnails.php");
  }


}

if ($action == "checkthumbnails") {
	$category = "\n<select name=\"cat\" class=\"categoryselect\">\n";
	$category .= "<option value=\"0\">".$lang['all_categories']."</option>\n";
	$category .= "<option value=\"0\">-------------------------------</option>\n";
	$drop_down_cat_cache = array();
	$drop_down_cat_cache = $cat_parent_cache;
	$category .= get_category_dropdown_bits(0);
	$category .= "</select>\n";
	$resize = "\n<select name=\"resize_type\">\n";
  foreach ($auto_thumbnail_resize_type_optionlist as $key => $val) {
    $resize .= "<option value=\"$key\"";
    if ($config['auto_thumbnail_resize_type'] == $key) {
      $resize .= " selected=\"selected\"";
    }
    $resize .= ">$val</option>\n";
  }
	$resize .= "</select>\n";


  show_form_header("rebuild_thumbnails.php", "createthumbnails", "form", 1);
  show_table_header("Rebuild Thumbnails", 2);
  show_custom_row("Category", $category);

  show_input_row($lang['convert_thumbnail_dimension'], "dimension", $config['auto_thumbnail_dimension'], 5);
  show_custom_row($lang['resize_proportions_desc'], $resize);


  show_input_row($lang['convert_thumbnail_quality'], "quality", $config['auto_thumbnail_quality'], 5);
  show_radio_row("Rebuild thumbnails for remote images", "remote", 1);

  show_input_row($lang['results_per_page'], "numimages", 50, 5);
  show_radio_row("Include automatic JavaScript redirect to next page", "autoredirect", 1);
  show_form_footer($lang['create_thumbnails'], "", 2);
}


show_admin_footer();
?>