/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.obex.HeaderSet;

public class Util {
    private Util() {
    }

    public static void printRemoteDevice(RemoteDevice dev, DeviceClass devClass) {
        block3: {
            try {
                System.out.println("Print Remote Device " + dev.getBluetoothAddress());
                System.out.println("Name: " + dev.getFriendlyName(true));
                System.out.println("Auth: " + dev.isAuthenticated() + " Encrypted: " + dev.isEncrypted() + " Trusted: " + dev.isTrustedDevice());
                if (devClass == null) break block3;
                System.out.println("MajorDevice:" + Util.majorToName(devClass.getMajorDeviceClass()));
                System.out.println("MinorDevice:" + Util.minorToName(devClass.getMajorDeviceClass(), devClass.getMinorDeviceClass()));
                System.out.println("ServiceClass:");
                String[] str = Util.majorServiceToName(devClass.getServiceClasses());
                int i = 0;
                while (i < str.length) {
                    System.out.println("  " + str[i]);
                    ++i;
                }
            }
            catch (IOException e) {}
        }
    }

    public static void printLocalDevice(LocalDevice dev) {
        System.out.println("Print Local Device " + dev.getBluetoothAddress());
        System.out.println("Name: " + dev.getFriendlyName());
        DeviceClass devClass = dev.getDeviceClass();
        if (devClass != null) {
            System.out.println("MajorDevice:" + Util.majorToName(devClass.getMajorDeviceClass()));
            System.out.println("MinorDevice:" + Util.minorToName(devClass.getMajorDeviceClass(), devClass.getMinorDeviceClass()));
            System.out.println("ServiceClass:");
            String[] str = Util.majorServiceToName(devClass.getServiceClasses());
            int i = 0;
            while (i < str.length) {
                System.out.println("  " + str[i]);
                ++i;
            }
        }
    }

    public static void printServiceRecord(ServiceRecord r) {
        int[] ids = r.getAttributeIDs();
        System.out.println("Print Service Record (# of element: " + ids.length + ")");
        System.out.println("Print Service Record URL " + r.getConnectionURL(0, false));
        int i = 0;
        while (i < ids.length) {
            DataElement el = r.getAttributeValue(ids[i]);
            Util.printDataElement(el, ids[i], "");
            ++i;
        }
    }

    public static void printDataElement(DataElement e, int id, String indent) {
        int type = e.getDataType();
        if (type == 56 || type == 48) {
            Enumeration enumeration = (Enumeration)e.getValue();
            System.out.println(indent + "DataElement[" + Util.idToName(id) + "] " + type + " (# of element: " + e.getSize() + ")");
            while (enumeration.hasMoreElements()) {
                DataElement e2 = (DataElement)enumeration.nextElement();
                Util.printDataElement(e2, id, indent + "  ");
            }
        } else if (type == 8 || type == 9 || type == 10 || type == 16 || type == 17 || type == 18 || type == 19) {
            long v = e.getLong();
            System.out.println(indent + "DataElement[" + Util.idToName(id) + "] " + v);
        } else if (type == 24) {
            UUID uuid = (UUID)e.getValue();
            System.out.println(indent + "DataElement[" + Util.idToName(id) + "] " + Util.uuidToName(uuid));
        } else if (type == 11 || type == 12 || type == 20) {
            byte[] v = (byte[])e.getValue();
            String s = "";
            int i = 0;
            while (i < v.length) {
                s = s + Integer.toHexString(v[i]);
                ++i;
            }
            System.out.println(indent + "DataElement[" + Util.idToName(id) + "] " + s);
        } else if (type == 32 || type == 64) {
            String v = (String)e.getValue();
            System.out.println(indent + "DataElement[" + Util.idToName(id) + "] " + v);
        } else if (type == 40) {
            boolean v = e.getBoolean();
            System.out.println(indent + "DataElement[" + Util.idToName(id) + "] " + String.valueOf(v));
        } else if (type == 0) {
            System.out.println(indent + "DataElement[" + Util.idToName(id) + "] NULL");
        }
    }

    public static String idToName(int id) {
        if (id == 0) {
            return "ServiceRecordHandle";
        }
        if (id == 1) {
            return "ServiceClassIDList";
        }
        if (id == 2) {
            return "ServiceRecordState";
        }
        if (id == 3) {
            return "ServiceID";
        }
        if (id == 4) {
            return "ProtocolDescriptorList";
        }
        if (id == 5) {
            return "BrowseGroupList";
        }
        if (id == 6) {
            return "LanguageBasedAttributeIDList";
        }
        if (id == 7) {
            return "ServiceInfoTimeToLive";
        }
        if (id == 8) {
            return "ServiceAvailability";
        }
        if (id == 9) {
            return "BluetoothProfileDescriptorList";
        }
        if (id == 10) {
            return "DocumentationURL";
        }
        if (id == 11) {
            return "ClientExecutableURL";
        }
        if (id == 12) {
            return "IconURL";
        }
        if (id == 13) {
            return "AdditionalProtocol";
        }
        if (id == 256) {
            return "ServiceName";
        }
        if (id == 257) {
            return "ServiceDescription";
        }
        if (id == 258) {
            return "ProviderName";
        }
        if (id == 512) {
            return "GroupID";
        }
        if (id == 513) {
            return "ServiceDatabaseState";
        }
        if (id == 768) {
            return "ServiceVersion";
        }
        if (id == 769) {
            return "ExternalNetwork";
        }
        if (id == 770) {
            return "RemoteAudioVolumeControl";
        }
        if (id == 771) {
            return "SupportedFormatList";
        }
        if (id == 772) {
            return "FaxClass2Support";
        }
        if (id == 773) {
            return "AudioFeedbackSupport";
        }
        if (id == 774) {
            return "NetworkAddress";
        }
        if (id == 775) {
            return "WAPGateway";
        }
        if (id == 776) {
            return "HomePageURL";
        }
        if (id == 777) {
            return "WAPStackType";
        }
        if (id == 778) {
            return "SecurityDescription";
        }
        if (id == 779) {
            return "NetAccessType";
        }
        if (id == 780) {
            return "MaxNetAccessrate";
        }
        if (id == 781) {
            return "IPv4Subnet";
        }
        if (id == 782) {
            return "IPv6Subnet";
        }
        if (id == 784) {
            return "SupportedCapabalities";
        }
        if (id == 785) {
            return "SupportedFeatures";
        }
        if (id == 786) {
            return "SupportedFunctions";
        }
        if (id == 787) {
            return "TotalImagingDataCapacity";
        }
        return "UnknownAttribute(" + id + ")";
    }

    public static String uuidToName(UUID u) {
        if (u.equals((Object)new UUID(1L))) {
            return "SDP";
        }
        if (u.equals((Object)new UUID(3L))) {
            return "RFCOMM";
        }
        if (u.equals((Object)new UUID(8L))) {
            return "OBEX";
        }
        if (u.equals((Object)new UUID(12L))) {
            return "HTTP";
        }
        if (u.equals((Object)new UUID(256L))) {
            return "L2CAP";
        }
        if (u.equals((Object)new UUID(15L))) {
            return "BNEP";
        }
        if (u.equals((Object)new UUID(4096L))) {
            return "ServiceDiscoveryServerServiceClassID";
        }
        if (u.equals((Object)new UUID(4097L))) {
            return "BrowseGroupDescriptorCerviceClassID";
        }
        if (u.equals((Object)new UUID(4098L))) {
            return "PublicBrowseGroup";
        }
        if (u.equals((Object)new UUID(4353L))) {
            return "SerialPort";
        }
        if (u.equals((Object)new UUID(4354L))) {
            return "LANAccessUsingPPP";
        }
        if (u.equals((Object)new UUID(4355L))) {
            return "DialupNetworking";
        }
        if (u.equals((Object)new UUID(4356L))) {
            return "IrMCSync";
        }
        if (u.equals((Object)new UUID(4357L))) {
            return "OBEX ObjectPushProfile";
        }
        if (u.equals((Object)new UUID(4358L))) {
            return "OBEX FileTrasnferProfile";
        }
        if (u.equals((Object)new UUID(4359L))) {
            return "IrMCSyncCommand";
        }
        if (u.equals((Object)new UUID(4360L))) {
            return "Headset";
        }
        if (u.equals((Object)new UUID(4361L))) {
            return "CordlessTelephony";
        }
        if (u.equals((Object)new UUID(4362L))) {
            return "AudioSource";
        }
        if (u.equals((Object)new UUID(4369L))) {
            return "Fax";
        }
        if (u.equals((Object)new UUID(4370L))) {
            return "HeadsetAudioGateway";
        }
        if (u.equals((Object)new UUID(4373L))) {
            return "PersonalAreaNetworkingUser";
        }
        if (u.equals((Object)new UUID(4374L))) {
            return "NetworkAccessPoint";
        }
        if (u.equals((Object)new UUID(4375L))) {
            return "GroupNetwork";
        }
        if (u.equals((Object)new UUID(4382L))) {
            return "Handsfree";
        }
        if (u.equals((Object)new UUID(4383L))) {
            return "HandsfreeAudioGateway";
        }
        if (u.equals((Object)new UUID(4609L))) {
            return "GenericNetworking";
        }
        if (u.equals((Object)new UUID(4610L))) {
            return "GenericFileTransfer";
        }
        if (u.equals((Object)new UUID(4611L))) {
            return "GenericAudio";
        }
        if (u.equals((Object)new UUID(4612L))) {
            return "GenericTelephony";
        }
        return u.toString();
    }

    public static String majorToName(int d) {
        if (d == 0) {
            return "Miscellaneous";
        }
        if (d == 256) {
            return "Computer";
        }
        if (d == 512) {
            return "Phone";
        }
        if (d == 768) {
            return "LANAccessPoint";
        }
        if (d == 1024) {
            return "AudioVideo";
        }
        if (d == 1280) {
            return "Peripheral";
        }
        if (d == 1536) {
            return "Imaging";
        }
        if (d == 7936) {
            return "Uncategorized";
        }
        return "UnknownMajorDevice(" + d + ")";
    }

    public static String minorToName(int d, int m) {
        if (d == 0) {
            return "Miscellaneous";
        }
        if (d == 256 && m == 0) {
            return "Uncategorized";
        }
        if (d == 256 && m == 4) {
            return "Workstation";
        }
        if (d == 256 && m == 8) {
            return "Server";
        }
        if (d == 256 && m == 12) {
            return "Laptop";
        }
        if (d == 256 && m == 16) {
            return "HandheldPcPda";
        }
        if (d == 256 && m == 20) {
            return "PalmPcPda";
        }
        if (d == 256 && m == 24) {
            return "Wearable";
        }
        if (d == 512 && m == 0) {
            return "Uncategorized";
        }
        if (d == 512 && m == 4) {
            return "Cellular";
        }
        if (d == 512 && m == 8) {
            return "Cordless";
        }
        if (d == 512 && m == 12) {
            return "SmartPhone";
        }
        if (d == 512 && m == 16) {
            return "Modem";
        }
        if (d == 512 && m == 20) {
            return "ISDN";
        }
        if (d == 768 && m == 0) {
            return "FullyAvailable";
        }
        if (d == 768 && m == 32) {
            return "1to17%Utilized";
        }
        if (d == 768 && m == 64) {
            return "17to33%Utilized";
        }
        if (d == 768 && m == 96) {
            return "33to50%Utilized";
        }
        if (d == 768 && m == 128) {
            return "50to67%Utilized";
        }
        if (d == 768 && m == 160) {
            return "67to83%Utilized";
        }
        if (d == 768 && m == 192) {
            return "83to100%Utilized";
        }
        if (d == 768 && m == 224) {
            return "NoServiceAvailable";
        }
        if (d == 1024 && m == 0) {
            return "Uncategorized";
        }
        if (d == 1024 && m == 4) {
            return "Headset";
        }
        if (d == 1024 && m == 8) {
            return "HandsFree";
        }
        if (d == 1024 && m == 12) {
            return "(Reserved)";
        }
        if (d == 1024 && m == 16) {
            return "Microphone";
        }
        if (d == 1024 && m == 20) {
            return "Loudspeaker";
        }
        if (d == 1024 && m == 24) {
            return "Headphones";
        }
        if (d == 1024 && m == 28) {
            return "PortableAudio";
        }
        if (d == 1024 && m == 32) {
            return "CarAudio";
        }
        if (d == 1024 && m == 36) {
            return "SetTopBox";
        }
        if (d == 1024 && m == 40) {
            return "HiFiAudioDevice";
        }
        if (d == 1024 && m == 44) {
            return "VCR";
        }
        if (d == 1024 && m == 48) {
            return "VideoCamera";
        }
        if (d == 1024 && m == 52) {
            return "Camcorder";
        }
        if (d == 1024 && m == 56) {
            return "VideoMonitor";
        }
        if (d == 1024 && m == 60) {
            return "VideoDisplayAndLoudspeaker";
        }
        if (d == 1024 && m == 64) {
            return "VideoConferencing";
        }
        if (d == 1024 && m == 68) {
            return "(Reserved)";
        }
        if (d == 1024 && m == 72) {
            return "GamingToy";
        }
        if (d == 1280 && m == 0) {
            return "Uncategoried";
        }
        if (d == 1280 && m == 4) {
            return "Joystick";
        }
        if (d == 1280 && m == 8) {
            return "Gamepad";
        }
        if (d == 1280 && m == 12) {
            return "RemoteControl";
        }
        if (d == 1280 && m == 16) {
            return "SensingDevice";
        }
        if (d == 1280 && m == 20) {
            return "DigitizerTablet";
        }
        if (d == 1280 && m == 24) {
            return "CardReader";
        }
        if (d == 1280 && m == 64) {
            return "Keyboard";
        }
        if (d == 1280 && m == 128) {
            return "PointingDevice";
        }
        if (d == 1280 && m == 192) {
            return "KeyboardPointingDevice";
        }
        if (d == 1536 && m == 16) {
            return "Display";
        }
        if (d == 1536 && m == 32) {
            return "Camera";
        }
        if (d == 1536 && m == 64) {
            return "Scanner";
        }
        if (d == 1536 && m == 128) {
            return "Printer";
        }
        if (d == 7936) {
            return "Uncategorized(" + m + ")";
        }
        return "UnknownMinorDevice(" + m + ")";
    }

    public static String[] majorServiceToName(int d) {
        Vector<String> v = new Vector<String>();
        if ((d & 0x2000) > 0) {
            v.addElement("LimitedDiscoverableMode");
        }
        if ((d & 0x10000) > 0) {
            v.addElement("Positioning");
        }
        if ((d & 0x20000) > 0) {
            v.addElement("Networking");
        }
        if ((d & 0x40000) > 0) {
            v.addElement("Rendering");
        }
        if ((d & 0x80000) > 0) {
            v.addElement("Capturing");
        }
        if ((d & 0x100000) > 0) {
            v.addElement("ObjectTransfer");
        }
        if ((d & 0x200000) > 0) {
            v.addElement("Audio");
        }
        if ((d & 0x400000) > 0) {
            v.addElement("Telephony");
        }
        if ((d & 0x800000) > 0) {
            v.addElement("Information");
        }
        Object[] str = new String[v.size()];
        v.copyInto(str);
        return str;
    }

    public static void printObexHeaderSet(HeaderSet h) {
        try {
            System.out.println("Print OBEX Header");
            int[] ids = h.getHeaderList();
            int i = 0;
            while (i < ids.length) {
                System.out.println("ID[" + ids[i] + "]: " + h.getHeader(ids[i]));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

