/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery.browser;

import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import net.benhui.btgallery.Util;
import net.benhui.btgallery.browser.DeviceDetailsUI;
import net.benhui.btgallery.browser.ListServicesUI;
import net.benhui.btgallery.browser.RemoteDeviceUI;
import net.benhui.btgallery.browser.ServiceDetailsUI;
import net.benhui.btgallery.browser.ServiceSummaryUI;
import net.benhui.btgallery.browser.ShowValueUI;

public class BTBrowserMain
extends MIDlet
implements CommandListener {
    public static BTBrowserMain instance;
    private static Display display;
    private RemoteDeviceUI remotedeviceui = null;
    private DeviceDetailsUI devicedetailsui = null;
    private ListServicesUI listservicesui = null;
    private ServiceSummaryUI servicesummaryui = null;
    private ServiceDetailsUI servicedetailsui = null;
    private ShowValueUI showvalueui = null;
    LocalDevice device;
    DiscoveryAgent agent;
    public static Vector devices;
    public static Vector deviceClasses;
    public static Vector services;
    public static int selectedDevice;
    public static int selectedService;

    public BTBrowserMain() {
        instance = this;
    }

    public void startApp() {
        display = Display.getDisplay((MIDlet)this);
        this.remotedeviceui = new RemoteDeviceUI();
        this.devicedetailsui = new DeviceDetailsUI();
        this.listservicesui = new ListServicesUI();
        this.servicesummaryui = new ServiceSummaryUI();
        this.servicedetailsui = new ServiceDetailsUI();
        this.showvalueui = new ShowValueUI();
        this.remotedeviceui.showui();
        display.setCurrent((Displayable)this.remotedeviceui);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public static void log(String s) {
        System.out.println(s);
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.remotedeviceui && c.getLabel().equals("Inquiry")) {
            try {
                devices.removeAllElements();
                deviceClasses.removeAllElements();
                this.device = LocalDevice.getLocalDevice();
                this.device.setDiscoverable(10390323);
                this.agent = this.device.getDiscoveryAgent();
                this.agent.startInquiry(10390323, (DiscoveryListener)new Listener());
                this.remotedeviceui.setMsg("[Please Wait...]");
            }
            catch (BluetoothStateException e) {
                e.printStackTrace();
            }
        } else if (d == this.remotedeviceui && c.getLabel().equals("Device Details")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            this.devicedetailsui.showui();
            display.setCurrent((Displayable)this.devicedetailsui);
        } else if (d == this.remotedeviceui && c.getLabel().equals("Explore Services")) {
            selectedDevice = this.remotedeviceui.getSelectedIndex();
            services.removeAllElements();
            RemoteDevice remoteDevice = (RemoteDevice)devices.elementAt(selectedDevice);
            try {
                int[] attr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 256, 257, 258, 512, 513, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 784, 785, 786, 787};
                this.agent.searchServices(attr, new UUID[]{new UUID(256L)}, remoteDevice, (DiscoveryListener)new Listener());
            }
            catch (BluetoothStateException ex) {
                ex.printStackTrace();
            }
        } else if (d == this.remotedeviceui && c.getLabel().equals("Exit")) {
            BTBrowserMain.quitApp();
        } else if (d == this.remotedeviceui && c.getLabel().equals("About BT Browser")) {
            Alert alert = new Alert("About", "JABWT Browser. (c) By Ben Hui. www.benhui.net", null, AlertType.INFO);
            alert.setTimeout(-2);
            display.setCurrent(alert, (Displayable)this.remotedeviceui);
        } else if (d == this.listservicesui && c.getLabel().equals("Service Summary")) {
            selectedService = this.listservicesui.getSelectedIndex();
            this.servicesummaryui.showui();
            display.setCurrent((Displayable)this.servicesummaryui);
        } else if (d == this.listservicesui && c.getLabel().equals("Explore Record")) {
            selectedService = this.listservicesui.getSelectedIndex();
            this.servicedetailsui.showui();
            display.setCurrent((Displayable)this.servicedetailsui);
        } else if (d == this.listservicesui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.remotedeviceui);
        } else if (d == this.devicedetailsui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.remotedeviceui);
        } else if (d == this.servicesummaryui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.listservicesui);
        } else if (d == this.servicedetailsui && c.getLabel().equals("View Value")) {
            int select = this.servicedetailsui.getSelectedIndex();
            String value = (String)this.servicedetailsui.map.get(new Integer(select));
            if (value != null) {
                this.showvalueui.setString(value);
                display.setCurrent((Displayable)this.showvalueui);
            } else {
                Alert alert = new Alert("Problem!", "Cannot select this item", null, AlertType.ERROR);
                alert.setTimeout(3000);
                display.setCurrent(alert, (Displayable)this.servicedetailsui);
            }
        } else if (d == this.servicedetailsui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.listservicesui);
        } else if (d == this.servicedetailsui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.listservicesui);
        } else if (d == this.showvalueui && c.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.servicedetailsui);
        }
    }

    static {
        devices = new Vector();
        deviceClasses = new Vector();
        services = new Vector();
        selectedDevice = -1;
        selectedService = -1;
    }

    class Listener
    implements DiscoveryListener {
        Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            BTBrowserMain.log("A remote Bluetooth device is discovered:");
            Util.printRemoteDevice(remoteDevice, deviceClass);
            devices.addElement(remoteDevice);
            deviceClasses.addElement(deviceClass);
        }

        public void inquiryCompleted(int complete) {
            BTBrowserMain.log("device discovery is completed with return code:" + complete);
            BTBrowserMain.log("" + devices.size() + " devices are discovered");
            if (devices.size() == 0) {
                Alert alert = new Alert("Problem!", "No Bluetooth device found", null, AlertType.INFO);
                alert.setTimeout(3000);
                BTBrowserMain.this.remotedeviceui.setMsg("[Press Inquiry]");
                display.setCurrent(alert, (Displayable)BTBrowserMain.this.remotedeviceui);
            } else {
                BTBrowserMain.this.remotedeviceui.showui();
                display.setCurrent((Displayable)BTBrowserMain.this.remotedeviceui);
            }
        }

        public void servicesDiscovered(int transId, ServiceRecord[] records) {
            BTBrowserMain.log("Remote Bluetooth services is discovered:");
            int i = 0;
            while (i < records.length) {
                ServiceRecord record = records[i];
                Util.printServiceRecord(record);
                services.addElement(record);
                ++i;
            }
        }

        public void serviceSearchCompleted(int transId, int complete) {
            BTBrowserMain.log("service discovery completed with return code:" + complete);
            BTBrowserMain.log("" + services.size() + " services are discovered");
            BTBrowserMain.this.listservicesui.showui();
            display.setCurrent((Displayable)BTBrowserMain.this.listservicesui);
        }
    }
}

