<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 2.9                                                //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Retail Price        : $80.00 United States Dollars                       //
//  WebForum Price      : $00.00 Always 100% Free                            //
//  Supplied by         : South [WTN]                                        //
//  Nullified By        : CyKuH [WTN]                                        //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2003 Belchior Foundry                   //
//***************************************************************************//
define('IN_VCARD', true);
include('./lib.inc.php');
require(VCARD_ROOT_PATH.'admin/define.inc.php');
if (function_exists("set_time_limit")==1 and get_cfg_var("safe_mode")==0)
{
	@set_time_limit(0);
}

check_lvl_access($superuser);

function sqlAddslashes($str = '', $is_like = FALSE)
{
	if ($is_like)
	{
        	$str = str_replace('\\', '\\\\\\\\', $str);
        }else{
		$str = str_replace('\\', '\\\\', $str);
        }
        $str = str_replace('\'', '\\\'', $str);
        return $str;
}

// data dump functions
function sqldumptable($table) {
	global $DB_site;

	$nline = "\n";
	$dump = 'DROP TABLE IF EXISTS ' . $table . ';' . $nline;
	$dump .= 'CREATE TABLE ' . $table . '(' . $nline;
	$firstfield = 1;
	$fields_array = $DB_site->query("SHOW FIELDS FROM $table");
	
	while ($field = $DB_site->fetch_array($fields_array))
	{
		if (!$firstfield)
		{
			$dump .= ",\n";
		}else{
			$firstfield = 0;
		}
		$dump .= "   $field[Field] $field[Type]";
		if (isset($field['Default']) && $field['Default'] != '')
		{
                	$dump .= ' default \'' . sqlAddslashes($field['Default']) . '\'';
		}
		if ($field['Null'] != 'YES')
		{
			$dump .= ' NOT NULL';
		}
		if (!empty($field[Extra]))
		{
			$dump .= " $field[Extra]";
		}
	}
	$DB_site->free_result($fields_array);

	$keysindex_array = $DB_site->query("SHOW KEYS FROM $table");
	while ($key = $DB_site->fetch_array($keysindex_array))
	{
		$kname=$key['Key_name'];
		if ($kname != "PRIMARY" and $key['Non_unique'] == 0)
		{
			$kname="UNIQUE|$kname";
		}
		if(!is_array($index[$kname]))
		{
			$index[$kname] = array();
		}
		$index[$kname][] = $key['Column_name'];
	}
	$DB_site->free_result($keysindex_array);
	
	while(list($kname, $columns) = @each($index))
	{
		$dump .= ",\n";
		$colnames=implode($columns,",");
		if($kname == 'PRIMARY')
		{
			$dump .= "   PRIMARY KEY ($colnames)";
		}else{
			if (substr($kname,0,6) == 'UNIQUE')
			{
				$kname=substr($kname,7);
			}
			$dump .= "   KEY $kname ($colnames)";

		}
	}
	
	$dump .= "\n);\n\n";

	$rows = $DB_site->query("SELECT * FROM $table");
	$numfields=$DB_site->num_fields($rows);
	
	while ($row = $DB_site->fetch_array($rows))
	{
		$dump .= "INSERT INTO $table VALUES(";
		$fieldcounter=-1;
		$firstfield=1;
		while (++$fieldcounter<$numfields)
		{
			if(!$firstfield)
			{
				$dump.=',';
			}else{
				$firstfield=0;
			}
			if (!isset($row[$fieldcounter]))
			{
				$dump .= 'NULL';
			}else{
				$dump .= "'".mysql_escape_string($row[$fieldcounter])."'";
			}
		}
		$dump .= ");\n";
	}
	$DB_site->free_result($rows);
	return $dump;
}

function checktable($table,$loops=0) {
	global $DB_site;
	
	$result=$DB_site->query("CHECK TABLE $table");
	echo '<table width="50%" border="1">';
	echo "<tr bgcolor='#CCCCCC'><td colspan=4 align='center'><b>Checking table $table</b></td></tr>\n";
	echo "<tr><td>Table</td><td>Operation</td><td>Type</td><td>Text</td></tr>\n";
	$error=0;
	while ($r=$DB_site->fetch_array($result))
	{
		if ($r[2]=='error')
		{
			if ($r[3]=="The handler for the table doesn't support check/repair")
			{
			         $r[2] = 'status';
			         $r[3] = 'This table does not support check/repair/optimize';
			         unset($bgcolor);
		        	$nooptimize=1;
			}else{
				$error=1;
				$bgcolor='red';
				unset($nooptimize);
			}
		}else{
			unset($bgcolor);
			unset($nooptimize);
		}
		echo "<tr><td>$r[0]</td><td>$r[1]</td><td bgcolor='$bgcolor'>$r[2]</td><td>$r[3]</td></tr>\n";
	}
	if ($error)
	{
		echo "<tr><td colspan='4' align='center'>Repairing table $table</td></tr>\n";
		$result2=$DB_site->query_first("REPAIR TABLE $table");
		if ($result2[3]!='OK'){
			$bgcolor='red';
		}else{
			unset($bgcolor);
		}
		echo "<tr><td>$result2[0]</td><td>$result2[1]</td><td>$result2[2]</td><td bgcolor='$bgcolor'>$result2[3]</td></tr>\n";
	}
	if (($result2[3]=='OK'||!$error) && !$nooptimize)
	{
		echo "<tr><td colspan='4' align='center'>Optimizing table $table</td></tr>\n";
		$result3=$DB_site->query("OPTIMIZE TABLE $table");
		$error=0;
		while ($r3=$DB_site->fetch_array($result3))
		{
			if ($r3[2]=='error')
			{
				$error=1;
				$bgcolor='red';
			}else{
				unset($bgcolor);
			}
			echo "<tr><td>$r3[0]</td><td>$r3[1]</td><td bgcolor='$bgcolor'>$r3[2]</td><td>$r3[3]</td></tr>\n";
		}
	}
	if ($error && $loops)
	{
		checktable($table,($loops-1));
	}
	echo "</table>\n";
}


if ($action == 'sqltable')
{

	//header("Content-disposition: filename=vcardpro.sql");
	//header("Content-type: unknown/unknown");
	$table = $DB_site->query("SHOW tables");
	unset($temp_buffer);
	while ($row = $DB_site->fetch_array($table))
	{
		if (!empty($row[0]))
		{
			$temp_buffer .= sqldumptable($row[0])."\n\n\n";
		}
	}
	/* show content */
	// zip file
	$file_name = 'vcardbackup-'.date("Y-m-d");
	if ($HTTP_POST_VARS['compress_type'] == 'zip')
	{
		if (VC_PHP_INT_VERSION >= 40000 && @function_exists('gzcompress'))
		{
			$zipfile = new zipfile();
			$zipfile->add_file($temp_buffer, $file_name .'.sql');
			header("Content-disposition: filename=$file_name.zip");
			header("Content-type: unknown/unknown");
			echo $zipfile->file();
		}
	// bzipped file
	}elseif ($HTTP_POST_VARS['compress_type'] == 'bzip'){
		if(VC_PHP_INT_VERSION >= 40004 && @function_exists('bzcompress'))
		{
			header("Content-disposition: filename=$file_name.bz2");
			header("Content-type: unknown/unknown");
			echo bzcompress($temp_buffer);
		} 
	// gzipped file
	}elseif( $HTTP_POST_VARS['compress_type'] == 'gzip'){
		if(VC_PHP_INT_VERSION >= 40004 && @function_exists('gzencode'))
		{
			header("Content-disposition: filename=$file_name.gz");
			header("Content-type: unknown/unknown");
			// without the optional parameter level because it bug
			echo gzencode($temp_buffer);
		}
	// screen
	}else{
		header("Content-disposition: filename=$file_name.sql");
		header("Content-type: unknown/unknown");
		echo $temp_buffer;
	}
	exit;
}

dothml_pageheader();

if ($HTTP_POST_VARS['action']=='optimize_do')
{
	$tables = $DB_site->query("SHOW TABLES");
	if ($iterations)
	{
		$iterations--;
	}
	while ($table=$DB_site->fetch_array($tables))
	{
		$answer=checktable($table[0],$iterations);
		echo '<br><br>';
		flush();
	}
}

if ($HTTP_GET_VARS['action']=='optimize')
{
	dohtml_form_header("backup","optimize_do");
	dohtml_table_header("backup",$msg_admin_dboptimize['Optimize_DB'] .' : '.$dbName );
	dohtml_form_infobox($msg_admin_dboptimize['Notes']);
	if(VC_MYSQL_INT_VERSION > 32314)
	{
		dohtml_form_footer($msg_admin_dboptimize['Start_Optimization']);
	}else{
		dohtml_form_null($msg_admin_dboptimize['MySQL_Error'].dohtml_infourl('http://www.mysql.com/doc/en/Repair.html',0));
	}
}


if ($HTTP_POST_VARS['action']=='sqlfile')
{
	$filehandle = fopen($HTTP_POST_VARS['filename'],"w");
	$result = $DB_site->query("SHOW tables");
	while ($row = $DB_site->fetch_array($result))
	{
		fwrite($filehandle,sqldumptable($row[0])."\n\n\n");
		echo "<p>Dumping $row[0]</p>";
	}
	fclose($filehandle);
	echo "<p><b>$msg_admin_dbbkp_sucessfully</b></p>";
}

if (empty($action))
{
dohtml_form_header("backup","sqltable");
dohtml_table_header("backup",$msg_admin_dbbkp_dbtoinclude);

	$result=$DB_site->query("SHOW tables");
	while ($currow=$DB_site->fetch_array($result))
	{
		dohtml_form_yesno($currow[0],"table[$currow[0]]",1);
	}
	// gzip and bzip2 encode features
	echo "<tr class='".get_row_bg()."' valign='top'><td colspan='2'> Send as file\n";
	if (VC_PHP_INT_VERSION >= 40004)
	{
		$is_zip  = (@function_exists('gzcompress'))?1:0;
	    $is_gzip = (@function_exists('gzencode'))?1:0;
	    $is_bzip = (@function_exists('bzcompress'))?1:0;
	    if ($is_zip || $is_gzip || $is_bzip)
		{
			echo '(';
			if ($is_zip==1)
			{
				echo " <input type='radio' name='compress_type' value='zip'><b>zip</b>ped ";
			}
			if ($is_gzip==1)
			{
				echo " <input type='radio' name='compress_type' value='gzip'><b>gz</b>ipped ";
			}
			if ($is_bzip==1)
			{
				echo " <input type='radio' name='compress_type' value='bzip'>bizpped ";
			}
			echo ')';
	        }
	}
	echo '</td></tr>';
dohtml_form_infobox($msg_admin_dbbkp_dumpviaweb);
dohtml_form_footer($msg_admin_dbbkp_dobackup);


dohtml_form_header("backup","sqlfile");
dohtml_table_header("backup",$msg_admin_dbbkp_serverfile);
dohtml_form_input("    ","filename","./vcardbackup-".date("Y-m-d",time()).".sql",0,60);
dohtml_form_infobox("     777  Admin      .</p>             : <b>$dbName</b>");
dohtml_form_footer("");

}


dothml_pagefooter();
exit;
?>
