<?php
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: memberlist.php (MOD)                                 *
 *        Copyright: (C) 2002 Jan Sorgalla                                *
 *            Email: jan@4homepages.de                                    *
 *              Web: http://www.4homepages.de                             *
 *    Scriptversion: 1.0 for 4images 1.7                                  *
 *                                                                        *
 *    Never released without support from: Nicky (http://www.nicky.net)   *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (http://www.4homepages.de/4images/lizenz.php) fr       *
 *    weitere Informationen.                                              *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (http://www.4homepages.de/4images/lizenz_e.php) for further         *
 *    information.                                                        *
 *                                                                        *
 *************************************************************************/

$templates_used = 'memberlist,memberlist_sort';
$main_template = 'memberlist';

define('GET_CACHES', 1);
define('ROOT_PATH', './');
include(ROOT_PATH.'global.php');
require(ROOT_PATH.'includes/sessions.php');
$user_access = get_permission();
include(ROOT_PATH.'includes/page_header.php');

//----------------------------
//---- Set user per page -----
//----------------------------
$user_per_page = 8;

//----------------------------
//---- Uncomment -------------
//----------------------------

/*
if ($user_info['user_level'] == GUEST || $user_info['user_level'] == USER_AWAITING) {
  show_error_page($lang['no_permission']);
  exit;
}
*/

//--------------------------------
// DON'T CHANGE ANYTHING FROM HERE
//--------------------------------


//----------------------------
//---- Sort ------------------
//----------------------------

if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

$mode_types_text = array($lang['lang_sort_joindate'], $lang['lang_sort_username'], $lang['lang_sort_useremail'],  $lang['lang_sort_homepage']);
$mode_types = array('user_joindate', 'user_name', 'user_email', 'user_homepage');

$select_sort_mode = '<select class="select" name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select class="select" name="order">';
if($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['lang_sort_asc'] . '</option><option value="DESC">' . $lang['lang_sort_desc'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['lang_sort_asc'] . '</option><option value="DESC" selected="selected">' . $lang['lang_sort_desc'] . '</option>';
}
$select_sort_order .= '</select>';

$site_template->register_vars(array(
	'lang_select_sort_method' => $lang['lang_select_sort_method'],
	'lang_select_sort_order' => $lang['lang_select_sort_order'],
	'select_sort_method' => $select_sort_mode,
	'select_sort_order_form' => $select_sort_order,
	'mode_action' => $site_sess->url(ROOT_PATH."memberlist.php"))
);
$userlist = $site_template->parse_template(memberlist_sort);
if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];

	switch( $mode )
	{
		case 'user_joindate':
			$order_by = "user_joindate $sort_order";
			break;
		case 'user_name':
			$order_by = "user_name $sort_order";
			break;
		case 'user_email':
			$order_by = "user_email $sort_order";
			break;
		case 'user_homepage':
			$order_by = "user_homepage $sort_order";
			break;
		default:
			$order_by = "user_name $sort_order";
			break;
	}
}
else
{
	$order_by = "user_joindate $sort_order";
}

$sql = "SELECT COUNT(*) AS total_user 
       FROM ".USERS_TABLE." 
       WHERE user_id <> ".GUEST;
$result = $site_db->query($sql);
while ($row = $site_db->fetch_array($result)) {
   $user_cache[$row['user_id']]['total_user'] = $row['total_user'];
}
$site_db->free_result();

$num_rows_all = (isset($user_cache[$user_id]['total_user'])) ? $user_cache[$user_id]['total_user'] : 0;
$link_arg = $site_sess->url(ROOT_PATH."memberlist.php?mode=$mode&order=$sort_order");
include(ROOT_PATH.'includes/user_paging.php');
$getpaging = new Paging($page, $user_per_page, $num_rows_all, $link_arg);
$offset = $getpaging->get_offset();

$site_template->register_vars(array(
  "paging" => $getpaging->get_paging(),
  "paging_stats" => $getpaging->get_paging_stats()
));


$sql = "SELECT * 
        FROM ".USERS_TABLE." 
        WHERE user_id <> ".GUEST." 
        ORDER BY $order_by 
        LIMIT $offset, $user_per_page";
$result = $site_db->query($sql);
  $userlist .="\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\n<tr>\n<td class=\"bordercolor\">\n";
  $userlist .="<table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"1\">\n";
  $userlist .="<tr>\n<td class=\"head2\" align=\"center\">".$lang['user_name']."</td>\n<td class=\"head2\" align=\"center\">".$lang['join_date']."</td>\n<td class=\"head2\" align=\"center\">".$lang['email']."</td>\n<td class=\"head2\" align=\"center\">".$lang['homepage']."</td>\n<td class=\"head2\" align=\"center\">".$lang['lang_total_user_images']."</td>\n</tr>\n";
  $count = 0;
  $bgcolor = 0;
  while ($user_row = $site_db->fetch_array($result)){
  $user_name = "";
  $user_join_date = "";
  $user_email = "";
  $user_email_save = "";
  $user_mailform_link = "";
  $user_email_button = "";
  $total_user_images = "";
    $user_profile_link = (!empty($url_show_profile)) ? preg_replace("/{user_id}/", $user_row['user_id'], $url_show_profile) : ROOT_PATH."member.php?action=showprofile&amp;".URL_USER_ID."=".$user_row['user_id'];
    $user_name = "<a href=\"".$site_sess->url($user_profile_link)."\">".htmlspecialchars($user_row['user_name'])."</a>";
    $user_homepage = (isset($user_row['user_homepage'])) ? format_url($user_row['user_homepage']) : REPLACE_EMPTY;
    if (!empty($user_homepage) && $user_homepage != REPLACE_EMPTY) {
      $user_homepage_button = "<a href=\"".$user_homepage."\" target=\"_blank\"><img src=\"".get_gallery_image("homepage.gif")."\" border=\"0\" alt=\"".$user_homepage."\" /></a>";
    }
    else {
      $user_homepage_button = REPLACE_EMPTY;
    }
    if (!empty($user_row['user_email']) && (!isset($user_row['user_showemail']) || (isset($user_row['user_showemail']) && $user_row['user_showemail'] == 1))) {
      $user_email = $user_row['user_email'];
      $user_email_save = str_replace("@", " at ", $user_row['user_email']);
      if (!empty($url_mailform)) {
        $user_mailform_link = $site_sess->url(preg_replace("/{user_id}/", $user_row['user_id'], $url_mailform));
      }
      else {
        $user_mailform_link = $site_sess->url(ROOT_PATH."member.php?action=mailform&amp;".URL_USER_ID."=".$user_row['user_id']);
      }
      $user_email_button = "<a href=\"".$user_mailform_link."\"><img src=\"".get_gallery_image("email.gif")."\" border=\"0\" alt=\"".$user_email_save."\" /></a>";
    }
    $user_join_date = (isset($user_row['user_joindate'])) ? format_date($config['date_format'], $user_row['user_joindate']) : REPLACE_EMPTY;
      $sql = "SELECT COUNT(*) AS total_user_images  
              FROM ".USERS_TABLE." u, ".IMAGES_TABLE." i 
              WHERE u.user_id = i.user_id 
              AND i.user_id=".$user_row['user_id']."";
      $row = $site_db->query_firstrow($sql);
      $total_user_images = $row['total_user_images'];


    if ($count == 0) {
      $row_bg_number = ($bgcounter++ % 2 == 0) ? 1 : 2;
      $userlist .= "<tr class=\"imagerow".$row_bg_number."\">\n";
    }
    $userlist .= "<td valign=\"top\" align=\"center\">".$user_join_date."</td>\n";
    $userlist .= "<td valign=\"top\" align=\"center\">".$user_name."</td>\n";
    $userlist .= "<td valign=\"top\" align=\"center\">".$user_email_button."</td>\n";
    $userlist .= "<td valign=\"top\" align=\"center\">".$user_homepage_button."</td>";
    $userlist .= "<td valign=\"top\" align=\"center\">".$total_user_images."</td>";
    $userlist .= "\n</tr>\n";
  }
  $userlist .= "</table>\n";
  $userlist .= "</td>\n</tr>\n</table>\n";
$site_template->register_vars("userlist", $userlist);
unset($userlist);
//-----------------------------------------------------
//--- Clickstream -------------------------------------
//-----------------------------------------------------
$clickstream = "<span class=\"clickstream\"><a href=\"".$site_sess->url(ROOT_PATH."index.php")."\" class=\"clickstream\">".$lang['home']."</a>".$config['category_separator'];
$clickstream .= $lang['lang_userlist_title'];
$clickstream .= $config['category_separator'].$lang['lang_userlist_page'].$page."</span>";

//-----------------------------------------------------
//--- Print Out ---------------------------------------
//-----------------------------------------------------
$site_template->register_vars(array(
  "msg" => $msg,
  "clickstream" => $clickstream,
  "lang_userlist_title" => $lang['lang_userlist_title']
));
$site_template->print_template($site_template->parse_template($main_template));
include(ROOT_PATH.'includes/page_footer.php');
?>
