<?php
/*======================================================================*\
|| سكربت رفع الملفات بدون قواعد بيانات                                ||
|| تطوير وبرمجة: الشبكة الكويتية                                       ||
|| https://kwety.net                                                     ||
|| الإصدار 1.0 — 2026                                                    ||
|| يسمح بالاستخدام والتعديل بحرية.                                      ||
|| هدية بمناسبة شهر رمضان المبارك                                       ||
\*======================================================================*/

include "config.php";
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo SITE_NAME; ?></title>

<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="style.css">
</head>
<body>

<div class="kw-upload">

    <div class="kw-box">

        <!-- العنوان -->
        <div class="kw-header">
            <h1><?php echo SITE_NAME; ?></h1>
            <span>ارفع ملفاتك بسرعة وأمان</span>
        </div>

        <!-- نموذج الرفع -->
        <form action="upload.php" method="post" enctype="multipart/form-data">

            <div class="kw-files">
                <?php for($i=1;$i<=UPLOAD_FIELDS;$i++): ?>
                    <div class="kw-input">
                        <input type="file" name="files[]">
                    </div>
                <?php endfor; ?>
            </div>

            <button type="submit" class="kw-btn">
                رفع الملفات
            </button>

        </form>

        <!-- معلومات -->
        <div class="kw-info">
            الحد الأقصى لكل عملية رفع:
            <?php echo UPLOAD_FIELDS; ?> ملفات
        </div>

        <!-- الحقوق -->
        <div class="kw-rights">
            سكربت رفع الملفات —
            <a href="https://kwety.net" target="_blank">
                برمجة الشبكة الكويتية
            </a>
            © <?php echo date("Y"); ?>
        </div>

    </div>

</div>
<style>
    * {
        font-family: 'Cairo', sans-serif !important;
    }
</style>
</body>
</html>
