<?php
/*======================================================================*\
||سكربت رفع الملفات بدون قواعد بيانات                                ||
|| تطوير وبرمجة: الشبكة الكويتية                                      ||
|| https://kwety.net                                                    ||
||الإصدار 1.0 — 2026                                                     ||
|| يسمح بالاستخدام والتعديل بحرية.                                     ||
|| هدية بمناسبة شهر رمضان المبارك                                      ||
\*======================================================================*/
include "config.php";

$results = array();

/* =========================
   التأكد من وجود ملف واحد على الأقل
========================= */

$hasFile = false;

if(isset($_FILES['files'])){
    foreach($_FILES['files']['name'] as $n){
        if(!empty($n)){
            $hasFile = true;
            break;
        }
    }
}

if(!$hasFile){
    $results[] = array("type"=>"error","msg"=>"لم يتم اختيار أي ملف");
}
else{

    /* =========================
       تحديد الحد الأقصى من الكونفق
    ========================= */

    $totalFiles = count($_FILES['files']['name']);

    if($totalFiles > UPLOAD_FIELDS){
        $results[] = array("type"=>"error","msg"=>"تم تجاوز الحد الأقصى المسموح من الملفات");
    }
    else{

        foreach($_FILES['files']['name'] as $key => $name){

            if(empty($name)) continue;
            if($_FILES['files']['error'][$key] != 0) continue;

            $tmp  = $_FILES['files']['tmp_name'][$key];
            $size = $_FILES['files']['size'][$key];
            $ext  = strtolower(pathinfo($name, PATHINFO_EXTENSION));

            if($size > MAX_FILE_SIZE){
                $results[] = array("type"=>"error","msg"=>"الملف أكبر من الحجم المسموح: $name");
                continue;
            }

            $newName = time() . "_" . rand(1000,9999) . "." . $ext;

            if(in_array($ext, $image_extensions)){
                $targetDir = IMAGE_DIR;
                $publicPath = "files/images/";
            }
            elseif(in_array($ext, $file_extensions)){
                $targetDir = FILE_DIR;
                $publicPath = "files/files/";
            }
            else{
                $results[] = array("type"=>"error","msg"=>"صيغة غير مسموحة: $name");
                continue;
            }

            if(move_uploaded_file($tmp, $targetDir . $newName)){
                $link = $publicPath.$newName;

                $results[] = array(
                    "type"=>"success",
                    "msg"=>"تم رفع الملف بنجاح",
                    "link"=>$link,
                    "name"=>$newName
                );

            } else {
                $results[] = array("type"=>"error","msg"=>"فشل رفع الملف: $name");
            }
        }

    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>نتيجة الرفع</title>

<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="style.css">
</head>
<body>

<div class="kw-upload">

    <div class="kw-box">

        <div class="kw-header">
            <h1>نتيجة الرفع</h1>
            <span>تفاصيل العملية</span>
        </div>

        <?php foreach($results as $r): ?>

            <div class="kw-alert <?php echo ($r['type']=="success") ? "kw-success" : "kw-error"; ?>">

                <div class="kw-alert-text">
                    <?php echo $r['msg']; ?>
                </div>

                <?php if($r['type']=="success"): ?>
                    <div class="kw-links">
                        <input type="text" value="<?php echo "http://".$_SERVER['HTTP_HOST']."/".$r['link']; ?>" readonly>
                        <a href="<?php echo $r['link']; ?>" target="_blank" class="kw-view-btn">عرض الملف</a>
                    </div>
                <?php endif; ?>

            </div>

        <?php endforeach; ?>

        <!-- الحقوق -->
<div class="kw-rights">
    سكربت رفع الملفات —
    <a href="https://kwety.net" target="_blank">
        برمجة الشبكة الكويتية
    </a>
    © <?php echo date("Y"); ?>
</div>

<a href="index.php" class="kw-back-btn">رفع ملفات جديدة</a>

    </div>

</div>

</body>
</html>
